/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.trace.dsl.impl.java;

import com.intellij.debugger.streams.trace.dsl.ArrayVariable;
import com.intellij.debugger.streams.trace.dsl.CodeBlock;
import com.intellij.debugger.streams.trace.dsl.CompositeCodeBlock;
import com.intellij.debugger.streams.trace.dsl.Convertable;
import com.intellij.debugger.streams.trace.dsl.Expression;
import com.intellij.debugger.streams.trace.dsl.ForLoopBody;
import com.intellij.debugger.streams.trace.dsl.IfBranch;
import com.intellij.debugger.streams.trace.dsl.Lambda;
import com.intellij.debugger.streams.trace.dsl.LambdaBody;
import com.intellij.debugger.streams.trace.dsl.ListVariable;
import com.intellij.debugger.streams.trace.dsl.MapVariable;
import com.intellij.debugger.streams.trace.dsl.StatementFactory;
import com.intellij.debugger.streams.trace.dsl.TryBlock;
import com.intellij.debugger.streams.trace.dsl.Types;
import com.intellij.debugger.streams.trace.dsl.Variable;
import com.intellij.debugger.streams.trace.dsl.VariableDeclaration;
import com.intellij.debugger.streams.trace.dsl.impl.AssignmentStatement;
import com.intellij.debugger.streams.trace.dsl.impl.TextExpression;
import com.intellij.debugger.streams.trace.dsl.impl.VariableImpl;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaArrayVariable;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaAssignmentStatement;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaCodeBlock;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaForEachLoop;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaForLoop;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaForLoopBody;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaIfBranch;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaLambda;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaLambdaBody;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaListVariable;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaMapVariable;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaStatementFactory;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaTryBlock;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaTypes;
import com.intellij.debugger.streams.trace.dsl.impl.java.JavaVariableDeclaration;
import com.intellij.debugger.streams.trace.impl.handler.PeekCall;
import com.intellij.debugger.streams.trace.impl.handler.type.GenericType;
import com.intellij.debugger.streams.wrapper.IntermediateStreamCall;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\bH\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0014H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0010H\u0016J \u0010 \u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020\u001bH\u0016J(\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020\b2\u0006\u0010#\u001a\u00020\u001bH\u0016J\u0018\u0010)\u001a\u00020*2\u0006\u0010'\u001a\u00020\b2\u0006\u0010+\u001a\u00020\u0017H\u0016J\u0018\u0010,\u001a\u00020-2\u0006\u0010\u001f\u001a\u00020\u00102\u0006\u0010.\u001a\u00020\u001eH\u0016J\u0018\u0010/\u001a\u0002002\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J(\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u000e2\u0006\u00104\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u00105\u001a\u000206H\u0016J)\u00107\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u00108\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b09\"\u00020\bH\u0016\u00a2\u0006\u0002\u0010:J)\u0010;\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u00108\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b09\"\u00020\bH\u0016\u00a2\u0006\u0002\u0010:J\u0018\u0010<\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010=\u001a\u00020\bH\u0016J\u0018\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\u000e2\u0006\u0010A\u001a\u00020\u0010H\u0016J\u0010\u0010B\u001a\u00020!2\u0006\u0010C\u001a\u00020\u0017H\u0016J\b\u0010D\u001a\u00020&H\u0016J\u0010\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020\u0017H\u0016J\u0018\u0010H\u001a\u00020\u00142\u0006\u0010I\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010J\u001a\u00020&2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010K\u001a\u00020\b2\u0006\u0010L\u001a\u000206H\u0016J\u0018\u0010J\u001a\u00020&2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010L\u001a\u000206H\u0016J\b\u0010M\u001a\u00020\bH\u0016J\u0018\u0010N\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016J\u0010\u0010O\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bH\u0016J\u0018\u0010P\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016J\b\u0010Q\u001a\u00020\bH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006R"}, d2={"Lcom/intellij/debugger/streams/trace/dsl/impl/java/JavaStatementFactory;", "Lcom/intellij/debugger/streams/trace/dsl/StatementFactory;", "()V", "types", "Lcom/intellij/debugger/streams/trace/dsl/Types;", "getTypes", "()Lcom/intellij/debugger/streams/trace/dsl/Types;", "and", "Lcom/intellij/debugger/streams/trace/dsl/Expression;", "left", "right", "createArrayVariable", "Lcom/intellij/debugger/streams/trace/dsl/ArrayVariable;", "elementType", "Lcom/intellij/debugger/streams/trace/impl/handler/type/GenericType;", "name", "", "createAssignmentStatement", "Lcom/intellij/debugger/streams/trace/dsl/impl/AssignmentStatement;", "variable", "Lcom/intellij/debugger/streams/trace/dsl/Variable;", "expression", "createEmptyCodeBlock", "Lcom/intellij/debugger/streams/trace/dsl/CodeBlock;", "createEmptyCompositeCodeBlock", "Lcom/intellij/debugger/streams/trace/dsl/CompositeCodeBlock;", "createEmptyForLoopBody", "Lcom/intellij/debugger/streams/trace/dsl/ForLoopBody;", "iterateVariable", "createEmptyLambdaBody", "Lcom/intellij/debugger/streams/trace/dsl/LambdaBody;", "argName", "createForEachLoop", "Lcom/intellij/debugger/streams/trace/dsl/Convertable;", "collection", "loopBody", "createForLoop", "initialization", "Lcom/intellij/debugger/streams/trace/dsl/VariableDeclaration;", "condition", "afterThought", "createIfBranch", "Lcom/intellij/debugger/streams/trace/dsl/IfBranch;", "thenBlock", "createLambda", "Lcom/intellij/debugger/streams/trace/dsl/Lambda;", "lambdaBody", "createListVariable", "Lcom/intellij/debugger/streams/trace/dsl/ListVariable;", "createMapVariable", "Lcom/intellij/debugger/streams/trace/dsl/MapVariable;", "keyType", "valueType", "linked", "", "createNewArrayExpression", "args", "", "(Lcom/intellij/debugger/streams/trace/impl/handler/type/GenericType;[Lcom/intellij/debugger/streams/trace/dsl/Expression;)Lcom/intellij/debugger/streams/trace/dsl/Expression;", "createNewListExpression", "createNewSizedArray", "size", "createPeekCall", "Lcom/intellij/debugger/streams/wrapper/IntermediateStreamCall;", "elementsType", "lambda", "createScope", "codeBlock", "createTimeVariableDeclaration", "createTryBlock", "Lcom/intellij/debugger/streams/trace/dsl/TryBlock;", "block", "createVariable", "type", "createVariableDeclaration", "init", "isMutable", "currentTimeExpression", "equals", "not", "same", "updateCurrentTimeExpression", "intellij.java.debugger.streams"})
public class JavaStatementFactory
implements StatementFactory {
    @NotNull
    private final Types types = JavaTypes.INSTANCE;

    @Override
    @NotNull
    public Types getTypes() {
        return this.types;
    }

    @Override
    @NotNull
    public CompositeCodeBlock createEmptyCompositeCodeBlock() {
        return new JavaCodeBlock(this);
    }

    @Override
    @NotNull
    public CodeBlock createEmptyCodeBlock() {
        return new JavaCodeBlock(this);
    }

    @Override
    @NotNull
    public VariableDeclaration createVariableDeclaration(@NotNull Variable variable, boolean isMutable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        return new JavaVariableDeclaration(variable, isMutable, null, 4, null);
    }

    @Override
    @NotNull
    public VariableDeclaration createVariableDeclaration(@NotNull Variable variable, @NotNull Expression init, boolean isMutable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)init, (String)"init");
        return new JavaVariableDeclaration(variable, isMutable, Convertable.toCode$default(init, 0, 1, null));
    }

    @Override
    @NotNull
    public ForLoopBody createEmptyForLoopBody(@NotNull Variable iterateVariable) {
        Intrinsics.checkNotNullParameter((Object)iterateVariable, (String)"iterateVariable");
        return new JavaForLoopBody((StatementFactory)this, iterateVariable);
    }

    @Override
    @NotNull
    public Convertable createForEachLoop(@NotNull Variable iterateVariable, @NotNull Expression collection, @NotNull ForLoopBody loopBody) {
        Intrinsics.checkNotNullParameter((Object)iterateVariable, (String)"iterateVariable");
        Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
        Intrinsics.checkNotNullParameter((Object)loopBody, (String)"loopBody");
        return new JavaForEachLoop(iterateVariable, collection, loopBody);
    }

    @Override
    @NotNull
    public Convertable createForLoop(@NotNull VariableDeclaration initialization, @NotNull Expression condition, @NotNull Expression afterThought, @NotNull ForLoopBody loopBody) {
        Intrinsics.checkNotNullParameter((Object)initialization, (String)"initialization");
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Intrinsics.checkNotNullParameter((Object)afterThought, (String)"afterThought");
        Intrinsics.checkNotNullParameter((Object)loopBody, (String)"loopBody");
        return new JavaForLoop(initialization, condition, afterThought, loopBody);
    }

    @Override
    @NotNull
    public LambdaBody createEmptyLambdaBody(@NotNull String argName) {
        Intrinsics.checkNotNullParameter((Object)argName, (String)"argName");
        return new JavaLambdaBody((StatementFactory)this, new TextExpression(argName));
    }

    @Override
    @NotNull
    public Lambda createLambda(@NotNull String argName, @NotNull LambdaBody lambdaBody) {
        Intrinsics.checkNotNullParameter((Object)argName, (String)"argName");
        Intrinsics.checkNotNullParameter((Object)lambdaBody, (String)"lambdaBody");
        boolean bl = lambdaBody instanceof JavaLambdaBody;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return new JavaLambda(argName, (JavaLambdaBody)lambdaBody);
    }

    @Override
    @NotNull
    public Variable createVariable(@NotNull GenericType type, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new VariableImpl(type, name);
    }

    @Override
    @NotNull
    public Expression and(@NotNull Expression left, @NotNull Expression right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        return new TextExpression(Convertable.toCode$default(left, 0, 1, null) + " && " + Convertable.toCode$default(right, 0, 1, null));
    }

    @Override
    @NotNull
    public Expression equals(@NotNull Expression left, @NotNull Expression right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        return new TextExpression("java.util.Objects.equals(" + Convertable.toCode$default(left, 0, 1, null) + ", " + Convertable.toCode$default(right, 0, 1, null));
    }

    @Override
    @NotNull
    public Expression same(@NotNull Expression left, @NotNull Expression right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        return new TextExpression(Convertable.toCode$default(left, 0, 1, null) + " == " + Convertable.toCode$default(right, 0, 1, null));
    }

    @Override
    @NotNull
    public IfBranch createIfBranch(@NotNull Expression condition, @NotNull CodeBlock thenBlock) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Intrinsics.checkNotNullParameter((Object)thenBlock, (String)"thenBlock");
        return new JavaIfBranch(condition, thenBlock, this);
    }

    @Override
    @NotNull
    public AssignmentStatement createAssignmentStatement(@NotNull Variable variable, @NotNull Expression expression) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        return new JavaAssignmentStatement(variable, expression);
    }

    @Override
    @NotNull
    public MapVariable createMapVariable(@NotNull GenericType keyType, @NotNull GenericType valueType, @NotNull String name, boolean linked) {
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        Intrinsics.checkNotNullParameter((Object)valueType, (String)"valueType");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new JavaMapVariable(linked ? this.getTypes().linkedMap(keyType, valueType) : this.getTypes().map(keyType, valueType), name);
    }

    @Override
    @NotNull
    public ArrayVariable createArrayVariable(@NotNull GenericType elementType, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new JavaArrayVariable(this.getTypes().array(elementType), name);
    }

    @Override
    @NotNull
    public Convertable createScope(@NotNull CodeBlock codeBlock) {
        Intrinsics.checkNotNullParameter((Object)codeBlock, (String)"codeBlock");
        return new Convertable(codeBlock){
            final /* synthetic */ CodeBlock $codeBlock;
            {
                this.$codeBlock = $codeBlock;
            }

            @NotNull
            public String toCode(int indent) {
                return this.withIndent("{\n", indent) + this.$codeBlock.toCode(indent + 1) + this.withIndent("}", indent);
            }
        };
    }

    @Override
    @NotNull
    public TryBlock createTryBlock(@NotNull CodeBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return new JavaTryBlock(block, this);
    }

    @Override
    @NotNull
    public VariableDeclaration createTimeVariableDeclaration() {
        return new JavaVariableDeclaration(this.createVariable(this.getTypes().getTIME(), "time"), false, this.getTypes().getTIME().getDefaultValue());
    }

    @Override
    @NotNull
    public Expression currentTimeExpression() {
        return new TextExpression("time").call("get", new Expression[0]);
    }

    @Override
    @NotNull
    public Expression updateCurrentTimeExpression() {
        return new TextExpression("time").call("incrementAndGet", new Expression[0]);
    }

    @Override
    @NotNull
    public Expression createNewArrayExpression(@NotNull GenericType elementType, Expression ... args) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String elements2 = ArraysKt.joinToString$default((Object[])args, (CharSequence)", ", null, null, (int)0, null, (Function1)createNewArrayExpression.elements.1.INSTANCE, (int)30, null);
        return new TextExpression("new " + elementType.getVariableTypeName() + "[] { " + elements2 + " }");
    }

    @Override
    @NotNull
    public Expression createNewSizedArray(@NotNull GenericType elementType, @NotNull Expression size) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        return new TextExpression("new " + elementType.getVariableTypeName() + "[" + Convertable.toCode$default(size, 0, 1, null) + "]");
    }

    @Override
    @NotNull
    public Expression createNewListExpression(@NotNull GenericType elementType, Expression ... args) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (args.length == 0) {
            return new TextExpression(this.getTypes().list(elementType).getDefaultValue());
        }
        return new TextExpression("java.util.Arrays.asList(" + ArraysKt.joinToString$default((Object[])args, (CharSequence)", ", null, null, (int)0, null, (Function1)createNewListExpression.1.INSTANCE, (int)30, null) + ")");
    }

    @Override
    @NotNull
    public IntermediateStreamCall createPeekCall(@NotNull GenericType elementsType, @NotNull String lambda2) {
        Intrinsics.checkNotNullParameter((Object)elementsType, (String)"elementsType");
        Intrinsics.checkNotNullParameter((Object)lambda2, (String)"lambda");
        return new PeekCall(lambda2, elementsType);
    }

    @Override
    @NotNull
    public ListVariable createListVariable(@NotNull GenericType elementType, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new JavaListVariable(this.getTypes().list(elementType), name);
    }

    @Override
    @NotNull
    public Expression not(@NotNull Expression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        return new TextExpression("!" + Convertable.toCode$default(expression, 0, 1, null));
    }
}

