/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.actions.updateFromSources;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.updateSettings.impl.IdeRestartKt;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.task.ProjectTaskManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Restarter;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.actions.updateFromSources.UpdateFromSourcesKt;
import org.jetbrains.idea.devkit.actions.updateFromSources.UpdateFromSourcesSettings;
import org.jetbrains.idea.devkit.actions.updateFromSources.UpdateFromSourcesSettingsKt;
import org.jetbrains.idea.devkit.actions.updateFromSources.UpdateFromSourcesSettingsState;
import org.jetbrains.idea.devkit.actions.updateFromSources.UpdateIdeFromSourcesAction;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0002\u001aF\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u0018H\u0002\u001a#\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u001b2\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u001d\u001a\u0014\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001fH\u0002\u001a\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00182\u0006\u0010$\u001a\u00020!H\u0002\u001a1\u0010%\u001a\u00020\t2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00030\u001b2\u0006\u0010'\u001a\u00020\u00032\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\t0)H\u0002\u00a2\u0006\u0002\u0010*\u001aN\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u00162\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\t0)H\u0002\u001a \u0010/\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a5\u00100\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\t0)2\u0017\u00101\u001a\u0013\u0012\t\u0012\u00070\u0003\u00a2\u0006\u0002\b3\u0012\u0004\u0012\u00020\t02\u001a.\u00104\u001a\u00020\t2\u0006\u00105\u001a\u00020#2\u0006\u00106\u001a\u00020!2\u0014\u00107\u001a\u0010\u0012\u0004\u0012\u00020 \u0012\u0006\u0012\u0004\u0018\u00010!02H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "ULTIMATE_UPDATE_FROM_SOURCES_BUILD_TARGET", "", "safeToDeleteExtensions", "", "safeToDeleteFilesInBin", "safeToDeleteFilesInHome", "backupImportantFilesIfNeeded", "", "workIdeHome", "backupDirPath", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "checkIdeHome", "createScriptJavaParameters", "Lcom/intellij/execution/configurations/JavaParameters;", "project", "Lcom/intellij/openapi/project/Project;", "deployDir", "distRelativePath", "buildEnabledPluginsOnly", "", "bundledPluginDirsToSkip", "", "nonBundledPluginDirsToInclude", "generateUpdateCommand", "", "builtDistPath", "(Ljava/lang/String;Ljava/lang/String;)[Ljava/lang/String;", "nonBundledPluginsPaths", "", "Lcom/intellij/openapi/extensions/PluginId;", "Ljava/nio/file/Path;", "readPluginsDir", "Lcom/intellij/ide/plugins/PluginNode;", "pluginsDirPath", "restartWithCommand", "command", "deployDirPath", "beforeRestart", "Lkotlin/Function0;", "([Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "runUpdateScript", "params", "backupDir", "restartAutomatically", "startCopyingFiles", "updateFromSources", "error", "Lkotlin/Function1;", "Lcom/intellij/openapi/util/NlsContexts$DialogMessage;", "updateNonBundledPlugin", "newDescriptor", "pluginsDir", "oldPluginPathProvider", "intellij.devkit.core"})
@SourceDebugExtension(value={"SMAP\nUpdateFromSources.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdateFromSources.kt\norg/jetbrains/idea/devkit/actions/updateFromSources/UpdateFromSourcesKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,438:1\n3792#2:439\n4307#2,2:440\n3792#2:452\n4307#2,2:453\n3792#2:457\n4307#2,2:458\n1549#3:442\n1620#3,3:443\n766#3:446\n857#3,2:447\n1620#3,3:449\n1855#3,2:455\n1855#3,2:460\n1855#3,2:462\n658#4:464\n739#4,4:465\n1#5:469\n10#6:470\n*S KotlinDebug\n*F\n+ 1 UpdateFromSources.kt\norg/jetbrains/idea/devkit/actions/updateFromSources/UpdateFromSourcesKt\n*L\n91#1:439\n91#1:440,2\n233#1:452\n233#1:453,2\n237#1:457\n237#1:458,2\n92#1:442\n92#1:443,3\n93#1:446\n93#1:447,2\n94#1:449,3\n234#1:455,2\n238#1:460,2\n305#1:462,2\n339#1:464\n339#1:465,4\n53#1:470\n*E\n"})
public final class UpdateFromSourcesKt {
    @NotNull
    private static final Logger LOG;
    @NonNls
    @NotNull
    private static final Set<String> safeToDeleteFilesInHome;
    @NonNls
    @NotNull
    private static final Set<String> safeToDeleteFilesInBin;
    @NonNls
    @NotNull
    private static final Set<String> safeToDeleteExtensions;
    @NotNull
    private static final String ULTIMATE_UPDATE_FROM_SOURCES_BUILD_TARGET = "UltimateUpdateFromSourcesBuildTarget";

    /*
     * WARNING - void declaration
     */
    public static final void updateFromSources(@NotNull Project project, @NotNull Function0<Unit> beforeRestart, @NotNull Function1<? super String, Unit> error) {
        boolean buildEnabledPluginsOnly;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(beforeRestart, (String)"beforeRestart");
        Intrinsics.checkNotNullParameter(error, (String)"error");
        UpdateFromSourcesSettingsState state = UpdateFromSourcesSettings.Companion.getState();
        String string = project.getBasePath();
        if (string == null) {
            return;
        }
        String devIdeaHome = string;
        String workIdeHome = UpdateFromSourcesSettingsKt.getActualIdePath(state);
        boolean restartAutomatically = state.getRestartAutomatically();
        if (!ApplicationManager.getApplication().isRestartCapable() && FileUtil.pathsEqual((String)workIdeHome, (String)PathManager.getHomePath())) {
            String string2 = DevKitBundle.message("action.UpdateIdeFromSourcesAction.error.ide.cannot.restart", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"action.UpdateId\u2026rror.ide.cannot.restart\")");
            error.invoke((Object)string2);
            return;
        }
        String notIdeHomeMessage = UpdateFromSourcesKt.checkIdeHome(workIdeHome);
        if (notIdeHomeMessage != null) {
            Object[] objectArray = new Object[]{workIdeHome, notIdeHomeMessage};
            String string3 = DevKitBundle.message("action.UpdateIdeFromSourcesAction.error.work.home.not.valid.ide.home", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"action.UpdateId\u2026eHome, notIdeHomeMessage)");
            error.invoke((Object)string3);
            return;
        }
        if (FileUtil.isAncestor((String)workIdeHome, (String)PathManager.getConfigPath(), (boolean)false)) {
            Object[] objectArray = new Object[]{workIdeHome, "idea.config.path"};
            String string4 = DevKitBundle.message("action.UpdateIdeFromSourcesAction.error.config.or.system.directory.under.home", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"action.UpdateId\u2026ger.PROPERTY_CONFIG_PATH)");
            error.invoke((Object)string4);
            return;
        }
        if (FileUtil.isAncestor((String)workIdeHome, (String)PathManager.getSystemPath(), (boolean)false)) {
            Object[] objectArray = new Object[]{workIdeHome, "idea.system.path"};
            String string5 = DevKitBundle.message("action.UpdateIdeFromSourcesAction.error.config.or.system.directory.under.home", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(\"action.UpdateId\u2026ger.PROPERTY_SYSTEM_PATH)");
            error.invoke((Object)string5);
            return;
        }
        List bundledPluginDirsToSkip = null;
        List nonBundledPluginDirsToInclude = null;
        boolean bl = buildEnabledPluginsOnly = !state.getBuildDisabledPlugins();
        if (buildEnabledPluginsOnly) {
            void $this$mapTo$iv;
            Path it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Iterator $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            LinkedHashSet pluginDirectoriesToSkip = new LinkedHashSet(state.getPluginDirectoriesForDisabledPlugins());
            List list = PluginManagerCore.getLoadedPlugins();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getLoadedPlugins()");
            pluginDirectoriesToSkip.removeAll(SequencesKt.toHashSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)updateFromSources.1.INSTANCE), (Function1)updateFromSources.2.INSTANCE), (Function1)updateFromSources.3.INSTANCE), (Function1)updateFromSources.4.INSTANCE)));
            IdeaPluginDescriptor[] ideaPluginDescriptorArray = PluginManagerCore.getPlugins();
            Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptorArray, (String)"getPlugins()");
            Object[] objectArray = ideaPluginDescriptorArray;
            boolean $i$f$filter = false;
            void var14_18 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (IdeaPluginDescriptor element$iv$iv : $this$filterTo$iv$iv) {
                IdeaPluginDescriptor it2 = element$iv$iv;
                boolean bl2 = false;
                if (!(it2.isBundled() && !it2.isEnabled())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                IdeaPluginDescriptor element$iv$iv;
                element$iv$iv = (IdeaPluginDescriptor)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(it.getPluginPath());
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                it = (Path)element$iv$iv;
                boolean bl4 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (!PathKt.isDirectory((Path)it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$mapTo2 = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it3;
                Path $i$f$filterTo2 = (Path)item$iv;
                collection = pluginDirectoriesToSkip;
                boolean bl5 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it3, (String)"it");
                collection.add(PathsKt.getName((Path)it3));
            }
            List list2 = CollectionsKt.toMutableList((Collection)pluginDirectoriesToSkip);
            state.setPluginDirectoriesForDisabledPlugins(list2);
            bundledPluginDirsToSkip = list2;
            IdeaPluginDescriptor[] ideaPluginDescriptorArray2 = PluginManagerCore.getPlugins();
            Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptorArray2, (String)"getPlugins()");
            nonBundledPluginDirsToInclude = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])ideaPluginDescriptorArray2), (Function1)updateFromSources.9.INSTANCE), (Function1)updateFromSources.10.INSTANCE), (Function1)updateFromSources.11.INSTANCE), (Function1)updateFromSources.12.INSTANCE));
        } else {
            bundledPluginDirsToSkip = CollectionsKt.emptyList();
            nonBundledPluginDirsToInclude = CollectionsKt.emptyList();
        }
        String deployDir = devIdeaHome + "/out/deploy";
        String distRelativePath = "dist";
        String backupDir = devIdeaHome + "/out/backup-before-update-from-sources";
        JavaParameters javaParameters = UpdateFromSourcesKt.createScriptJavaParameters(project, deployDir, distRelativePath, buildEnabledPluginsOnly, bundledPluginDirsToSkip, nonBundledPluginDirsToInclude);
        if (javaParameters == null) {
            return;
        }
        JavaParameters params = javaParameters;
        ProjectTaskManager taskManager = ProjectTaskManager.getInstance((Project)project);
        taskManager.run(taskManager.createModulesBuildTask(ModuleManager.Companion.getInstance(project).getModules(), true, true, true, false)).onSuccess(arg_0 -> UpdateFromSourcesKt.updateFromSources$lambda$4((Function1)new Function1<ProjectTaskManager.Result, Unit>(params, project, workIdeHome, deployDir, distRelativePath, backupDir, restartAutomatically, beforeRestart){
            final /* synthetic */ JavaParameters $params;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $workIdeHome;
            final /* synthetic */ String $deployDir;
            final /* synthetic */ String $distRelativePath;
            final /* synthetic */ String $backupDir;
            final /* synthetic */ boolean $restartAutomatically;
            final /* synthetic */ Function0<Unit> $beforeRestart;
            {
                this.$params = $params;
                this.$project = $project;
                this.$workIdeHome = $workIdeHome;
                this.$deployDir = $deployDir;
                this.$distRelativePath = $distRelativePath;
                this.$backupDir = $backupDir;
                this.$restartAutomatically = $restartAutomatically;
                this.$beforeRestart = $beforeRestart;
                super(1);
            }

            public final void invoke(ProjectTaskManager.Result it) {
                if (!it.isAborted() && !it.hasErrors()) {
                    UpdateFromSourcesKt.access$runUpdateScript(this.$params, this.$project, this.$workIdeHome, this.$deployDir, this.$distRelativePath, this.$backupDir, this.$restartAutomatically, this.$beforeRestart);
                }
            }
        }, arg_0));
    }

    private static final String checkIdeHome(String workIdeHome) {
        Path homeDir = Path.of(workIdeHome, new String[0]);
        if (Files.notExists(homeDir, new LinkOption[0])) {
            return null;
        }
        if (!Files.isDirectory(homeDir, new LinkOption[0])) {
            return DevKitBundle.message("action.UpdateIdeFromSourcesAction.error.work.home.not.valid.ide.home.not.directory", new Object[0]);
        }
        String buildTxt = SystemInfo.isMac ? "Resources/build.txt" : "build.txt";
        Object[] objectArray = new String[]{"bin", buildTxt};
        for (String name : CollectionsKt.listOf((Object[])objectArray)) {
            if (!Files.notExists(homeDir.resolve(name), new LinkOption[0])) continue;
            Object[] objectArray2 = new Object[]{name};
            return DevKitBundle.message("action.UpdateIdeFromSourcesAction.error.work.home.not.valid.ide.home.not.exists", objectArray2);
        }
        return null;
    }

    private static final void runUpdateScript(JavaParameters params, Project project, String workIdeHome, String deployDirPath, String distRelativePath, String backupDir, boolean restartAutomatically, Function0<Unit> beforeRestart) {
        String builtDistPath = deployDirPath + "/" + distRelativePath;
        String string = DevKitBundle.message("action.UpdateIdeFromSourcesAction.task.title", new Object[0]);
        new Task.Backgroundable(project, workIdeHome, backupDir, builtDistPath, params, restartAutomatically, deployDirPath, beforeRestart, string){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $workIdeHome;
            final /* synthetic */ String $backupDir;
            final /* synthetic */ String $builtDistPath;
            final /* synthetic */ JavaParameters $params;
            final /* synthetic */ boolean $restartAutomatically;
            final /* synthetic */ String $deployDirPath;
            final /* synthetic */ Function0<Unit> $beforeRestart;
            {
                this.$project = $project;
                this.$workIdeHome = $workIdeHome;
                this.$backupDir = $backupDir;
                this.$builtDistPath = $builtDistPath;
                this.$params = $params;
                this.$restartAutomatically = $restartAutomatically;
                this.$deployDirPath = $deployDirPath;
                this.$beforeRestart = $beforeRestart;
                super($project, $super_call_param$1, true);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                indicator.setText(DevKitBundle.message("action.UpdateIdeFromSourcesAction.update.progress.text", new Object[0]));
                UpdateFromSourcesKt.access$backupImportantFilesIfNeeded(this.$workIdeHome, this.$backupDir, indicator);
                Object[] objectArray = new Object[]{this.$builtDistPath};
                indicator.setText2(DevKitBundle.message("action.UpdateIdeFromSourcesAction.update.progress.delete", objectArray));
                NioFiles.deleteRecursively((Path)Path.of(this.$builtDistPath, new String[0]));
                objectArray = new Object[]{"UltimateUpdateFromSourcesBuildTarget"};
                indicator.setText2(DevKitBundle.message("action.UpdateIdeFromSourcesAction.update.progress.start.script", objectArray));
                GeneralCommandLine generalCommandLine = this.$params.toCommandLine();
                Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"params.toCommandLine()");
                GeneralCommandLine commandLine = generalCommandLine;
                commandLine.setRedirectErrorStream(true);
                OSProcessHandler scriptHandler = new OSProcessHandler(commandLine);
                List<String> output = Collections.synchronizedList((List)new ArrayList<E>());
                scriptHandler.addProcessListener(new ProcessListener(output, indicator, this.$project, this.$workIdeHome, this.$builtDistPath, this.$restartAutomatically, this.$deployDirPath, this.$beforeRestart){
                    final /* synthetic */ List<String> $output;
                    final /* synthetic */ ProgressIndicator $indicator;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ String $workIdeHome;
                    final /* synthetic */ String $builtDistPath;
                    final /* synthetic */ boolean $restartAutomatically;
                    final /* synthetic */ String $deployDirPath;
                    final /* synthetic */ Function0<Unit> $beforeRestart;
                    {
                        this.$output = $output;
                        this.$indicator = $indicator;
                        this.$project = $project;
                        this.$workIdeHome = $workIdeHome;
                        this.$builtDistPath = $builtDistPath;
                        this.$restartAutomatically = $restartAutomatically;
                        this.$deployDirPath = $deployDirPath;
                        this.$beforeRestart = $beforeRestart;
                    }

                    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                        this.$output.add(event.getText());
                        if (Intrinsics.areEqual(outputType, (Object)ProcessOutputTypes.STDOUT)) {
                            this.$indicator.setText2(event.getText());
                        }
                    }

                    public void processTerminated(@NotNull ProcessEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        if (this.$indicator.isCanceled()) {
                            return;
                        }
                        if (event.getExitCode() != 0) {
                            Object[] objectArray = new Object[]{event.getExitCode()};
                            new Notification("Update from Sources", DevKitBundle.message("action.UpdateIdeFromSourcesAction.task.failed.title", new Object[0]), DevKitBundle.message("action.UpdateIdeFromSourcesAction.task.failed.content", objectArray), NotificationType.ERROR).addAction((AnAction)NotificationAction.createSimple((String)DevKitBundle.message("action.UpdateIdeFromSourcesAction.notification.action.view.output", new Object[0]), () -> runUpdateScript.run.1.processTerminated$lambda$0(this.$project, this.$output))).addAction((AnAction)NotificationAction.createSimple((String)DevKitBundle.message("action.UpdateIdeFromSourcesAction.notification.action.view.debug.log", new Object[0]), () -> runUpdateScript.run.1.processTerminated$lambda$1(this.$deployDirPath, this.$project))).notify(this.$project);
                            return;
                        }
                        if (!FileUtil.pathsEqual((String)this.$workIdeHome, (String)PathManager.getHomePath())) {
                            UpdateFromSourcesKt.access$startCopyingFiles(this.$builtDistPath, this.$workIdeHome, this.$project);
                            return;
                        }
                        String[] command = UpdateFromSourcesKt.access$generateUpdateCommand(this.$builtDistPath, this.$workIdeHome);
                        IdeRestartKt.restartOrNotify((Project)this.$project, (boolean)this.$restartAutomatically, (Function0)((Function0)new Function0<Unit>(command, this.$deployDirPath, this.$beforeRestart){
                            final /* synthetic */ String[] $command;
                            final /* synthetic */ String $deployDirPath;
                            final /* synthetic */ Function0<Unit> $beforeRestart;
                            {
                                this.$command = $command;
                                this.$deployDirPath = $deployDirPath;
                                this.$beforeRestart = $beforeRestart;
                                super(0);
                            }

                            public final void invoke() {
                                UpdateFromSourcesKt.access$restartWithCommand(this.$command, this.$deployDirPath, this.$beforeRestart);
                            }
                        }));
                    }

                    private static final void processTerminated$lambda$0(Project $project, List $output) {
                        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
                        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)$project);
                        Intrinsics.checkNotNullExpressionValue((Object)$output, (String)"output");
                        fileEditorManager.openFile((VirtualFile)new LightVirtualFile("output.txt", (CharSequence)CollectionsKt.joinToString$default((Iterable)$output, (CharSequence)"", null, null, (int)0, null, null, (int)62, null)), true);
                    }

                    private static final void processTerminated$lambda$1(String $deployDirPath, Project $project) {
                        Intrinsics.checkNotNullParameter((Object)$deployDirPath, (String)"$deployDirPath");
                        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
                        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath($deployDirPath + "/log/debug.log");
                        if (virtualFile == null) {
                            return;
                        }
                        VirtualFile logFile = virtualFile;
                        logFile.refresh(true, false);
                        FileEditorManager.getInstance((Project)$project).openFile(logFile, true);
                    }
                });
                scriptHandler.startNotify();
                while (!scriptHandler.isProcessTerminated()) {
                    scriptHandler.waitFor(300L);
                    indicator.checkCanceled();
                }
            }
        }.queue();
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private static final void backupImportantFilesIfNeeded(String workIdeHome, String backupDirPath, ProgressIndicator indicator) {
        block8: {
            backupDir = Path.of(backupDirPath, new String[0]);
            if (Files.exists(backupDir, new LinkOption[0])) {
                UpdateFromSourcesKt.LOG.debug(backupDir + " already exists, skipping backup");
                return;
            }
            UpdateFromSourcesKt.LOG.debug("Backing up files from " + workIdeHome + " to " + backupDir);
            indicator.setText2(DevKitBundle.message("action.UpdateIdeFromSourcesAction.backup.progress.text", new Object[0]));
            Files.createDirectories(backupDir, new FileAttribute[0]);
            var4_4 = new File(workIdeHome, "bin").listFiles();
            if (var4_4 == null) break block8;
            var5_5 = var4_4;
            $i$f$filter = false;
            var7_7 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            var11_13 = ((void)$this$filterTo$iv$iv).length;
            for (var10_12 = 0; var10_12 < var11_13; ++var10_12) {
                it = element$iv$iv = $this$filterTo$iv$iv[var10_12];
                $i$a$-filter-UpdateFromSourcesKt$backupImportantFilesIfNeeded$1 = false;
                if (UpdateFromSourcesKt.safeToDeleteFilesInBin.contains(it.getName())) ** GOTO lbl-1000
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (!UpdateFromSourcesKt.safeToDeleteExtensions.contains(FilesKt.getExtension((File)it))) {
                    v0 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = false;
                }
                if (!v0) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                it = (File)element$iv;
                $i$a$-forEach-UpdateFromSourcesKt$backupImportantFilesIfNeeded$2 = 0;
                FileUtil.copy((File)it, (File)backupDir.resolve("bin/" + it.getName()).toFile());
            }
        }
        if ((var4_4 = new File(workIdeHome).listFiles()) != null) {
            $this$forEach$iv = var4_4;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            var11_13 = ((void)$this$filterTo$iv$iv).length;
            for ($i$a$-forEach-UpdateFromSourcesKt$backupImportantFilesIfNeeded$2 = 0; $i$a$-forEach-UpdateFromSourcesKt$backupImportantFilesIfNeeded$2 < var11_13; ++$i$a$-forEach-UpdateFromSourcesKt$backupImportantFilesIfNeeded$2) {
                it = element$iv$iv = $this$filterTo$iv$iv[$i$a$-forEach-UpdateFromSourcesKt$backupImportantFilesIfNeeded$2];
                $i$a$-filter-UpdateFromSourcesKt$backupImportantFilesIfNeeded$3 = false;
                if (!(UpdateFromSourcesKt.safeToDeleteFilesInHome.contains(it.getName()) == false)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                it = (File)element$iv;
                $i$a$-forEach-UpdateFromSourcesKt$backupImportantFilesIfNeeded$4 = false;
                FileUtil.copyFileOrDir((File)it, (File)backupDir.resolve(it.getName()).toFile());
            }
        }
    }

    private static final void startCopyingFiles(String builtDistPath, String workIdeHome, Project project) {
        String string = DevKitBundle.message("action.UpdateIdeFromSourcesAction.task.title", new Object[0]);
        new Task.Backgroundable(project, workIdeHome, builtDistPath, string){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $workIdeHome;
            final /* synthetic */ String $builtDistPath;
            {
                this.$project = $project;
                this.$workIdeHome = $workIdeHome;
                this.$builtDistPath = $builtDistPath;
                super($project, $super_call_param$1, true);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                indicator.setText(DevKitBundle.message("action.UpdateIdeFromSourcesAction.copy.progress.text", new Object[0]));
                indicator.setText2(DevKitBundle.message("action.UpdateIdeFromSourcesAction.copy.delete.old.files.text", new Object[0]));
                FileUtil.delete((File)new File(this.$workIdeHome));
                indicator.checkCanceled();
                indicator.setText2(DevKitBundle.message("action.UpdateIdeFromSourcesAction.copy.copy.new.files.text", new Object[0]));
                FileUtil.copyDir((File)new File(this.$builtDistPath), (File)new File(this.$workIdeHome));
                indicator.checkCanceled();
                Object[] objectArray = new Object[]{this.$workIdeHome};
                new Notification("Update from Sources", DevKitBundle.message("action.UpdateIdeFromSourcesAction.notification.title", new Object[0]), DevKitBundle.message("action.UpdateIdeFromSourcesAction.notification.content", objectArray), NotificationType.INFORMATION).notify(this.$project);
            }
        }.queue();
    }

    private static final String[] generateUpdateCommand(String builtDistPath, String workIdeHome) {
        if (SystemInfo.isWindows) {
            File restartLogFile = new File(PathManager.getLogPath(), "update-from-sources.log");
            File file = FileUtil.createTempFile((String)"update", (String)".cmd", (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(\"update\", \".cmd\", false)");
            File updateScript = file;
            String workHomePath = new File(workIdeHome).getAbsolutePath();
            FileUtil.writeToFile((File)updateScript, (String)StringsKt.trimIndent((String)("\n        @echo off\n        SET count=20\n        SET time_to_wait=1\n        :DELETE_DIR\n        RMDIR /Q /S \"" + workHomePath + "\"\n        IF EXIST \"" + workHomePath + "\" (\n          IF %count% GEQ 0 (\n            ECHO \"" + workHomePath + "\" still exists, wait %time_to_wait%s and try delete again\n            SET /A time_to_wait=%time_to_wait%+1\n            PING 127.0.0.1 -n %time_to_wait% >NUL\n            SET /A count=%count%-1\n            ECHO %count% attempts remain\n            GOTO DELETE_DIR\n          )\n          ECHO Failed to delete \"" + workHomePath + "\", IDE wasn't updated. You may delete it manually and copy files from \"" + new File(builtDistPath).getAbsolutePath() + "\" by hand  \n          GOTO CLEANUP_AND_EXIT \n        )\n        XCOPY \"" + new File(builtDistPath).getAbsolutePath() + "\" \"" + workHomePath + "\"\\ /Q /E /Y\n        :CLEANUP_AND_EXIT\n        START /b \"\" cmd /c DEL /Q /F \"" + updateScript.getAbsolutePath() + "\" & EXIT /b\n      ")));
            String[] stringArray = new String[5];
            stringArray[0] = "cmd";
            stringArray[1] = "/c";
            Intrinsics.checkNotNullExpressionValue((Object)updateScript.getAbsolutePath(), (String)"updateScript.absolutePath");
            stringArray[3] = ">" + restartLogFile.getAbsolutePath();
            stringArray[4] = "2>&1";
            return stringArray;
        }
        Object[] objectArray = new String[]{"rm -rf \"" + workIdeHome + "\"/*", "cp -R \"" + builtDistPath + "\"/* \"" + workIdeHome + "\""};
        Object[] command = objectArray;
        objectArray = new String[]{"/bin/sh", "-c", ArraysKt.joinToString$default((Object[])command, (CharSequence)" && ", null, null, (int)0, null, null, (int)62, null)};
        return objectArray;
    }

    private static final void restartWithCommand(String[] command, String deployDirPath, Function0<Unit> beforeRestart) {
        Path pluginsDir = Path.of(deployDirPath, new String[0]).resolve("artifacts/" + ApplicationInfo.getInstance().getBuild().getProductCode() + "-plugins");
        Lazy nonBundledPluginsPaths2 = LazyKt.lazy((Function0)restartWithCommand.nonBundledPluginsPaths.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)pluginsDir, (String)"pluginsDir");
        Iterable $this$forEach$iv = UpdateFromSourcesKt.readPluginsDir(pluginsDir);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PluginNode newPluginNode = (PluginNode)element$iv;
            boolean bl = false;
            UpdateFromSourcesKt.updateNonBundledPlugin(newPluginNode, pluginsDir, (Function1<? super PluginId, ? extends Path>)((Function1)new Function1<PluginId, Path>((Lazy<? extends Map<PluginId, ? extends Path>>)nonBundledPluginsPaths2){
                final /* synthetic */ Lazy<Map<PluginId, Path>> $nonBundledPluginsPaths;
                {
                    this.$nonBundledPluginsPaths = $nonBundledPluginsPaths;
                    super(1);
                }

                @Nullable
                public final Path invoke(@NotNull PluginId it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return (Path)((Map)this.$nonBundledPluginsPaths.getValue()).get(it);
                }
            }));
        }
        Restarter.doNotLockInstallFolderOnRestart();
        beforeRestart.invoke();
        ApplicationEx applicationEx = ApplicationManagerEx.getApplicationEx();
        Intrinsics.checkNotNull((Object)applicationEx, (String)"null cannot be cast to non-null type com.intellij.openapi.application.impl.ApplicationImpl");
        ((ApplicationImpl)applicationEx).restart(7, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List<PluginNode> readPluginsDir(Path pluginsDirPath) {
        Object object;
        Path pluginsXml = pluginsDirPath.resolve("plugins.xml");
        Intrinsics.checkNotNullExpressionValue((Object)pluginsXml, (String)"pluginsXml");
        if (!PathKt.isFile((Path)pluginsXml)) {
            LOG.warn("Cannot read non-bundled plugins from " + pluginsXml + ", they won't be updated");
            return CollectionsKt.emptyList();
        }
        try {
            List list;
            object = PathKt.inputStream((Path)pluginsXml);
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)object;
                boolean bl = false;
                list = MarketplaceRequests.Companion.parsePluginList(it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = list;
        }
        catch (Exception e) {
            LOG.error("Failed to parse " + pluginsXml, (Throwable)e);
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<PluginId, Path> nonBundledPluginsPaths() {
        void var3_5;
        void var0;
        void $this$associateTo$iv$iv;
        List list = PluginManagerCore.getLoadedPlugins();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getLoadedPlugins()");
        Sequence $this$associate$iv = SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)nonBundledPluginsPaths.1.INSTANCE);
        boolean $i$f$associate = false;
        Sequence sequence = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            IdeaPluginDescriptor it = (IdeaPluginDescriptor)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getPluginId(), (Object)it.getPluginPath());
            map.put(pair.getFirst(), pair.getSecond());
        }
        void it = var0 = var3_5;
        boolean bl = false;
        LOG.debug("Existing custom plugins: " + (Map)it);
        return var0;
    }

    private static final void updateNonBundledPlugin(PluginNode newDescriptor, Path pluginsDir, Function1<? super PluginId, ? extends Path> oldPluginPathProvider) {
        Path path;
        boolean bl;
        boolean bl2 = bl = !newDescriptor.isBundled();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        PluginId pluginId = newDescriptor.getPluginId();
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"newDescriptor.pluginId");
        Path path2 = (Path)oldPluginPathProvider.invoke((Object)pluginId);
        if (path2 == null) {
            return;
        }
        Path oldPluginPath = path2;
        Path it = path = pluginsDir.resolve(newDescriptor.getDownloadUrl());
        boolean bl3 = false;
        LOG.debug("Adding update command: " + oldPluginPath + " to " + it);
        Path newPluginPath = path;
        PluginInstaller.installAfterRestart((IdeaPluginDescriptor)((IdeaPluginDescriptor)newDescriptor), (Path)newPluginPath, (Path)oldPluginPath, (boolean)false);
    }

    private static final JavaParameters createScriptJavaParameters(Project project, String deployDir, String distRelativePath, boolean buildEnabledPluginsOnly, List<String> bundledPluginDirsToSkip, List<String> nonBundledPluginDirsToInclude) {
        Sdk sdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        if (sdk == null) {
            LOG.warn("Project SDK is not defined");
            return null;
        }
        JavaParameters params = new JavaParameters();
        params.setUseClasspathJar(true);
        params.setDefaultCharset(project);
        params.setJdk(sdk);
        params.setMainClass(ULTIMATE_UPDATE_FROM_SOURCES_BUILD_TARGET);
        params.getProgramParametersList().add("--classpath");
        String buildScriptsModuleName = "intellij.idea.ultimate.build";
        Module buildScriptsModule = ModuleManager.Companion.getInstance(project).findModuleByName(buildScriptsModuleName);
        if (buildScriptsModule == null) {
            LOG.warn("Build scripts module " + buildScriptsModuleName + " is not found in the project");
            return null;
        }
        List list = OrderEnumerator.orderEntries((Module)buildScriptsModule).recursively().withoutSdk().runtimeOnly().productionOnly().classes().getPathsList().getPathList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"orderEntries(buildScript\u2026sses().pathsList.pathList");
        List classpath = list;
        params.getClassPath().addAll(classpath);
        params.getVMParametersList().add("-Dintellij.build.bundled.jre.prefix=jbrsdk_jcef-");
        if (buildEnabledPluginsOnly) {
            if (!((Collection)bundledPluginDirsToSkip).isEmpty()) {
                params.getVMParametersList().add("-Dintellij.build.bundled.plugin.dirs.to.skip=" + CollectionsKt.joinToString$default((Iterable)bundledPluginDirsToSkip, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
            }
            String nonBundled = !((Collection)nonBundledPluginDirsToInclude).isEmpty() ? CollectionsKt.joinToString$default((Iterable)nonBundledPluginDirsToInclude, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) : "none";
            params.getVMParametersList().add("-Dintellij.build.non.bundled.plugin.dirs.to.include=" + nonBundled);
        }
        if (!buildEnabledPluginsOnly || !((Collection)nonBundledPluginDirsToInclude).isEmpty()) {
            params.getVMParametersList().add("-Dintellij.build.local.plugins.repository=true");
        }
        params.getVMParametersList().add("-Dintellij.build.output.root=" + deployDir);
        params.getVMParametersList().add("-DdistOutputRelativePath=" + distRelativePath);
        return params;
    }

    private static final void updateFromSources$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$runUpdateScript(JavaParameters params, Project project, String workIdeHome, String deployDirPath, String distRelativePath, String backupDir, boolean restartAutomatically, Function0 beforeRestart) {
        UpdateFromSourcesKt.runUpdateScript(params, project, workIdeHome, deployDirPath, distRelativePath, backupDir, restartAutomatically, (Function0<Unit>)beforeRestart);
    }

    public static final /* synthetic */ void access$backupImportantFilesIfNeeded(String workIdeHome, String backupDirPath, ProgressIndicator indicator) {
        UpdateFromSourcesKt.backupImportantFilesIfNeeded(workIdeHome, backupDirPath, indicator);
    }

    public static final /* synthetic */ void access$startCopyingFiles(String builtDistPath, String workIdeHome, Project project) {
        UpdateFromSourcesKt.startCopyingFiles(builtDistPath, workIdeHome, project);
    }

    public static final /* synthetic */ String[] access$generateUpdateCommand(String builtDistPath, String workIdeHome) {
        return UpdateFromSourcesKt.generateUpdateCommand(builtDistPath, workIdeHome);
    }

    public static final /* synthetic */ void access$restartWithCommand(String[] command, String deployDirPath, Function0 beforeRestart) {
        UpdateFromSourcesKt.restartWithCommand(command, deployDirPath, (Function0<Unit>)beforeRestart);
    }

    public static final /* synthetic */ Map access$nonBundledPluginsPaths() {
        return UpdateFromSourcesKt.nonBundledPluginsPaths();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(UpdateIdeFromSourcesAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
        Object[] objectArray = new String[]{"bin", "help", "jre", "jre64", "jbr", "lib", "license", "plugins", "redist", "MacOS", "Resources", "build.txt", "product-info.json", "Install-Linux-tar.txt", "Install-Windows-zip.txt", "ipr.reg"};
        safeToDeleteFilesInHome = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"append.bat", "appletviewer.policy", "format.sh", "format.bat", "fsnotifier", "fsnotifier64", "inspect.bat", "inspect.sh", "restarter", "icons"};
        safeToDeleteFilesInBin = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"exe", "dll", "dylib", "so", "ico", "svg", "png", "py"};
        safeToDeleteExtensions = SetsKt.setOf((Object[])objectArray);
    }
}

