/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.Language;
import com.intellij.lang.jvm.DefaultJvmElementVisitor;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmElementVisitor;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.JvmModifiersOwner;
import com.intellij.lang.jvm.actions.ChangeModifierRequest;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.lang.jvm.actions.MemberRequestsKt;
import com.intellij.lang.jvm.inspection.JvmLocalInspection;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.inspections.DevKitJvmInspection;
import org.jetbrains.idea.devkit.inspections.ErrorMessageProvider;
import org.jetbrains.idea.devkit.inspections.ExtensionClassShouldBeFinalAndNonPublicInspection;
import org.jetbrains.idea.devkit.inspections.ExtensionClassShouldBeFinalErrorMessageProviders;
import org.jetbrains.idea.devkit.inspections.ExtensionClassShouldNotBePublicProvider;
import org.jetbrains.idea.devkit.inspections.ExtensionClassShouldNotBePublicProviders;
import org.jetbrains.idea.devkit.inspections.ExtensionUtil;
import org.jetbrains.idea.devkit.inspections.JvmProviderKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0014\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/idea/devkit/inspections/ExtensionClassShouldBeFinalAndNonPublicInspection;", "Lorg/jetbrains/idea/devkit/inspections/DevKitJvmInspection;", "()V", "buildVisitor", "Lcom/intellij/lang/jvm/JvmElementVisitor;", "", "project", "Lcom/intellij/openapi/project/Project;", "sink", "Lcom/intellij/lang/jvm/inspection/JvmLocalInspection$HighlightSink;", "isOnTheFly", "intellij.devkit.core"})
public final class ExtensionClassShouldBeFinalAndNonPublicInspection
extends DevKitJvmInspection {
    @NotNull
    protected JvmElementVisitor<Boolean> buildVisitor(@NotNull Project project, @NotNull JvmLocalInspection.HighlightSink sink, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        return (JvmElementVisitor)new DefaultJvmElementVisitor<Boolean>(sink){
            final /* synthetic */ JvmLocalInspection.HighlightSink $sink;
            {
                this.$sink = $sink;
            }

            @NotNull
            public Boolean visitClass(@NotNull JvmClass clazz) {
                Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
                if (!(clazz instanceof PsiClass)) {
                    return true;
                }
                if (!ExtensionUtil.INSTANCE.isExtensionPointImplementationCandidate((PsiClass)clazz)) {
                    return true;
                }
                PsiElement sourceElement = ((PsiClass)clazz).getSourceElement();
                PsiElement psiElement = sourceElement;
                if (psiElement == null || (psiElement = psiElement.getLanguage()) == null) {
                    return true;
                }
                PsiElement language = psiElement;
                PsiFile psiFile = ((PsiClass)clazz).getContainingFile();
                if (psiFile == null) {
                    return true;
                }
                PsiFile file = psiFile;
                boolean isFinal = clazz.hasModifier(JvmModifier.FINAL);
                ExtensionClassShouldNotBePublicProvider extensionClassShouldNotBePublicProvider = (ExtensionClassShouldNotBePublicProvider)JvmProviderKt.getProvider(ExtensionClassShouldNotBePublicProviders.INSTANCE, (Language)language);
                if (extensionClassShouldNotBePublicProvider == null) {
                    return true;
                }
                ExtensionClassShouldNotBePublicProvider extensionClassShouldNotBePublicProvider2 = extensionClassShouldNotBePublicProvider;
                boolean isPublic = extensionClassShouldNotBePublicProvider2.isPublic((PsiClass)clazz);
                if (isFinal && !isPublic) {
                    return true;
                }
                if (!ExtensionUtil.INSTANCE.isInstantiatedExtension((PsiClass)clazz, (Function1<? super Extension, Boolean>)((Function1)buildVisitor.visitClass.1.INSTANCE))) {
                    return true;
                }
                if (!isFinal) {
                    List actions = JvmElementActionFactories.createModifierActions((JvmModifiersOwner)((JvmModifiersOwner)clazz), (ChangeModifierRequest)MemberRequestsKt.modifierRequest((JvmModifier)JvmModifier.FINAL, (boolean)true));
                    ErrorMessageProvider errorMessageProvider = (ErrorMessageProvider)JvmProviderKt.getProvider(ExtensionClassShouldBeFinalErrorMessageProviders.INSTANCE, (Language)language);
                    if (errorMessageProvider == null) {
                        return true;
                    }
                    ErrorMessageProvider errorMessageProvider2 = errorMessageProvider;
                    String message = errorMessageProvider2.provideErrorMessage();
                    Collection $this$toTypedArray$iv = actions;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    LocalQuickFix[] localQuickFixArray = IntentionWrapper.wrapToQuickFixes((IntentionAction[])thisCollection$iv.toArray(new IntentionAction[0]), (PsiFile)file);
                    Intrinsics.checkNotNullExpressionValue((Object)localQuickFixArray, (String)"wrapToQuickFixes(actions.toTypedArray(), file)");
                    LocalQuickFix[] fixes = localQuickFixArray;
                    this.$sink.highlight(message, Arrays.copyOf(fixes, fixes.length));
                }
                if (isPublic) {
                    String message = DevKitBundle.message("inspection.extension.class.should.not.be.public.text", new Object[0]);
                    LocalQuickFix[] fixes = extensionClassShouldNotBePublicProvider2.provideQuickFix(clazz, file);
                    this.$sink.highlight(message, Arrays.copyOf(fixes, fixes.length));
                }
                return true;
            }
        };
    }
}

