/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.missingApi;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.apiUsage.ApiUsageProcessor;
import com.intellij.codeInspection.apiUsage.ApiUsageUastVisitor;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.StringValidator;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.xml.XmlFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.actions.DevkitActionsUtil;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.IdeaVersion;
import org.jetbrains.idea.devkit.inspections.missingApi.BuildNumberValidator;
import org.jetbrains.idea.devkit.inspections.missingApi.MissingRecentApiUsageProcessor;
import org.jetbrains.idea.devkit.inspections.missingApi.SinceUntilRange;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.util.DescriptorUtil;
import org.jetbrains.idea.devkit.util.PsiUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u0004\u0018\u00010\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/idea/devkit/inspections/missingApi/MissingRecentApiInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "sinceBuild", "Lcom/intellij/openapi/util/BuildNumber;", "getSinceBuild", "()Lcom/intellij/openapi/util/BuildNumber;", "sinceBuildString", "", "untilBuild", "getUntilBuild", "untilBuildString", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "getOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "getSinceUntilRange", "Lorg/jetbrains/idea/devkit/inspections/missingApi/SinceUntilRange;", "pluginXml", "Lcom/intellij/psi/xml/XmlFile;", "getTargetedSinceUntilRanges", "", "module", "Lcom/intellij/openapi/module/Module;", "intellij.devkit.core"})
@SourceDebugExtension(value={"SMAP\nMissingRecentApiInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MissingRecentApiInspection.kt\norg/jetbrains/idea/devkit/inspections/missingApi/MissingRecentApiInspection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n1#2:102\n1#2:113\n1#2:126\n1603#3,9:103\n1855#3:112\n1856#3:114\n1612#3:115\n1603#3,9:116\n1855#3:125\n1856#3:127\n1612#3:128\n819#3:129\n847#3,2:130\n*S KotlinDebug\n*F\n+ 1 MissingRecentApiInspection.kt\norg/jetbrains/idea/devkit/inspections/missingApi/MissingRecentApiInspection\n*L\n86#1:113\n87#1:126\n86#1:103,9\n86#1:112\n86#1:114\n86#1:115\n87#1:116,9\n87#1:125\n87#1:127\n87#1:128\n88#1:129\n88#1:130,2\n*E\n"})
public final class MissingRecentApiInspection
extends LocalInspectionTool {
    @Nullable
    private String sinceBuildString;
    @Nullable
    private String untilBuildString;

    private final BuildNumber getSinceBuild() {
        BuildNumber buildNumber;
        String string = this.sinceBuildString;
        if (string != null) {
            String it = string;
            boolean bl = false;
            buildNumber = BuildNumber.fromStringOrNull((String)it);
        } else {
            buildNumber = null;
        }
        return buildNumber;
    }

    private final BuildNumber getUntilBuild() {
        BuildNumber buildNumber;
        String string = this.untilBuildString;
        if (string != null) {
            String it = string;
            boolean bl = false;
            buildNumber = BuildNumber.fromStringOrNull((String)it);
        } else {
            buildNumber = null;
        }
        return buildNumber;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Project project = holder.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"holder.project");
        Project project2 = project;
        VirtualFile virtualFile = holder.getFile().getVirtualFile();
        if (PsiUtil.isIdeaProject(project2) || virtualFile != null && TestSourcesFilter.isTestSources((VirtualFile)virtualFile, (Project)project2)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)((PsiElement)holder.getFile()));
        if (module == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        Module module2 = module;
        List<SinceUntilRange> targetedSinceUntilRanges = this.getTargetedSinceUntilRanges(module2);
        if (targetedSinceUntilRanges.isEmpty()) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        return ApiUsageUastVisitor.Companion.createPsiElementVisitor((ApiUsageProcessor)new MissingRecentApiUsageProcessor(holder, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, targetedSinceUntilRanges));
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptRegularComponent[] optRegularComponentArray = new OptRegularComponent[1];
        OptRegularComponent[] optRegularComponentArray2 = new OptRegularComponent[]{OptPane.string((String)"sinceBuildString", (String)DevKitBundle.message("inspections.missing.recent.api.settings.since", new Object[0]), (StringValidator)new BuildNumberValidator()), OptPane.string((String)"untilBuildString", (String)DevKitBundle.message("inspections.missing.recent.api.settings.until", new Object[0]), (StringValidator)new BuildNumberValidator())};
        optRegularComponentArray[0] = OptPane.group((String)DevKitBundle.message("inspections.missing.recent.api.settings.range", new Object[0]), (OptRegularComponent[])optRegularComponentArray2);
        OptPane optPane = OptPane.pane((OptRegularComponent[])optRegularComponentArray);
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"pane(\n    group(DevKitBu\u2026BuildNumberValidator())))");
        return optPane;
    }

    /*
     * WARNING - void declaration
     */
    private final List<SinceUntilRange> getTargetedSinceUntilRanges(Module module) {
        if (this.getSinceBuild() == null && this.getUntilBuild() == null) {
            void $this$filterNotTo$iv$iv;
            Object it$iv$iv;
            boolean bl;
            Module it;
            boolean bl2;
            Object element$iv$iv;
            Object element$iv$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            List<Module> list = DevkitActionsUtil.getCandidatePluginModules(module);
            Intrinsics.checkNotNullExpressionValue(list, (String)"getCandidatePluginModules(module)");
            Iterable $this$mapNotNull$iv = list;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                element$iv$iv = element$iv$iv$iv = iterator.next();
                bl2 = false;
                it = (Module)element$iv$iv;
                boolean bl3 = false;
                if (PluginModuleType.getPluginXml(it) == null) continue;
                bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            $i$f$mapNotNull = false;
            $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                element$iv$iv = element$iv$iv$iv = iterator.next();
                bl2 = false;
                it = (XmlFile)element$iv$iv;
                boolean bl4 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (this.getSinceUntilRange((XmlFile)it) == null) continue;
                bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$filterNot$iv = (List)destination$iv$iv;
            boolean $i$f$filterNot = false;
            $this$mapNotNullTo$iv$iv = $this$filterNot$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv2 : $this$filterNotTo$iv$iv) {
                SinceUntilRange it2 = (SinceUntilRange)element$iv$iv2;
                boolean bl5 = false;
                if (it2.getSinceBuild() == null) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            return (List)destination$iv$iv;
        }
        return CollectionsKt.listOf((Object)new SinceUntilRange(this.getSinceBuild(), this.getUntilBuild()));
    }

    private final SinceUntilRange getSinceUntilRange(XmlFile pluginXml) {
        IdeaPlugin ideaPlugin = DescriptorUtil.getIdeaPlugin(pluginXml);
        if (ideaPlugin == null) {
            return null;
        }
        IdeaPlugin ideaPlugin2 = ideaPlugin;
        IdeaVersion ideaVersion = ideaPlugin2.getIdeaVersion();
        Intrinsics.checkNotNullExpressionValue((Object)ideaVersion, (String)"ideaPlugin.ideaVersion");
        IdeaVersion ideaVersion2 = ideaVersion;
        BuildNumber sinceBuild = (BuildNumber)ideaVersion2.getSinceBuild().getValue();
        BuildNumber untilBuild = (BuildNumber)ideaVersion2.getUntilBuild().getValue();
        return new SinceUntilRange(sinceBuild, untilBuild);
    }
}

