/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.lang.ant.config.ExecutionEvent;
import com.intellij.lang.ant.config.impl.WrongNameFormatException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.NlsSafe;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;

public final class ExecuteCompositeTargetEvent
extends ExecutionEvent {
    @NonNls
    public static final String TYPE_ID = "compositeTask";
    @Nls
    private final String myCompositeName;
    @Nls
    private String myPresentableName;
    private final List<@NlsSafe String> myTargetNames;
    @NonNls
    public static final String PRESENTABLE_NAME = "presentableName";

    public ExecuteCompositeTargetEvent(@NlsSafe String compositeName) throws WrongNameFormatException {
        if (!compositeName.startsWith("[") || !compositeName.endsWith("]") || compositeName.length() <= 2) {
            throw new WrongNameFormatException(compositeName);
        }
        this.myCompositeName = compositeName;
        StringTokenizer tokenizer = new StringTokenizer(compositeName.substring(1, compositeName.length() - 1), ",", false);
        ArrayList<String> targetNames = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            targetNames.add(tokenizer.nextToken().trim());
        }
        this.myTargetNames = targetNames;
        this.myPresentableName = compositeName;
    }

    public ExecuteCompositeTargetEvent(List<@Nls String> targetNames) {
        String compositeName;
        this.myTargetNames = targetNames;
        @NlsSafe StringBuilder builder = new StringBuilder();
        boolean first = true;
        builder.append("[");
        for (String name : targetNames) {
            if (first) {
                first = false;
            } else {
                builder.append(",");
            }
            builder.append(name);
        }
        builder.append("]");
        this.myCompositeName = compositeName = builder.toString();
        this.myPresentableName = compositeName;
    }

    @Override
    @NonNls
    public String getTypeId() {
        return TYPE_ID;
    }

    @Override
    @Nls
    public String getPresentableName() {
        return this.myPresentableName;
    }

    public void setPresentableName(@Nls String presentableName) {
        this.myPresentableName = presentableName;
    }

    @Nls
    public String getMetaTargetName() {
        return this.myCompositeName;
    }

    public List<@NlsSafe String> getTargetNames() {
        return this.myTargetNames;
    }

    @Override
    public void readExternal(Element element, Project project) throws InvalidDataException {
        String presentableName;
        super.readExternal(element, project);
        this.myPresentableName = presentableName = element.getAttributeValue(PRESENTABLE_NAME);
    }

    @Override
    public String writeExternal(Element element, Project project) {
        element.setAttribute(PRESENTABLE_NAME, this.myPresentableName);
        return this.myCompositeName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecuteCompositeTargetEvent event = (ExecuteCompositeTargetEvent)o;
        return this.myCompositeName.equals(event.myCompositeName);
    }

    public int hashCode() {
        return this.myCompositeName.hashCode();
    }
}

