/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.lang.ant.config.AntBuildTarget;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.config.Externalizer;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class TargetFilter
implements JDOMExternalizable,
Externalizer.SkippableValue {
    @NonNls
    private static final String FILTER_TARGET_NAME = "targetName";
    @NonNls
    private static final String FILTER_IS_VISIBLE = "isVisible";
    @NlsSafe
    private String myTargetName;
    private boolean myVisible;
    @Nls
    private String myDescription = "";

    public TargetFilter() {
    }

    public TargetFilter(@Nls String targetName, boolean isVisible) {
        this.myTargetName = targetName;
        this.myVisible = isVisible;
    }

    public String getTargetName() {
        return this.myTargetName;
    }

    public boolean isVisible() {
        return this.myVisible;
    }

    public void setVisible(boolean isVisible) {
        this.myVisible = isVisible;
    }

    public void readExternal(Element element) {
        this.myTargetName = element.getAttributeValue(FILTER_TARGET_NAME);
        this.myVisible = Boolean.parseBoolean(element.getAttributeValue(FILTER_IS_VISIBLE));
    }

    public void writeExternal(@NotNull Element element) {
        String targetName;
        if (element == null) {
            TargetFilter.$$$reportNull$$$0(0);
        }
        if ((targetName = this.getTargetName()) == null) {
            return;
        }
        element.setAttribute(FILTER_TARGET_NAME, targetName);
        element.setAttribute(FILTER_IS_VISIBLE, Boolean.valueOf(this.isVisible()).toString());
    }

    public String getDescription() {
        return this.myDescription;
    }

    public void updateDescription(AntBuildTarget target) {
        if (target == null) {
            return;
        }
        this.myDescription = target.getNotEmptyDescription();
    }

    @NotNull
    public static TargetFilter fromTarget(AntBuildTarget target) {
        TargetFilter filter = new TargetFilter(target.getName(), target.isDefault());
        filter.myDescription = target.getNotEmptyDescription();
        filter.myVisible = filter.myDescription != null;
        TargetFilter targetFilter = filter;
        if (targetFilter == null) {
            TargetFilter.$$$reportNull$$$0(1);
        }
        return targetFilter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ant/config/impl/TargetFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ant/config/impl/TargetFilter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "fromTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

