/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.validation;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.dom.AntDomProperty;
import com.intellij.lang.ant.validation.AntInspection;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AntMissingPropertiesFileInspection
extends AntInspection {
    @NonNls
    private static final String SHORT_NAME = "AntMissingPropertiesFileInspection";

    @NonNls
    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    protected void checkDomElement(@NotNull DomElement element, @NotNull DomElementAnnotationHolder holder, @NotNull DomHighlightingHelper helper) {
        PropertiesFile propertiesFile;
        AntDomProperty property;
        GenericAttributeValue<PsiFileSystemItem> fileValue;
        String fileName;
        if (element == null) {
            AntMissingPropertiesFileInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            AntMissingPropertiesFileInspection.$$$reportNull$$$0(1);
        }
        if (helper == null) {
            AntMissingPropertiesFileInspection.$$$reportNull$$$0(2);
        }
        if (element instanceof AntDomProperty && (fileName = (fileValue = (property = (AntDomProperty)element).getFile()).getStringValue()) != null && (propertiesFile = property.getPropertiesFile()) == null) {
            PsiFileSystemItem file = (PsiFileSystemItem)fileValue.getValue();
            if (file instanceof XmlFile) {
                holder.createProblem(fileValue, AntBundle.message("file.type.xml.not.supported", fileName), new LocalQuickFix[0]);
            } else if (file instanceof PsiFile) {
                holder.createProblem(fileValue, AntBundle.message("file.type.not.supported", fileName), new LocalQuickFix[0]);
            } else {
                holder.createProblem(fileValue, AntBundle.message("file.doesnt.exist", fileName), new LocalQuickFix[0]);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "helper";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/ant/validation/AntMissingPropertiesFileInspection";
        objectArray[2] = "checkDomElement";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

