/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal.path;

import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.internal.PathRef;
import com.jayway.jsonpath.internal.Utils;
import com.jayway.jsonpath.internal.function.PathFunction;
import com.jayway.jsonpath.internal.path.EvaluationContextImpl;
import com.jayway.jsonpath.internal.path.PropertyPathToken;
import com.jayway.jsonpath.spi.json.JsonProvider;
import java.util.List;

public abstract class PathToken {
    private PathToken prev;
    private PathToken next;
    private Boolean definite = null;
    private Boolean upstreamDefinite = null;
    private int upstreamArrayIndex = -1;

    public void setUpstreamArrayIndex(int idx) {
        this.upstreamArrayIndex = idx;
    }

    PathToken appendTailToken(PathToken next) {
        this.next = next;
        this.next.prev = this;
        return next;
    }

    /*
     * Enabled aggressive block sorting
     */
    void handleObjectProperty(String currentPath, Object model2, EvaluationContextImpl ctx, List<String> properties) {
        if (properties.size() == 1) {
            PathRef pathRef;
            String property = properties.get(0);
            String evalPath = Utils.concat(currentPath, "['", property, "']");
            Object propertyVal = PathToken.readObjectProperty(property, model2, ctx);
            if (propertyVal == JsonProvider.UNDEFINED) {
                assert (this instanceof PropertyPathToken) : "only PropertyPathToken is supported";
                if (this.isLeaf()) {
                    if (!ctx.options().contains((Object)Option.DEFAULT_PATH_LEAF_TO_NULL)) {
                        if (ctx.options().contains((Object)Option.SUPPRESS_EXCEPTIONS)) return;
                        if (ctx.options().contains((Object)Option.REQUIRE_PROPERTIES)) throw new PathNotFoundException("No results for path: " + evalPath);
                        return;
                    }
                    propertyVal = null;
                } else {
                    if (!this.isUpstreamDefinite() || !this.isTokenDefinite()) {
                        if (!ctx.options().contains((Object)Option.REQUIRE_PROPERTIES)) return;
                    }
                    if (!ctx.options().contains((Object)Option.SUPPRESS_EXCEPTIONS)) throw new PathNotFoundException("Missing property in path " + evalPath);
                    return;
                }
            }
            PathRef pathRef2 = pathRef = ctx.forUpdate() ? PathRef.create(model2, property) : PathRef.NO_OP;
            if (!this.isLeaf()) {
                this.next().evaluate(evalPath, pathRef, propertyVal, ctx);
                return;
            }
            String idx = "[" + String.valueOf(this.upstreamArrayIndex) + "]";
            if (!idx.equals("[-1]")) {
                if (!ctx.getRoot().getTail().prev().getPathFragment().equals(idx)) return;
            }
            ctx.addResult(evalPath, pathRef, propertyVal);
            return;
        }
        String evalPath = currentPath + "[" + Utils.join(", ", "'", properties) + "]";
        assert (this.isLeaf()) : "non-leaf multi props handled elsewhere";
        Object merged = ctx.jsonProvider().createMap();
        for (String property : properties) {
            Object propertyVal;
            if (PathToken.hasProperty(property, model2, ctx)) {
                propertyVal = PathToken.readObjectProperty(property, model2, ctx);
                if (propertyVal == JsonProvider.UNDEFINED) {
                    if (!ctx.options().contains((Object)Option.DEFAULT_PATH_LEAF_TO_NULL)) continue;
                    propertyVal = null;
                }
            } else if (ctx.options().contains((Object)Option.DEFAULT_PATH_LEAF_TO_NULL)) {
                propertyVal = null;
            } else {
                if (!ctx.options().contains((Object)Option.REQUIRE_PROPERTIES)) continue;
                throw new PathNotFoundException("Missing property in path " + evalPath);
            }
            ctx.jsonProvider().setProperty(merged, property, propertyVal);
        }
        PathRef pathRef = ctx.forUpdate() ? PathRef.create(model2, properties) : PathRef.NO_OP;
        ctx.addResult(evalPath, pathRef, merged);
    }

    private static boolean hasProperty(String property, Object model2, EvaluationContextImpl ctx) {
        return ctx.jsonProvider().getPropertyKeys(model2).contains(property);
    }

    private static Object readObjectProperty(String property, Object model2, EvaluationContextImpl ctx) {
        return ctx.jsonProvider().getMapValue(model2, property);
    }

    protected void handleArrayIndex(int index, String currentPath, Object model2, EvaluationContextImpl ctx) {
        String evalPath = Utils.concat(currentPath, "[", String.valueOf(index), "]");
        PathRef pathRef = ctx.forUpdate() ? PathRef.create(model2, index) : PathRef.NO_OP;
        int effectiveIndex = index < 0 ? ctx.jsonProvider().length(model2) + index : index;
        try {
            Object evalHit = ctx.jsonProvider().getArrayIndex(model2, effectiveIndex);
            if (this.isLeaf()) {
                ctx.addResult(evalPath, pathRef, evalHit);
            } else {
                this.next().evaluate(evalPath, pathRef, evalHit, ctx);
            }
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
    }

    PathToken prev() {
        return this.prev;
    }

    PathToken next() {
        if (this.isLeaf()) {
            throw new IllegalStateException("Current path token is a leaf");
        }
        return this.next;
    }

    boolean isLeaf() {
        return this.next == null;
    }

    boolean isRoot() {
        return this.prev == null;
    }

    boolean isUpstreamDefinite() {
        if (this.upstreamDefinite == null) {
            this.upstreamDefinite = this.isRoot() || this.prev.isTokenDefinite() && this.prev.isUpstreamDefinite();
        }
        return this.upstreamDefinite;
    }

    public int getTokenCount() {
        int cnt = 1;
        PathToken token = this;
        while (!token.isLeaf()) {
            token = token.next();
            ++cnt;
        }
        return cnt;
    }

    public boolean isPathDefinite() {
        if (this.definite != null) {
            return this.definite;
        }
        boolean isDefinite = this.isTokenDefinite();
        if (isDefinite && !this.isLeaf()) {
            isDefinite = this.next.isPathDefinite();
        }
        this.definite = isDefinite;
        return isDefinite;
    }

    public String toString() {
        if (this.isLeaf()) {
            return this.getPathFragment();
        }
        return this.getPathFragment() + this.next().toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public void invoke(PathFunction pathFunction, String currentPath, PathRef parent, Object model2, EvaluationContextImpl ctx) {
        ctx.addResult(currentPath, parent, pathFunction.invoke(currentPath, parent, model2, ctx, null));
    }

    public abstract void evaluate(String var1, PathRef var2, Object var3, EvaluationContextImpl var4);

    public abstract boolean isTokenDefinite();

    protected abstract String getPathFragment();

    public void setNext(PathToken next) {
        this.next = next;
    }

    public PathToken getNext() {
        return this.next;
    }
}

