/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.metadata;

import java.io.File;
import org.gradle.api.internal.artifacts.repositories.metadata.MetadataFileSource;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.hash.HashCode;

public class DefaultMetadataFileSource
implements MetadataFileSource {
    private final ModuleComponentArtifactIdentifier artifactId;
    private final File artifactFile;
    private final HashCode sha1;

    public DefaultMetadataFileSource(ModuleComponentArtifactIdentifier artifactId, File artifactFile, HashCode sha1) {
        this.artifactId = artifactId;
        this.artifactFile = artifactFile;
        this.sha1 = sha1;
    }

    @Override
    public File getArtifactFile() {
        return this.artifactFile;
    }

    @Override
    public ModuleComponentArtifactIdentifier getArtifactId() {
        return this.artifactId;
    }

    @Override
    public HashCode getSha1() {
        return this.sha1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultMetadataFileSource that = (DefaultMetadataFileSource)o;
        if (!this.artifactId.equals(that.artifactId)) {
            return false;
        }
        return this.sha1.equals(that.sha1);
    }

    public int hashCode() {
        int result2 = this.artifactId.hashCode();
        result2 = 31 * result2 + this.sha1.hashCode();
        return result2;
    }

    public String toString() {
        return "MetadataFileSource{artifactId=" + this.artifactId + ", artifactFile=" + this.artifactFile + ", sha1=" + this.sha1 + '}';
    }
}

