/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import org.gradle.api.Action;
import org.gradle.api.artifacts.DependencyMetadata;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.MutableVersionConstraint;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.dependencies.DefaultMutableVersionConstraint;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Cast;

public abstract class AbstractDependencyImpl<T extends DependencyMetadata<T>>
implements DependencyMetadata<T> {
    private final ModuleIdentifier moduleIdentifier;
    private final MutableVersionConstraint versionConstraint;
    private String reason;
    private AttributeContainer attributes = ImmutableAttributes.EMPTY;

    public AbstractDependencyImpl(String group, String name, String version) {
        this.moduleIdentifier = DefaultModuleIdentifier.newId(group, name);
        this.versionConstraint = new DefaultMutableVersionConstraint(version);
    }

    @Override
    public String getGroup() {
        return this.moduleIdentifier.getGroup();
    }

    @Override
    public String getName() {
        return this.moduleIdentifier.getName();
    }

    @Override
    public VersionConstraint getVersionConstraint() {
        return this.versionConstraint;
    }

    @Override
    public ModuleIdentifier getModule() {
        return this.moduleIdentifier;
    }

    @Override
    public T version(Action<? super MutableVersionConstraint> configureAction) {
        configureAction.execute(this.versionConstraint);
        return (T)((DependencyMetadata)Cast.uncheckedCast(this));
    }

    @Override
    public T attributes(Action<? super AttributeContainer> configureAction) {
        configureAction.execute(this.attributes);
        return (T)((DependencyMetadata)Cast.uncheckedCast(this));
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public T because(String reason) {
        this.reason = reason;
        return (T)((DependencyMetadata)Cast.uncheckedCast(this));
    }

    public void setAttributes(AttributeContainer attributes) {
        this.attributes = attributes;
    }

    @Override
    public AttributeContainer getAttributes() {
        return this.attributes;
    }

    public String toString() {
        return this.getGroup() + ":" + this.getName() + ":" + this.getVersionConstraint();
    }
}

