/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.cache;

import java.io.File;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.cache.CacheResourceConfiguration;
import org.gradle.api.cache.Cleanup;
import org.gradle.api.cache.MarkingStrategy;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.cache.CacheConfigurationsInternal;
import org.gradle.api.internal.cache.CacheResourceConfigurationInternal;
import org.gradle.api.internal.cache.CleanupInternal;
import org.gradle.api.internal.provider.DefaultProperty;
import org.gradle.api.internal.provider.DefaultProvider;
import org.gradle.api.internal.provider.PropertyHost;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.cache.CleanupFrequency;
import org.gradle.cache.internal.LegacyCacheCleanupEnablement;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.time.TimestampSuppliers;

public abstract class DefaultCacheConfigurations
implements CacheConfigurationsInternal {
    private static final DocumentationRegistry DOCUMENTATION_REGISTRY = new DocumentationRegistry();
    private static final String RELEASED_WRAPPERS = "releasedWrappers";
    private static final String SNAPSHOT_WRAPPERS = "snapshotWrappers";
    private static final String DOWNLOADED_RESOURCES = "downloadedResources";
    private static final String CREATED_RESOURCES = "createdResources";
    static final String UNSAFE_MODIFICATION_ERROR = "The property '%s' was modified from an unsafe location (for instance a settings script or plugin).  This property can only be changed in an init script, preferably stored in the init.d directory inside the Gradle user home directory. " + DOCUMENTATION_REGISTRY.getDocumentationRecommendationFor("information on this", "directory_layout", "dir:gradle_user_home:configure_cache_cleanup");
    private final CacheResourceConfigurationInternal releasedWrappersConfiguration;
    private final CacheResourceConfigurationInternal snapshotWrappersConfiguration;
    private final CacheResourceConfigurationInternal downloadedResourcesConfiguration;
    private final CacheResourceConfigurationInternal createdResourcesConfiguration;
    private final Property<Cleanup> cleanup;
    private final Property<MarkingStrategy> markingStrategy;
    private final LegacyCacheCleanupEnablement legacyCacheCleanupEnablement;
    private boolean cleanupHasBeenConfigured;

    @Inject
    public DefaultCacheConfigurations(ObjectFactory objectFactory, PropertyHost propertyHost, LegacyCacheCleanupEnablement legacyCacheCleanupEnablement) {
        this.releasedWrappersConfiguration = DefaultCacheConfigurations.createResourceConfiguration(objectFactory, RELEASED_WRAPPERS, 30);
        this.snapshotWrappersConfiguration = DefaultCacheConfigurations.createResourceConfiguration(objectFactory, SNAPSHOT_WRAPPERS, 7);
        this.downloadedResourcesConfiguration = DefaultCacheConfigurations.createResourceConfiguration(objectFactory, DOWNLOADED_RESOURCES, 30);
        this.createdResourcesConfiguration = DefaultCacheConfigurations.createResourceConfiguration(objectFactory, CREATED_RESOURCES, 7);
        this.cleanup = new ContextualErrorMessageProperty<Cleanup>(propertyHost, Cleanup.class, "cleanup").convention((Provider)this.createCleanupConvention());
        this.markingStrategy = new ContextualErrorMessageProperty<MarkingStrategy>(propertyHost, MarkingStrategy.class, "markingStrategy").convention((Object)MarkingStrategy.CACHEDIR_TAG);
        this.legacyCacheCleanupEnablement = legacyCacheCleanupEnablement;
    }

    private static CacheResourceConfigurationInternal createResourceConfiguration(ObjectFactory objectFactory, String name, int defaultDays) {
        CacheResourceConfigurationInternal resourceConfiguration = objectFactory.newInstance(DefaultCacheResourceConfiguration.class, name);
        resourceConfiguration.getRemoveUnusedEntriesOlderThan().convention(DefaultCacheConfigurations.providerFromSupplier(TimestampSuppliers.daysAgo(defaultDays)));
        return resourceConfiguration;
    }

    private Provider<Cleanup> createCleanupConvention() {
        return DefaultCacheConfigurations.providerFromSupplier(() -> this.legacyCacheCleanupEnablement.isDisabledByProperty() ? Cleanup.DISABLED : Cleanup.DEFAULT);
    }

    @Override
    public void releasedWrappers(Action<? super CacheResourceConfiguration> cacheConfiguration) {
        cacheConfiguration.execute(this.releasedWrappersConfiguration);
    }

    @Override
    public CacheResourceConfigurationInternal getReleasedWrappers() {
        return this.releasedWrappersConfiguration;
    }

    @Override
    public void snapshotWrappers(Action<? super CacheResourceConfiguration> cacheConfiguration) {
        cacheConfiguration.execute(this.snapshotWrappersConfiguration);
    }

    @Override
    public CacheResourceConfigurationInternal getSnapshotWrappers() {
        return this.snapshotWrappersConfiguration;
    }

    @Override
    public void downloadedResources(Action<? super CacheResourceConfiguration> cacheConfiguration) {
        cacheConfiguration.execute(this.downloadedResourcesConfiguration);
    }

    @Override
    public CacheResourceConfigurationInternal getDownloadedResources() {
        return this.downloadedResourcesConfiguration;
    }

    @Override
    public void createdResources(Action<? super CacheResourceConfiguration> cacheConfiguration) {
        cacheConfiguration.execute(this.createdResourcesConfiguration);
    }

    @Override
    public CacheResourceConfigurationInternal getCreatedResources() {
        return this.createdResourcesConfiguration;
    }

    @Override
    public Property<Cleanup> getCleanup() {
        return this.cleanup;
    }

    @Override
    public Property<MarkingStrategy> getMarkingStrategy() {
        return this.markingStrategy;
    }

    @Override
    public Provider<CleanupFrequency> getCleanupFrequency() {
        return this.getCleanup().map(cleanup -> new MustBeConfiguredCleanupFrequency(((CleanupInternal)cleanup).getCleanupFrequency()));
    }

    @Override
    public void synchronize(CacheConfigurationsInternal persistentCacheConfigurations) {
        persistentCacheConfigurations.getReleasedWrappers().getRemoveUnusedEntriesOlderThan().value(this.getReleasedWrappers().getRemoveUnusedEntriesOlderThan());
        persistentCacheConfigurations.getSnapshotWrappers().getRemoveUnusedEntriesOlderThan().value(this.getSnapshotWrappers().getRemoveUnusedEntriesOlderThan());
        persistentCacheConfigurations.getDownloadedResources().getRemoveUnusedEntriesOlderThan().value(this.getDownloadedResources().getRemoveUnusedEntriesOlderThan());
        persistentCacheConfigurations.getCreatedResources().getRemoveUnusedEntriesOlderThan().value(this.getCreatedResources().getRemoveUnusedEntriesOlderThan());
        persistentCacheConfigurations.getCleanup().value(this.getCleanup());
        persistentCacheConfigurations.getMarkingStrategy().value(this.getMarkingStrategy());
    }

    @Override
    public void finalizeConfiguration(Gradle gradle) {
        this.finalizeConfigurationValues();
        this.markCacheDirectories(gradle);
    }

    @VisibleForTesting
    void finalizeConfigurationValues() {
        this.releasedWrappersConfiguration.getRemoveUnusedEntriesOlderThan().finalizeValue();
        this.snapshotWrappersConfiguration.getRemoveUnusedEntriesOlderThan().finalizeValue();
        this.downloadedResourcesConfiguration.getRemoveUnusedEntriesOlderThan().finalizeValue();
        this.createdResourcesConfiguration.getRemoveUnusedEntriesOlderThan().finalizeValue();
        this.getCleanup().finalizeValue();
        this.getMarkingStrategy().finalizeValue();
    }

    private void markCacheDirectories(Gradle gradle) {
        MarkingStrategy strategy = (MarkingStrategy)this.getMarkingStrategy().get();
        strategy.tryMarkCacheDirectory(new File(gradle.getGradleUserHomeDir(), "wrapper/dists"));
        strategy.tryMarkCacheDirectory(new File(gradle.getGradleUserHomeDir(), "daemon"));
        strategy.tryMarkCacheDirectory(new File(gradle.getGradleUserHomeDir(), "caches"));
        strategy.tryMarkCacheDirectory(new File(gradle.getGradleUserHomeDir(), "jdks"));
    }

    @Override
    public void setCleanupHasBeenConfigured(boolean hasBeenConfigured) {
        this.cleanupHasBeenConfigured = hasBeenConfigured;
    }

    private static <T> Provider<T> providerFromSupplier(Supplier<T> supplier) {
        return new DefaultProvider<Object>(supplier::get);
    }

    private class MustBeConfiguredCleanupFrequency
    implements CleanupFrequency {
        private final CleanupFrequency configuredCleanupFrequency;

        public MustBeConfiguredCleanupFrequency(CleanupFrequency configuredCleanupFrequency) {
            this.configuredCleanupFrequency = configuredCleanupFrequency;
        }

        @Override
        public boolean shouldCleanupOnEndOfSession() {
            return this.configuredCleanupFrequency.shouldCleanupOnEndOfSession();
        }

        @Override
        public boolean requiresCleanup(long lastCleanupTimestamp) {
            return DefaultCacheConfigurations.this.cleanupHasBeenConfigured && this.configuredCleanupFrequency.requiresCleanup(lastCleanupTimestamp);
        }
    }

    private static class ContextualErrorMessageProperty<T>
    extends DefaultProperty<T> {
        private final String displayName;

        public ContextualErrorMessageProperty(PropertyHost propertyHost, Class<T> type, String displayName) {
            super(propertyHost, type);
            this.displayName = displayName;
        }

        private IllegalStateException alreadyFinalizedError() {
            return new IllegalStateException(String.format(UNSAFE_MODIFICATION_ERROR, this.getDisplayName()));
        }

        private void onlyIfMutable(Runnable runnable) {
            if (this.isFinalized()) {
                throw this.alreadyFinalizedError();
            }
            runnable.run();
        }

        @Override
        @Nonnull
        protected DisplayName getDisplayName() {
            if (this.displayName != null) {
                return Describables.of(this.displayName);
            }
            return super.getDisplayName();
        }

        @Override
        public void set(@Nullable T value) {
            this.onlyIfMutable(() -> super.set(value));
        }

        @Override
        public void set(Provider<? extends T> provider) {
            this.onlyIfMutable(() -> super.set(provider));
        }

        @Override
        public ContextualErrorMessageProperty<T> value(@Nullable T value) {
            this.onlyIfMutable(() -> super.value(value));
            return this;
        }

        @Override
        public ContextualErrorMessageProperty<T> value(Provider<? extends T> provider) {
            this.onlyIfMutable(() -> super.value(provider));
            return this;
        }

        @Override
        public ContextualErrorMessageProperty<T> convention(@Nullable T value) {
            this.onlyIfMutable(() -> super.convention(value));
            return this;
        }

        @Override
        public ContextualErrorMessageProperty<T> convention(Provider<? extends T> provider) {
            this.onlyIfMutable(() -> super.convention(provider));
            return this;
        }
    }

    static abstract class DefaultCacheResourceConfiguration
    implements CacheResourceConfigurationInternal {
        private final String name;
        private final Property<Long> removeUnusedEntriesOlderThan;

        @Inject
        public DefaultCacheResourceConfiguration(PropertyHost propertyHost, String name) {
            this.name = name;
            this.removeUnusedEntriesOlderThan = new ContextualErrorMessageProperty<Long>(propertyHost, Long.class, "removeUnusedEntriesOlderThan");
        }

        @Override
        public Property<Long> getRemoveUnusedEntriesOlderThan() {
            return this.removeUnusedEntriesOlderThan;
        }

        @Override
        public Supplier<Long> getRemoveUnusedEntriesOlderThanAsSupplier() {
            return () -> (Long)this.getRemoveUnusedEntriesOlderThan().get();
        }

        @Override
        public void setRemoveUnusedEntriesAfterDays(int removeUnusedEntriesAfterDays) {
            if (removeUnusedEntriesAfterDays < 1) {
                throw new IllegalArgumentException(this.name + " cannot be set to retain entries for " + removeUnusedEntriesAfterDays + " days.  For time frames shorter than one day, use the 'removeUnusedEntriesOlderThan' property.");
            }
            this.getRemoveUnusedEntriesOlderThan().set(DefaultCacheConfigurations.providerFromSupplier(TimestampSuppliers.daysAgo(removeUnusedEntriesAfterDays)));
        }
    }
}

