/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import groovy.lang.Closure;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.gradle.api.Action;
import org.gradle.api.file.EmptyFileVisitor;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.internal.file.AntFileTreeBuilder;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.UnionFileTree;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.internal.MutableBoolean;
import org.gradle.util.internal.ConfigureUtil;

public abstract class AbstractFileTree
extends AbstractFileCollection
implements FileTreeInternal {
    public AbstractFileTree() {
    }

    public AbstractFileTree(TaskDependencyFactory taskDependencyFactory, Factory<PatternSet> patternSetFactory) {
        super(taskDependencyFactory, patternSetFactory);
    }

    @Override
    public Set<File> getFiles() {
        final LinkedHashSet<File> files = new LinkedHashSet<File>();
        this.visit(new EmptyFileVisitor(){

            @Override
            public void visitFile(FileVisitDetails fileDetails) {
                files.add(fileDetails.getFile());
            }
        });
        return files;
    }

    @Override
    public boolean isEmpty() {
        final MutableBoolean found = new MutableBoolean();
        this.visit(new EmptyFileVisitor(){

            @Override
            public void visitFile(FileVisitDetails fileDetails) {
                found.set(true);
                fileDetails.stopVisiting();
            }
        });
        return !found.get();
    }

    @Override
    public FileTree matching(Closure filterConfigClosure) {
        return this.matching(ConfigureUtil.configure(filterConfigClosure, (PatternSet)this.patternSetFactory.create()));
    }

    @Override
    public FileTree matching(Action<? super PatternFilterable> filterConfigAction) {
        PatternSet patternSet = (PatternSet)this.patternSetFactory.create();
        filterConfigAction.execute(patternSet);
        return this.matching(patternSet);
    }

    public Map<String, File> getAsMap() {
        final LinkedHashMap<String, File> map = new LinkedHashMap<String, File>();
        this.visit(new EmptyFileVisitor(){

            @Override
            public void visitFile(FileVisitDetails fileDetails) {
                map.put(fileDetails.getRelativePath().getPathString(), fileDetails.getFile());
            }
        });
        return map;
    }

    @Override
    protected void addAsResourceCollection(Object builder, String nodeName) {
        new AntFileTreeBuilder(this.getAsMap()).addToAntBuilder(builder, nodeName);
    }

    @Override
    public FileTreeInternal getAsFileTree() {
        return this;
    }

    @Override
    public FileTree plus(FileTree fileTree) {
        return new UnionFileTree(this.taskDependencyFactory, this, Cast.cast(FileTreeInternal.class, fileTree));
    }

    @Override
    public FileTree visit(Closure closure) {
        return this.visit(AbstractFileTree.fileVisitorFrom(closure));
    }

    static FileVisitor fileVisitorFrom(Closure closure) {
        return (FileVisitor)DefaultGroovyMethods.asType((Closure)closure, FileVisitor.class);
    }

    @Override
    public FileTree visit(final Action<? super FileVisitDetails> visitor) {
        return this.visit(new FileVisitor(){

            @Override
            public void visitDir(FileVisitDetails dirDetails) {
                visitor.execute(dirDetails);
            }

            @Override
            public void visitFile(FileVisitDetails fileDetails) {
                visitor.execute(fileDetails);
            }
        });
    }
}

