/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.quality.PmdReports;
import org.gradle.api.plugins.quality.TargetJdk;
import org.gradle.api.plugins.quality.internal.AbstractCodeQualityPlugin;
import org.gradle.api.plugins.quality.internal.PmdAction;
import org.gradle.api.plugins.quality.internal.PmdActionParameters;
import org.gradle.api.plugins.quality.internal.PmdReportsImpl;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.Reporting;
import org.gradle.api.resources.TextResource;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.LocalState;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.VerificationTask;
import org.gradle.internal.nativeintegration.console.ConsoleDetector;
import org.gradle.internal.nativeintegration.console.ConsoleMetaData;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.internal.CurrentJvmToolchainSpec;
import org.gradle.util.internal.ClosureBackedAction;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;

@CacheableTask
public abstract class Pmd
extends SourceTask
implements VerificationTask,
Reporting<PmdReports> {
    private FileCollection pmdClasspath;
    private List<String> ruleSets;
    private TargetJdk targetJdk;
    private TextResource ruleSetConfig;
    private FileCollection ruleSetFiles;
    private final PmdReports reports;
    private boolean ignoreFailures;
    private boolean consoleOutput;
    private FileCollection classpath;
    private final Property<Integer> rulesMinimumPriority;
    private final Property<Integer> maxFailures;
    private final Property<Boolean> incrementalAnalysis;
    private final Property<Integer> threads;
    private final Property<JavaLauncher> javaLauncher;

    public Pmd() {
        ObjectFactory objects = this.getObjectFactory();
        this.reports = objects.newInstance(PmdReportsImpl.class, this);
        this.rulesMinimumPriority = objects.property(Integer.class);
        this.incrementalAnalysis = objects.property(Boolean.class);
        this.maxFailures = objects.property(Integer.class);
        this.threads = objects.property(Integer.class);
        this.javaLauncher = Pmd.configureFromCurrentJvmLauncher(this.getToolchainService(), this.getObjectFactory());
    }

    private static Property<JavaLauncher> configureFromCurrentJvmLauncher(JavaToolchainService toolchainService, ObjectFactory objectFactory) {
        Provider<JavaLauncher> currentJvmLauncherProvider = toolchainService.launcherFor(new CurrentJvmToolchainSpec(objectFactory));
        return objectFactory.property(JavaLauncher.class).convention(currentJvmLauncherProvider);
    }

    @Inject
    protected ObjectFactory getObjectFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected JavaToolchainService getToolchainService() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected WorkerExecutor getWorkerExecutor() {
        throw new UnsupportedOperationException();
    }

    @Incubating
    @Nested
    public Property<JavaLauncher> getJavaLauncher() {
        return this.javaLauncher;
    }

    @TaskAction
    public void run() {
        Pmd.validate((Integer)this.rulesMinimumPriority.get());
        this.validateThreads((Integer)this.threads.get());
        WorkQueue workQueue = this.getWorkerExecutor().processIsolation(spec -> {
            spec.getForkOptions().setExecutable(((JavaLauncher)this.javaLauncher.get()).getExecutablePath().getAsFile().getAbsolutePath());
            AbstractCodeQualityPlugin.maybeAddOpensJvmArgs((JavaLauncher)this.javaLauncher.get(), spec);
        });
        workQueue.submit(PmdAction.class, this::setupParameters);
    }

    private void setupParameters(PmdActionParameters parameters) {
        parameters.getAntLibraryClasspath().setFrom(this.getPmdClasspath());
        parameters.getPmdClasspath().setFrom(this.getPmdClasspath());
        parameters.getTargetJdk().set(this.getTargetJdk());
        parameters.getRuleSets().set(this.getRuleSets());
        parameters.getRuleSetConfigFiles().from(this.getRuleSetFiles());
        if (this.getRuleSetConfig() != null) {
            parameters.getRuleSetConfigFiles().from(this.getRuleSetConfig().asFile());
        }
        parameters.getIgnoreFailures().set(this.getIgnoreFailures());
        parameters.getConsoleOutput().set(this.isConsoleOutput());
        parameters.getStdOutIsAttachedToTerminal().set(this.stdOutIsAttachedToTerminal());
        if (this.getClasspath() != null) {
            parameters.getAuxClasspath().setFrom(this.getClasspath());
        }
        parameters.getRulesMinimumPriority().set(this.getRulesMinimumPriority());
        parameters.getMaxFailures().set(this.getMaxFailures());
        parameters.getIncrementalAnalysis().set(this.getIncrementalAnalysis());
        parameters.getIncrementalCacheFile().set(this.getIncrementalCacheFile());
        parameters.getThreads().set(this.getThreads());
        parameters.getSource().setFrom(this.getSource());
        parameters.getEnabledReports().set(this.getReports().getEnabled().stream().map(report2 -> {
            PmdActionParameters.EnabledReport newReport = this.getObjectFactory().newInstance(PmdActionParameters.EnabledReport.class, new Object[0]);
            newReport.getName().set(report2.getName());
            newReport.getOutputLocation().set(report2.getOutputLocation());
            return newReport;
        }).collect(Collectors.toList()));
    }

    public boolean stdOutIsAttachedToTerminal() {
        try {
            ConsoleDetector consoleDetector = NativeServices.getInstance().get(ConsoleDetector.class);
            ConsoleMetaData consoleMetaData = consoleDetector.getConsole();
            return consoleMetaData != null && consoleMetaData.isStdOut();
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    @Override
    public PmdReports reports(@DelegatesTo(value=PmdReports.class, strategy=1) Closure closure) {
        return this.reports((Action)new ClosureBackedAction(closure));
    }

    @Override
    public PmdReports reports(Action<? super PmdReports> configureAction) {
        configureAction.execute(this.reports);
        return this.reports;
    }

    public static void validate(int value) {
        if (value > 5 || value < 1) {
            throw new InvalidUserDataException(String.format("Invalid rulesMinimumPriority '%d'.  Valid range 1 (highest) to 5 (lowest).", value));
        }
    }

    private void validateThreads(int value) {
        if (value < 0) {
            throw new InvalidUserDataException(String.format("Invalid number of threads '%d'.  Number should not be negative.", value));
        }
    }

    @Override
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileTree getSource() {
        return super.getSource();
    }

    @Classpath
    public FileCollection getPmdClasspath() {
        return this.pmdClasspath;
    }

    public void setPmdClasspath(FileCollection pmdClasspath) {
        this.pmdClasspath = pmdClasspath;
    }

    @Input
    public List<String> getRuleSets() {
        return this.ruleSets;
    }

    public void setRuleSets(List<String> ruleSets) {
        this.ruleSets = ruleSets;
    }

    @Input
    public TargetJdk getTargetJdk() {
        return this.targetJdk;
    }

    public void setTargetJdk(TargetJdk targetJdk) {
        this.targetJdk = targetJdk;
    }

    @Nullable
    @Optional
    @Nested
    public TextResource getRuleSetConfig() {
        return this.ruleSetConfig;
    }

    public void setRuleSetConfig(@Nullable TextResource ruleSetConfig) {
        this.ruleSetConfig = ruleSetConfig;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    public FileCollection getRuleSetFiles() {
        return this.ruleSetFiles;
    }

    public void setRuleSetFiles(FileCollection ruleSetFiles) {
        this.ruleSetFiles = ruleSetFiles;
    }

    @Override
    @Nested
    public final PmdReports getReports() {
        return this.reports;
    }

    @Override
    public boolean getIgnoreFailures() {
        return this.ignoreFailures;
    }

    @Override
    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }

    @Input
    public Property<Integer> getMaxFailures() {
        return this.maxFailures;
    }

    @Input
    public Property<Integer> getRulesMinimumPriority() {
        return this.rulesMinimumPriority;
    }

    @Input
    public boolean isConsoleOutput() {
        return this.consoleOutput;
    }

    public void setConsoleOutput(boolean consoleOutput) {
        this.consoleOutput = consoleOutput;
    }

    @Nullable
    @Optional
    @Classpath
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(@Nullable FileCollection classpath) {
        this.classpath = classpath;
    }

    @Internal
    public Property<Boolean> getIncrementalAnalysis() {
        return this.incrementalAnalysis;
    }

    @LocalState
    public File getIncrementalCacheFile() {
        return new File(this.getTemporaryDir(), "incremental.cache");
    }

    @Input
    public Property<Integer> getThreads() {
        return this.threads;
    }
}

