/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.services;

import java.io.IOException;
import javax.annotation.Nullable;
import org.gradle.StartParameter;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.caching.BuildCacheEntryReader;
import org.gradle.caching.BuildCacheEntryWriter;
import org.gradle.caching.BuildCacheException;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.BuildCacheService;
import org.gradle.caching.configuration.BuildCache;
import org.gradle.caching.internal.NextGenBuildCacheService;
import org.gradle.caching.internal.controller.BuildCacheController;
import org.gradle.caching.internal.controller.DefaultNextGenBuildCacheAccess;
import org.gradle.caching.internal.controller.GZipNextGenBuildCacheAccess;
import org.gradle.caching.internal.controller.NextGenBuildCacheController;
import org.gradle.caching.internal.controller.NextGenBuildCacheHandler;
import org.gradle.caching.internal.origin.OriginMetadataFactory;
import org.gradle.caching.internal.services.AbstractBuildCacheControllerFactory;
import org.gradle.caching.local.DirectoryBuildCache;
import org.gradle.caching.local.internal.H2BuildCacheService;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.file.BufferProvider;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.scopeids.id.BuildInvocationScopeId;
import org.gradle.internal.vfs.FileSystemAccess;
import org.gradle.util.internal.IncubationLogger;

public final class NextGenBuildCacheControllerFactory
extends AbstractBuildCacheControllerFactory<H2BuildCacheService> {
    private final Deleter deleter;
    private final BuildInvocationScopeId buildInvocationScopeId;
    private final ExecutorFactory executorFactory;
    private final BufferProvider bufferProvider;
    private static final NextGenBuildCacheHandler DISABLED_BUILD_CACHE_HANDLER = new NextGenBuildCacheHandler(){

        @Override
        public boolean canLoad() {
            return false;
        }

        @Override
        public boolean canStore() {
            return false;
        }

        @Override
        public boolean contains(BuildCacheKey key) {
            return false;
        }

        @Override
        public boolean load(BuildCacheKey key, BuildCacheEntryReader reader2) throws BuildCacheException {
            return false;
        }

        @Override
        public void store(BuildCacheKey key, NextGenBuildCacheService.NextGenWriter writer2) throws BuildCacheException {
        }

        @Override
        public void close() {
        }
    };

    public NextGenBuildCacheControllerFactory(StartParameter startParameter, BuildOperationExecutor buildOperationExecutor, OriginMetadataFactory originMetadataFactory, FileSystemAccess fileSystemAccess, StringInterner stringInterner, Deleter deleter, BuildInvocationScopeId buildInvocationScopeId, ExecutorFactory executorFactory, BufferProvider bufferProvider) {
        super(startParameter, buildOperationExecutor, originMetadataFactory, fileSystemAccess, stringInterner);
        this.deleter = deleter;
        this.buildInvocationScopeId = buildInvocationScopeId;
        this.executorFactory = executorFactory;
        this.bufferProvider = bufferProvider;
    }

    @Override
    protected BuildCacheController doCreateController(@Nullable AbstractBuildCacheControllerFactory.DescribedBuildCacheService<DirectoryBuildCache, H2BuildCacheService> localDescribedService, @Nullable AbstractBuildCacheControllerFactory.DescribedBuildCacheService<BuildCache, BuildCacheService> remoteDescribedService) {
        IncubationLogger.incubatingFeatureUsed("Next generation build cache");
        NextGenBuildCacheHandler local = NextGenBuildCacheControllerFactory.resolveService(localDescribedService);
        NextGenBuildCacheHandler remote = NextGenBuildCacheControllerFactory.resolveService(remoteDescribedService);
        return new NextGenBuildCacheController(this.buildInvocationScopeId.getId().asString(), this.deleter, this.fileSystemAccess, this.bufferProvider, this.stringInterner, new GZipNextGenBuildCacheAccess(new DefaultNextGenBuildCacheAccess(local, remote, this.bufferProvider, this.executorFactory), this.bufferProvider));
    }

    private static NextGenBuildCacheHandler resolveService(@Nullable AbstractBuildCacheControllerFactory.DescribedBuildCacheService<? extends BuildCache, ? extends BuildCacheService> describedService) {
        return describedService != null && ((BuildCache)describedService.config).isEnabled() ? new DefaultNextGenBuildCacheHandler(NextGenBuildCacheControllerFactory.makeCompatible((BuildCacheService)describedService.service), ((BuildCache)describedService.config).isPush()) : DISABLED_BUILD_CACHE_HANDLER;
    }

    private static NextGenBuildCacheService makeCompatible(final BuildCacheService service) {
        if (service instanceof NextGenBuildCacheService) {
            return (NextGenBuildCacheService)service;
        }
        return new NextGenBuildCacheService(){

            @Override
            public boolean contains(BuildCacheKey key) {
                return this.load(key, __ -> {});
            }

            @Override
            public boolean load(BuildCacheKey key, BuildCacheEntryReader reader2) throws BuildCacheException {
                return service.load(key, reader2);
            }

            @Override
            public void store(BuildCacheKey key, BuildCacheEntryWriter legacyWriter) throws BuildCacheException {
                service.store(key, legacyWriter);
            }

            @Override
            public void store(BuildCacheKey key, NextGenBuildCacheService.NextGenWriter writer2) throws BuildCacheException {
                service.store(key, writer2);
            }

            @Override
            public void close() throws IOException {
                service.close();
            }
        };
    }

    private static class DefaultNextGenBuildCacheHandler
    implements NextGenBuildCacheHandler {
        private final NextGenBuildCacheService service;
        private final boolean pushEnabled;

        public DefaultNextGenBuildCacheHandler(NextGenBuildCacheService service, boolean pushEnabled) {
            this.service = service;
            this.pushEnabled = pushEnabled;
        }

        @Override
        public boolean canLoad() {
            return true;
        }

        @Override
        public boolean canStore() {
            return this.pushEnabled;
        }

        @Override
        public boolean contains(BuildCacheKey key) {
            return this.service.contains(key);
        }

        @Override
        public boolean load(BuildCacheKey key, BuildCacheEntryReader reader2) throws BuildCacheException {
            return this.service.load(key, reader2);
        }

        @Override
        public void store(BuildCacheKey key, NextGenBuildCacheService.NextGenWriter writer2) throws BuildCacheException {
            if (this.pushEnabled) {
                this.service.store(key, writer2);
            }
        }

        @Override
        public void close() throws IOException {
            this.service.close();
        }
    }
}

