/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import java.util.List;
import java.util.ListIterator;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.ElvisOperatorExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.SpreadMapExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.BreakStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ContinueStatement;
import org.codehaus.groovy.ast.stmt.DoWhileStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.classgen.BytecodeExpression;
import org.gradle.groovy.scripts.internal.StatementReplacingVisitorSupport;

public class ExpressionReplacingVisitorSupport
extends StatementReplacingVisitorSupport {
    private Expression replacementExpr;

    public Expression replaceExpr(Expression expr) {
        this.replacementExpr = null;
        expr.visit((GroovyCodeVisitor)this);
        Expression result2 = this.replacementExpr == null ? expr : this.replacementExpr;
        this.replacementExpr = null;
        return result2;
    }

    protected <T extends Expression> void replaceAllExprs(List<T> exprs) {
        ListIterator<T> iter = exprs.listIterator();
        while (iter.hasNext()) {
            iter.set(this.replaceExpr((Expression)iter.next()));
        }
    }

    protected void replaceVisitedExpressionWith(Expression other) {
        this.replacementExpr = other;
    }

    @Override
    public void visitBlockStatement(BlockStatement stat) {
        this.replaceAll(stat.getStatements());
    }

    @Override
    public void visitForLoop(ForStatement stat) {
        stat.setCollectionExpression(this.replaceExpr(stat.getCollectionExpression()));
        stat.setLoopBlock(this.replace(stat.getLoopBlock()));
    }

    @Override
    public void visitWhileLoop(WhileStatement stat) {
        stat.setBooleanExpression((BooleanExpression)this.replaceExpr((Expression)stat.getBooleanExpression()));
        stat.setLoopBlock(this.replace(stat.getLoopBlock()));
    }

    @Override
    public void visitDoWhileLoop(DoWhileStatement stat) {
        stat.setBooleanExpression((BooleanExpression)this.replaceExpr((Expression)stat.getBooleanExpression()));
        stat.setLoopBlock(this.replace(stat.getLoopBlock()));
    }

    @Override
    public void visitIfElse(IfStatement stat) {
        stat.setBooleanExpression((BooleanExpression)this.replaceExpr((Expression)stat.getBooleanExpression()));
        stat.setIfBlock(this.replace(stat.getIfBlock()));
        stat.setElseBlock(this.replace(stat.getElseBlock()));
    }

    @Override
    public void visitTryCatchFinally(TryCatchStatement stat) {
        stat.setTryStatement(this.replace(stat.getTryStatement()));
        this.replaceAll(stat.getCatchStatements());
        stat.setFinallyStatement(this.replace(stat.getFinallyStatement()));
    }

    @Override
    public void visitSwitch(SwitchStatement stat) {
        stat.setExpression(this.replaceExpr(stat.getExpression()));
        this.replaceAll(stat.getCaseStatements());
        stat.setDefaultStatement(this.replace(stat.getDefaultStatement()));
    }

    @Override
    public void visitCaseStatement(CaseStatement stat) {
        stat.setExpression(this.replaceExpr(stat.getExpression()));
        stat.setCode(this.replace(stat.getCode()));
    }

    @Override
    public void visitSynchronizedStatement(SynchronizedStatement stat) {
        stat.setExpression(this.replaceExpr(stat.getExpression()));
        stat.setCode(this.replace(stat.getCode()));
    }

    @Override
    public void visitCatchStatement(CatchStatement stat) {
        stat.setCode(this.replace(stat.getCode()));
    }

    public void visitMethodCallExpression(MethodCallExpression expr) {
        expr.setObjectExpression(this.replaceExpr(expr.getObjectExpression()));
        expr.setMethod(this.replaceExpr(expr.getMethod()));
        expr.setArguments(this.replaceExpr(expr.getArguments()));
    }

    public void visitStaticMethodCallExpression(StaticMethodCallExpression expr) {
        StaticMethodCallExpression result2 = new StaticMethodCallExpression(expr.getOwnerType(), expr.getMethod(), this.replaceExpr(expr.getArguments()));
        result2.setType(expr.getType());
        result2.setSourcePosition((ASTNode)expr);
        this.replaceVisitedExpressionWith((Expression)result2);
    }

    public void visitConstructorCallExpression(ConstructorCallExpression expr) {
        ConstructorCallExpression result2 = new ConstructorCallExpression(expr.getType(), this.replaceExpr(expr.getArguments()));
        result2.setSourcePosition((ASTNode)expr);
        this.replaceVisitedExpressionWith((Expression)result2);
    }

    public void visitBinaryExpression(BinaryExpression expr) {
        expr.setLeftExpression(this.replaceExpr(expr.getLeftExpression()));
        expr.setRightExpression(this.replaceExpr(expr.getRightExpression()));
    }

    public void visitTernaryExpression(TernaryExpression expr) {
        TernaryExpression result2 = new TernaryExpression((BooleanExpression)this.replaceExpr((Expression)expr.getBooleanExpression()), this.replaceExpr(expr.getTrueExpression()), this.replaceExpr(expr.getFalseExpression()));
        result2.setType(expr.getType());
        result2.setSourcePosition((ASTNode)expr);
        this.replaceVisitedExpressionWith((Expression)result2);
    }

    public void visitShortTernaryExpression(ElvisOperatorExpression expr) {
        ElvisOperatorExpression result2 = new ElvisOperatorExpression(this.replaceExpr(expr.getTrueExpression()), this.replaceExpr(expr.getFalseExpression()));
        result2.setType(expr.getType());
        result2.setSourcePosition((ASTNode)expr);
        this.replaceVisitedExpressionWith((Expression)result2);
    }

    public void visitPostfixExpression(PostfixExpression expr) {
        expr.setExpression(this.replaceExpr(expr.getExpression()));
    }

    public void visitPrefixExpression(PrefixExpression expr) {
        expr.setExpression(this.replaceExpr(expr.getExpression()));
    }

    public void visitBooleanExpression(BooleanExpression expr) {
        BooleanExpression result2 = new BooleanExpression(this.replaceExpr(expr.getExpression()));
        result2.setType(expr.getType());
        result2.setSourcePosition((ASTNode)expr);
        this.replaceVisitedExpressionWith((Expression)result2);
    }

    public void visitNotExpression(NotExpression expr) {
        NotExpression result2 = new NotExpression(this.replaceExpr(expr.getExpression()));
        result2.setType(expr.getType());
        result2.setSourcePosition((ASTNode)expr);
        this.replaceVisitedExpressionWith((Expression)result2);
    }

    public void visitClosureExpression(ClosureExpression expr) {
        for (Parameter parameter : expr.getParameters()) {
            if (!parameter.hasInitialExpression()) continue;
            parameter.setInitialExpression(this.replaceExpr(parameter.getInitialExpression()));
        }
        expr.getCode().visit((GroovyCodeVisitor)this);
        this.replaceVisitedExpressionWith((Expression)expr);
    }

    public void visitTupleExpression(TupleExpression expr) {
        this.replaceAllExprs(expr.getExpressions());
    }

    public void visitListExpression(ListExpression expr) {
        this.replaceAllExprs(expr.getExpressions());
    }

    public void visitArrayExpression(ArrayExpression expr) {
        this.replaceAllExprs(expr.getExpressions());
        this.replaceAllExprs(expr.getSizeExpression());
    }

    public void visitMapExpression(MapExpression expr) {
        this.replaceAllExprs(expr.getMapEntryExpressions());
    }

    public void visitMapEntryExpression(MapEntryExpression expr) {
        MapEntryExpression result2 = new MapEntryExpression(this.replaceExpr(expr.getKeyExpression()), this.replaceExpr(expr.getValueExpression()));
        result2.setType(expr.getType());
        result2.setSourcePosition((ASTNode)expr);
        this.replaceVisitedExpressionWith((Expression)result2);
    }

    public void visitRangeExpression(RangeExpression expr) {
        RangeExpression result2 = new RangeExpression(this.replaceExpr(expr.getFrom()), this.replaceExpr(expr.getTo()), expr.isInclusive());
        result2.setType(expr.getType());
        result2.setSourcePosition((ASTNode)expr);
        this.replaceVisitedExpressionWith((Expression)result2);
    }

    public void visitSpreadExpression(SpreadExpression expr) {
        SpreadExpression result2 = new SpreadExpression(this.replaceExpr(expr.getExpression()));
        result2.setType(expr.getType());
        result2.setSourcePosition((ASTNode)expr);
        this.replaceVisitedExpressionWith((Expression)result2);
    }

    public void visitSpreadMapExpression(SpreadMapExpression expr) {
        SpreadMapExpression result2 = new SpreadMapExpression(this.replaceExpr(expr.getExpression()));
        result2.setType(expr.getType());
        result2.setSourcePosition((ASTNode)expr);
        this.replaceVisitedExpressionWith((Expression)result2);
    }

    public void visitMethodPointerExpression(MethodPointerExpression expr) {
        MethodPointerExpression result2 = new MethodPointerExpression(this.replaceExpr(expr.getExpression()), expr.getMethodName());
        result2.setType(expr.getType());
        result2.setSourcePosition((ASTNode)expr);
        this.replaceVisitedExpressionWith((Expression)result2);
    }

    public void visitUnaryMinusExpression(UnaryMinusExpression expr) {
        UnaryMinusExpression result2 = new UnaryMinusExpression(this.replaceExpr(expr.getExpression()));
        result2.setType(expr.getType());
        result2.setSourcePosition((ASTNode)expr);
        this.replaceVisitedExpressionWith((Expression)result2);
    }

    public void visitUnaryPlusExpression(UnaryPlusExpression expr) {
        UnaryPlusExpression result2 = new UnaryPlusExpression(this.replaceExpr(expr.getExpression()));
        result2.setType(expr.getType());
        result2.setSourcePosition((ASTNode)expr);
        this.replaceVisitedExpressionWith((Expression)result2);
    }

    public void visitBitwiseNegationExpression(BitwiseNegationExpression expr) {
        BitwiseNegationExpression result2 = new BitwiseNegationExpression(this.replaceExpr(expr.getExpression()));
        result2.setType(expr.getType());
        result2.setSourcePosition((ASTNode)expr);
        this.replaceVisitedExpressionWith((Expression)result2);
    }

    public void visitCastExpression(CastExpression expr) {
        CastExpression result2 = new CastExpression(expr.getType(), this.replaceExpr(expr.getExpression()), expr.isIgnoringAutoboxing());
        result2.setCoerce(expr.isCoerce());
        result2.setSourcePosition((ASTNode)expr);
        this.replaceVisitedExpressionWith((Expression)result2);
    }

    public void visitDeclarationExpression(DeclarationExpression expr) {
        this.visitBinaryExpression((BinaryExpression)expr);
        this.replaceVisitedExpressionWith((Expression)expr);
    }

    public void visitPropertyExpression(PropertyExpression expr) {
        PropertyExpression result2 = new PropertyExpression(this.replaceExpr(expr.getObjectExpression()), this.replaceExpr(expr.getProperty()), expr.isSafe());
        result2.setSpreadSafe(expr.isSpreadSafe());
        result2.setStatic(expr.isStatic());
        result2.setImplicitThis(expr.isImplicitThis());
        result2.setType(expr.getType());
        result2.setSourcePosition((ASTNode)expr);
        this.replaceVisitedExpressionWith((Expression)result2);
    }

    public void visitAttributeExpression(AttributeExpression expr) {
        this.visitPropertyExpression((PropertyExpression)expr);
        this.replaceVisitedExpressionWith((Expression)expr);
    }

    public void visitGStringExpression(GStringExpression expr) {
        this.replaceAllExprs(expr.getStrings());
        this.replaceAllExprs(expr.getValues());
    }

    public void visitArgumentlistExpression(ArgumentListExpression expr) {
        this.visitTupleExpression((TupleExpression)expr);
        this.replaceVisitedExpressionWith((Expression)expr);
    }

    public void visitClosureListExpression(ClosureListExpression expr) {
        this.visitListExpression((ListExpression)expr);
        this.replaceVisitedExpressionWith((Expression)expr);
    }

    public void visitAssertStatement(AssertStatement stat) {
        this.replaceExpr((Expression)stat.getBooleanExpression());
        this.replaceExpr(stat.getMessageExpression());
    }

    public void visitExpressionStatement(ExpressionStatement stat) {
        stat.setExpression(this.replaceExpr(stat.getExpression()));
    }

    public void visitReturnStatement(ReturnStatement stat) {
        this.replaceExpr(stat.getExpression());
    }

    public void visitThrowStatement(ThrowStatement stat) {
        this.replaceExpr(stat.getExpression());
    }

    public void visitListOfExpressions(List<? extends Expression> exprs) {
        throw new UnsupportedOperationException("visitListOfExpressions");
    }

    public void visitBreakStatement(BreakStatement stat) {
    }

    public void visitContinueStatement(ContinueStatement stat) {
    }

    public void visitConstantExpression(ConstantExpression expr) {
    }

    public void visitClassExpression(ClassExpression expr) {
    }

    public void visitVariableExpression(VariableExpression expr) {
    }

    public void visitFieldExpression(FieldExpression expr) {
    }

    public void visitBytecodeExpression(BytecodeExpression expr) {
    }
}

