/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.local.model.LocalComponentArtifactMetadata;
import org.gradle.internal.component.local.model.LocalComponentMetadata;
import org.gradle.internal.component.local.model.LocalConfigurationGraphResolveMetadata;
import org.gradle.internal.component.local.model.LocalConfigurationMetadata;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;
import org.gradle.internal.component.local.model.LocalVariantMetadata;
import org.gradle.internal.component.local.model.MissingLocalArtifactMetadata;
import org.gradle.internal.component.local.model.PublishArtifactLocalArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.LocalOriginDependencyMetadata;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.model.CalculatedValueContainer;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.model.ModelContainer;

public final class DefaultLocalConfigurationMetadata
implements LocalConfigurationMetadata,
LocalConfigurationGraphResolveMetadata {
    private final String name;
    private final String description;
    private final ComponentIdentifier componentId;
    private final boolean transitive;
    private final boolean visible;
    private final ImmutableSet<String> hierarchy;
    private final ImmutableAttributes attributes;
    private final boolean canBeConsumed;
    private final boolean deprecatedForConsumption;
    private final boolean canBeResolved;
    private final ImmutableCapabilities capabilities;
    private final List<LocalOriginDependencyMetadata> configurationDependencies;
    private final Set<LocalFileDependencyMetadata> configurationFileDependencies;
    private final ImmutableList<ExcludeMetadata> configurationExcludes;
    private final Set<LocalVariantMetadata> variants;
    private final CalculatedValueContainerFactory factory;
    private final CalculatedValueContainer<ImmutableList<LocalComponentArtifactMetadata>, ?> artifacts;

    public DefaultLocalConfigurationMetadata(String name, String description, ComponentIdentifier componentId, boolean visible, boolean transitive, Set<String> hierarchy, ImmutableAttributes attributes, ImmutableCapabilities capabilities, boolean canBeConsumed, boolean deprecatedForConsumption, boolean canBeResolved, List<LocalOriginDependencyMetadata> configurationDependencies, Set<LocalFileDependencyMetadata> configurationFileDependencies, List<ExcludeMetadata> configurationExcludes, Set<LocalVariantMetadata> variants, List<PublishArtifact> definedArtifacts, ModelContainer<?> model, CalculatedValueContainerFactory factory, LocalComponentMetadata component) {
        this(name, description, componentId, visible, transitive, hierarchy, attributes, capabilities, canBeConsumed, deprecatedForConsumption, canBeResolved, configurationDependencies, configurationFileDependencies, configurationExcludes, variants, factory, DefaultLocalConfigurationMetadata.getLazyArtifacts(definedArtifacts, name, description, hierarchy, model, factory, component));
    }

    public DefaultLocalConfigurationMetadata(String name, String description, ComponentIdentifier componentId, boolean visible, boolean transitive, Set<String> hierarchy, ImmutableAttributes attributes, ImmutableCapabilities capabilities, boolean canBeConsumed, boolean deprecatedForConsumption, boolean canBeResolved, List<LocalOriginDependencyMetadata> configurationDependencies, Set<LocalFileDependencyMetadata> configurationFileDependencies, List<ExcludeMetadata> configurationExcludes, Set<LocalVariantMetadata> variants, CalculatedValueContainerFactory factory, List<LocalComponentArtifactMetadata> artifacts2) {
        this(name, description, componentId, visible, transitive, hierarchy, attributes, capabilities, canBeConsumed, deprecatedForConsumption, canBeResolved, configurationDependencies, configurationFileDependencies, configurationExcludes, variants, factory, factory.create(Describables.of(description, "artifacts"), ImmutableList.copyOf(artifacts2)));
    }

    private DefaultLocalConfigurationMetadata(String name, String description, ComponentIdentifier componentId, boolean visible, boolean transitive, Set<String> hierarchy, ImmutableAttributes attributes, ImmutableCapabilities capabilities, boolean canBeConsumed, boolean deprecatedForConsumption, boolean canBeResolved, List<LocalOriginDependencyMetadata> configurationDependencies, Set<LocalFileDependencyMetadata> configurationFileDependencies, List<ExcludeMetadata> configurationExcludes, Set<LocalVariantMetadata> variants, CalculatedValueContainerFactory factory, CalculatedValueContainer<ImmutableList<LocalComponentArtifactMetadata>, ?> artifacts2) {
        this.name = name;
        this.description = description;
        this.componentId = componentId;
        this.visible = visible;
        this.transitive = transitive;
        this.hierarchy = ImmutableSet.copyOf(hierarchy);
        this.attributes = attributes;
        this.capabilities = capabilities;
        this.canBeConsumed = canBeConsumed;
        this.deprecatedForConsumption = deprecatedForConsumption;
        this.canBeResolved = canBeResolved;
        this.configurationDependencies = configurationDependencies;
        this.configurationFileDependencies = configurationFileDependencies;
        this.configurationExcludes = ImmutableList.copyOf(configurationExcludes);
        this.variants = variants;
        this.factory = factory;
        this.artifacts = artifacts2;
    }

    private static CalculatedValueContainer<ImmutableList<LocalComponentArtifactMetadata>, ?> getLazyArtifacts(List<PublishArtifact> sourceArtifacts, String name, String description, Set<String> hierarchy, ModelContainer<?> model, CalculatedValueContainerFactory factory, LocalComponentMetadata component) {
        return factory.create(Describables.of(description, "artifacts"), context -> {
            if (sourceArtifacts.isEmpty() && hierarchy.isEmpty()) {
                return ImmutableList.of();
            }
            return model.fromMutableState(m -> {
                LinkedHashSet<? extends LocalComponentArtifactMetadata> result2 = new LinkedHashSet<LocalComponentArtifactMetadata>(sourceArtifacts.size());
                for (PublishArtifact sourceArtifact : sourceArtifacts) {
                    result2.add(new PublishArtifactLocalArtifactMetadata(component.getId(), sourceArtifact));
                }
                for (String config : hierarchy) {
                    if (config.equals(name)) continue;
                    LocalConfigurationMetadata parent = component.getConfiguration(config);
                    result2.addAll((Collection<? extends LocalComponentArtifactMetadata>)parent.prepareToResolveArtifacts().getArtifacts());
                }
                return ImmutableList.copyOf(result2);
            });
        });
    }

    @Override
    public LocalConfigurationMetadata copy(Transformer<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> artifactTransformer) {
        ImmutableSet.Builder copiedVariants = ImmutableSet.builder();
        for (LocalVariantMetadata oldVariant : this.variants) {
            ImmutableList newArtifacts = (ImmutableList)oldVariant.prepareToResolveArtifacts().getArtifacts().stream().map(artifactTransformer::transform).collect(ImmutableList.toImmutableList());
            copiedVariants.add((Object)new LocalVariantMetadata(oldVariant.getName(), oldVariant.getIdentifier(), oldVariant.asDescribable(), oldVariant.getAttributes(), (ImmutableCapabilities)oldVariant.getCapabilities(), (List<LocalComponentArtifactMetadata>)newArtifacts, this.factory));
        }
        ImmutableList copiedArtifacts = (ImmutableList)this.prepareToResolveArtifacts().getArtifacts().stream().map(artifactTransformer::transform).collect(ImmutableList.toImmutableList());
        return new DefaultLocalConfigurationMetadata(this.name, this.description, this.componentId, this.visible, this.transitive, (Set<String>)this.hierarchy, this.attributes, this.capabilities, this.canBeConsumed, this.deprecatedForConsumption, this.canBeResolved, this.configurationDependencies, this.configurationFileDependencies, (List<ExcludeMetadata>)this.configurationExcludes, (Set<LocalVariantMetadata>)copiedVariants.build(), this.factory, (List<LocalComponentArtifactMetadata>)copiedArtifacts);
    }

    public String toString() {
        return this.asDescribable().getDisplayName();
    }

    @Override
    public DisplayName asDescribable() {
        return Describables.of(this.componentId, "configuration", this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ImmutableSet<String> getHierarchy() {
        return this.hierarchy;
    }

    @Override
    public boolean isTransitive() {
        return this.transitive;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public ImmutableAttributes getAttributes() {
        return this.attributes;
    }

    public Set<LocalVariantMetadata> getVariants() {
        return this.variants;
    }

    @Override
    public boolean isCanBeConsumed() {
        return this.canBeConsumed;
    }

    @Override
    public boolean isDeprecatedForConsumption() {
        return this.deprecatedForConsumption;
    }

    @Override
    public boolean isCanBeResolved() {
        return this.canBeResolved;
    }

    public List<? extends LocalOriginDependencyMetadata> getDependencies() {
        return this.configurationDependencies;
    }

    @Override
    public Set<LocalFileDependencyMetadata> getFiles() {
        return this.configurationFileDependencies;
    }

    @Override
    public ImmutableList<ExcludeMetadata> getExcludes() {
        return this.configurationExcludes;
    }

    @Override
    public LocalConfigurationMetadata prepareToResolveArtifacts() {
        this.artifacts.finalizeIfNotAlready();
        for (LocalVariantMetadata variant : this.variants) {
            variant.prepareToResolveArtifacts();
        }
        return this;
    }

    public ImmutableList<LocalComponentArtifactMetadata> getArtifacts() {
        return this.artifacts.get();
    }

    @Override
    public ComponentArtifactMetadata artifact(IvyArtifactName ivyArtifactName) {
        for (ComponentArtifactMetadata candidate : this.getArtifacts()) {
            if (!candidate.getName().equals(ivyArtifactName)) continue;
            return candidate;
        }
        return new MissingLocalArtifactMetadata(this.componentId, ivyArtifactName);
    }

    @Override
    public ImmutableCapabilities getCapabilities() {
        return this.capabilities;
    }

    @Override
    public boolean isExternalVariant() {
        return false;
    }
}

