/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.IncompatibleConfigurationSelectionException;
import org.gradle.internal.component.model.AttributeConfigurationSelector;
import org.gradle.internal.component.model.ComponentGraphResolveMetadata;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.component.model.ConfigurationGraphResolveMetadata;
import org.gradle.internal.component.model.ConfigurationNotFoundException;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.DescriberSelector;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.LocalOriginDependencyMetadata;
import org.gradle.internal.component.model.VariantGraphResolveMetadata;
import org.gradle.internal.component.model.VariantSelectionResult;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.exceptions.ConfigurationNotConsumableException;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.base.Optional;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.util.internal.GUtil;

public class LocalComponentDependencyMetadata
implements LocalOriginDependencyMetadata {
    private final ComponentIdentifier componentId;
    private final ComponentSelector selector;
    private final String moduleConfiguration;
    private final String dependencyConfiguration;
    private final List<ExcludeMetadata> excludes;
    private final List<IvyArtifactName> artifactNames;
    private final boolean force;
    private final boolean changing;
    private final boolean transitive;
    private final boolean constraint;
    private final boolean endorsing;
    private final boolean fromLock;
    private final String reason;
    private final AttributeContainer moduleAttributes;
    private final ImmutableAttributes dependencyAttributes;

    public LocalComponentDependencyMetadata(ComponentIdentifier componentId, ComponentSelector selector, @Nullable String moduleConfiguration, @Nullable AttributeContainer moduleAttributes, AttributeContainer dependencyAttributes, @Nullable String dependencyConfiguration, List<IvyArtifactName> artifactNames, List<ExcludeMetadata> excludes, boolean force, boolean changing, boolean transitive, boolean constraint, boolean endorsing, @Nullable String reason) {
        this(componentId, selector, moduleConfiguration, moduleAttributes, dependencyAttributes, dependencyConfiguration, artifactNames, excludes, force, changing, transitive, constraint, endorsing, false, reason);
    }

    public LocalComponentDependencyMetadata(ComponentIdentifier componentId, ComponentSelector selector, @Nullable String moduleConfiguration, AttributeContainer moduleAttributes, AttributeContainer dependencyAttributes, @Nullable String dependencyConfiguration, List<IvyArtifactName> artifactNames, List<ExcludeMetadata> excludes, boolean force, boolean changing, boolean transitive, boolean constraint, boolean endorsing, boolean fromLock, @Nullable String reason) {
        this.componentId = componentId;
        this.selector = selector;
        this.moduleConfiguration = moduleConfiguration;
        this.moduleAttributes = moduleAttributes;
        this.dependencyAttributes = ((AttributeContainerInternal)dependencyAttributes).asImmutable();
        this.dependencyConfiguration = dependencyConfiguration;
        this.artifactNames = LocalComponentDependencyMetadata.asImmutable(artifactNames);
        this.excludes = excludes;
        this.force = force;
        this.changing = changing;
        this.transitive = transitive;
        this.constraint = constraint;
        this.endorsing = endorsing;
        this.fromLock = fromLock;
        this.reason = reason;
    }

    private static List<IvyArtifactName> asImmutable(List<IvyArtifactName> artifactNames) {
        return artifactNames.isEmpty() ? Collections.emptyList() : (artifactNames instanceof ImmutableList ? artifactNames : ImmutableList.copyOf(artifactNames));
    }

    public String toString() {
        return "dependency: " + this.selector + " from-conf: " + this.moduleConfiguration + " to-conf: " + this.dependencyConfiguration;
    }

    @Override
    public ComponentSelector getSelector() {
        return this.selector;
    }

    @Override
    public String getModuleConfiguration() {
        return this.moduleConfiguration;
    }

    @Override
    public String getDependencyConfiguration() {
        return LocalComponentDependencyMetadata.getOrDefaultConfiguration(this.dependencyConfiguration);
    }

    private static String getOrDefaultConfiguration(String configuration) {
        return GUtil.elvis(configuration, "default");
    }

    @Override
    public VariantSelectionResult selectVariants(ImmutableAttributes consumerAttributes, ComponentGraphResolveState targetComponentState, AttributesSchemaInternal consumerSchema, Collection<? extends Capability> explicitRequestedCapabilities) {
        AttributesSchemaInternal producerAttributeSchema;
        boolean useConfigurationAttributes;
        ComponentGraphResolveMetadata targetComponent = targetComponentState.getMetadata();
        boolean consumerHasAttributes = !consumerAttributes.isEmpty();
        Optional<List<? extends VariantGraphResolveMetadata>> targetVariants = targetComponent.getVariantsForGraphTraversal();
        boolean bl = useConfigurationAttributes = this.dependencyConfiguration == null && (consumerHasAttributes || targetVariants.isPresent());
        if (useConfigurationAttributes) {
            return AttributeConfigurationSelector.selectVariantsUsingAttributeMatching(consumerAttributes, explicitRequestedCapabilities, targetComponentState, consumerSchema, this.getArtifacts());
        }
        String targetConfiguration = GUtil.elvis(this.dependencyConfiguration, "default");
        ConfigurationGraphResolveMetadata toConfiguration = targetComponent.getConfiguration(targetConfiguration);
        if (toConfiguration == null) {
            throw new ConfigurationNotFoundException(this.componentId, this.moduleConfiguration, targetConfiguration, targetComponent.getId());
        }
        this.verifyConsumability(targetComponent, toConfiguration);
        if (consumerHasAttributes && !toConfiguration.getAttributes().isEmpty() && !consumerSchema.withProducer(producerAttributeSchema = targetComponent.getAttributesSchema()).isMatching(toConfiguration.getAttributes(), consumerAttributes)) {
            throw new IncompatibleConfigurationSelectionException(consumerAttributes, consumerSchema.withProducer(producerAttributeSchema), targetComponent, targetConfiguration, targetVariants.isPresent(), DescriberSelector.selectDescriber(consumerAttributes, consumerSchema));
        }
        return new VariantSelectionResult((List<? extends VariantGraphResolveMetadata>)ImmutableList.of((Object)toConfiguration), false);
    }

    private void verifyConsumability(ComponentGraphResolveMetadata targetComponent, ConfigurationGraphResolveMetadata toConfiguration) {
        if (!toConfiguration.isCanBeConsumed()) {
            throw new ConfigurationNotConsumableException(targetComponent.toString(), toConfiguration.getName());
        }
        if (toConfiguration.isDeprecatedForConsumption()) {
            ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateConfiguration(toConfiguration.getName()).forConsumption().willBecomeAnErrorInGradle9().withUserManual("dependencies_should_no_longer_be_declared_using_the_compile_and_runtime_configurations")).nagUser();
        }
    }

    @Override
    public List<ExcludeMetadata> getExcludes() {
        return this.excludes;
    }

    @Override
    public boolean isChanging() {
        return this.changing;
    }

    @Override
    public boolean isTransitive() {
        return this.transitive;
    }

    @Override
    public boolean isForce() {
        return this.force;
    }

    @Override
    public boolean isConstraint() {
        return this.constraint;
    }

    @Override
    public boolean isEndorsingStrictVersions() {
        return this.endorsing;
    }

    private boolean isExternalVariant() {
        return false;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public List<IvyArtifactName> getArtifacts() {
        return this.artifactNames;
    }

    @Override
    public LocalOriginDependencyMetadata withTarget(ComponentSelector target) {
        if (this.selector.equals(target)) {
            return this;
        }
        return this.copyWithTarget(target);
    }

    @Override
    public LocalOriginDependencyMetadata withTargetAndArtifacts(ComponentSelector target, List<IvyArtifactName> artifacts2) {
        if (this.selector.equals(target) && artifacts2.equals(this.getArtifacts())) {
            return this;
        }
        return this.copyWithTargetAndArtifacts(target, artifacts2);
    }

    @Override
    public LocalOriginDependencyMetadata forced() {
        if (this.force) {
            return this;
        }
        return this.copyWithForce();
    }

    @Override
    public boolean isFromLock() {
        return this.fromLock;
    }

    @Override
    public DependencyMetadata withReason(String reason) {
        if (Objects.equal((Object)reason, (Object)this.reason)) {
            return this;
        }
        return this.copyWithReason(reason);
    }

    private LocalOriginDependencyMetadata copyWithTarget(ComponentSelector selector) {
        return new LocalComponentDependencyMetadata(this.componentId, selector, this.moduleConfiguration, this.moduleAttributes, this.dependencyAttributes, this.dependencyConfiguration, this.artifactNames, this.excludes, this.force, this.changing, this.transitive, this.constraint, this.endorsing, this.fromLock, this.reason);
    }

    private LocalOriginDependencyMetadata copyWithTargetAndArtifacts(ComponentSelector selector, List<IvyArtifactName> artifactNames) {
        return new LocalComponentDependencyMetadata(this.componentId, selector, this.moduleConfiguration, this.moduleAttributes, this.dependencyAttributes, this.dependencyConfiguration, artifactNames, this.excludes, this.force, this.changing, this.transitive, this.constraint, this.endorsing, this.fromLock, this.reason);
    }

    private LocalOriginDependencyMetadata copyWithReason(String reason) {
        return new LocalComponentDependencyMetadata(this.componentId, this.selector, this.moduleConfiguration, this.moduleAttributes, this.dependencyAttributes, this.dependencyConfiguration, this.artifactNames, this.excludes, this.force, this.changing, this.transitive, this.constraint, this.endorsing, this.fromLock, reason);
    }

    private LocalOriginDependencyMetadata copyWithForce() {
        return new LocalComponentDependencyMetadata(this.componentId, this.selector, this.moduleConfiguration, this.moduleAttributes, this.dependencyAttributes, this.dependencyConfiguration, this.artifactNames, this.excludes, true, this.changing, this.transitive, this.constraint, this.endorsing, this.fromLock, this.reason);
    }
}

