/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.nativeintegration.filesystem.jdk7;

import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.Set;

public class PosixFilePermissionConverter {
    public static Set<PosixFilePermission> convertToPermissionsSet(int mode) {
        EnumSet<PosixFilePermission> result2 = EnumSet.noneOf(PosixFilePermission.class);
        if (PosixFilePermissionConverter.isSet(mode, 256)) {
            result2.add(PosixFilePermission.OWNER_READ);
        }
        if (PosixFilePermissionConverter.isSet(mode, 128)) {
            result2.add(PosixFilePermission.OWNER_WRITE);
        }
        if (PosixFilePermissionConverter.isSet(mode, 64)) {
            result2.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if (PosixFilePermissionConverter.isSet(mode, 32)) {
            result2.add(PosixFilePermission.GROUP_READ);
        }
        if (PosixFilePermissionConverter.isSet(mode, 16)) {
            result2.add(PosixFilePermission.GROUP_WRITE);
        }
        if (PosixFilePermissionConverter.isSet(mode, 8)) {
            result2.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if (PosixFilePermissionConverter.isSet(mode, 4)) {
            result2.add(PosixFilePermission.OTHERS_READ);
        }
        if (PosixFilePermissionConverter.isSet(mode, 2)) {
            result2.add(PosixFilePermission.OTHERS_WRITE);
        }
        if (PosixFilePermissionConverter.isSet(mode, 1)) {
            result2.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return result2;
    }

    private static boolean isSet(int mode, int testbit) {
        return (mode & testbit) == testbit;
    }

    public static int convertToInt(Set<PosixFilePermission> permissions) {
        int result2 = 0;
        if (permissions.contains((Object)PosixFilePermission.OWNER_READ)) {
            result2 |= 0x100;
        }
        if (permissions.contains((Object)PosixFilePermission.OWNER_WRITE)) {
            result2 |= 0x80;
        }
        if (permissions.contains((Object)PosixFilePermission.OWNER_EXECUTE)) {
            result2 |= 0x40;
        }
        if (permissions.contains((Object)PosixFilePermission.GROUP_READ)) {
            result2 |= 0x20;
        }
        if (permissions.contains((Object)PosixFilePermission.GROUP_WRITE)) {
            result2 |= 0x10;
        }
        if (permissions.contains((Object)PosixFilePermission.GROUP_EXECUTE)) {
            result2 |= 8;
        }
        if (permissions.contains((Object)PosixFilePermission.OTHERS_READ)) {
            result2 |= 4;
        }
        if (permissions.contains((Object)PosixFilePermission.OTHERS_WRITE)) {
            result2 |= 2;
        }
        if (permissions.contains((Object)PosixFilePermission.OTHERS_EXECUTE)) {
            result2 |= 1;
        }
        return result2;
    }
}

