/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class OsXJavaHomeOutputParser {
    private static final Pattern INSTALLATION_PATTERN = Pattern.compile(".+\\s+(/.+)");

    public Set<File> parse(Reader output) {
        BufferedReader reader2 = new BufferedReader(output);
        return reader2.lines().flatMap(line -> {
            Matcher matcher = INSTALLATION_PATTERN.matcher((CharSequence)line);
            if (matcher.matches()) {
                String javaHome = matcher.group(1);
                return Stream.of(javaHome);
            }
            return Stream.empty();
        }).map(File::new).collect(Collectors.toSet());
    }
}

