/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.exec;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.logging.LoggingOutputInternal;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.events.ProgressCompleteEvent;
import org.gradle.internal.logging.events.ProgressEvent;
import org.gradle.internal.logging.events.ProgressStartEvent;
import org.gradle.launcher.daemon.diagnostics.DaemonDiagnostics;
import org.gradle.launcher.daemon.protocol.Build;
import org.gradle.launcher.daemon.server.api.DaemonCommandExecution;
import org.gradle.launcher.daemon.server.api.DaemonConnection;
import org.gradle.launcher.daemon.server.exec.BuildCommandOnly;

public class LogToClient
extends BuildCommandOnly {
    public static final String DISABLE_OUTPUT = "org.gradle.daemon.disable-output";
    private static final Logger LOGGER = Logging.getLogger(LogToClient.class);
    private final LoggingOutputInternal loggingOutput;
    private final DaemonDiagnostics diagnostics;
    private volatile AsynchronousLogDispatcher dispatcher;

    public LogToClient(LoggingOutputInternal loggingOutput, DaemonDiagnostics diagnostics) {
        this.loggingOutput = loggingOutput;
        this.diagnostics = diagnostics;
    }

    @Override
    protected void doBuild(DaemonCommandExecution execution, Build build) {
        if (Boolean.getBoolean(DISABLE_OUTPUT)) {
            execution.proceed();
            return;
        }
        this.dispatcher = new AsynchronousLogDispatcher(execution.getConnection(), build.getParameters().getLogLevel());
        LOGGER.info("{}{}). The daemon log file: {}", "The client will now receive all logging from the daemon (pid: ", this.diagnostics.getPid(), this.diagnostics.getDaemonLog());
        this.dispatcher.start();
        try {
            execution.proceed();
        }
        finally {
            this.dispatcher.waitForCompletion();
        }
    }

    private class AsynchronousLogDispatcher
    extends Thread {
        private final CountDownLatch completionLock;
        private final Queue<OutputEvent> eventQueue;
        private final DaemonConnection connection;
        private final OutputEventListener listener;
        private volatile boolean shouldStop;
        private boolean unableToSend;

        private AsynchronousLogDispatcher(DaemonConnection conn, final LogLevel buildLogLevel) {
            super("Asynchronous log dispatcher for " + conn);
            this.completionLock = new CountDownLatch(1);
            this.eventQueue = new ConcurrentLinkedQueue<OutputEvent>();
            this.connection = conn;
            this.listener = new OutputEventListener(){

                @Override
                public void onOutput(OutputEvent event) {
                    if (LogToClient.this.dispatcher != null && (this.isMatchingBuildLogLevel(event) || this.isProgressEvent(event))) {
                        LogToClient.this.dispatcher.submit(event);
                    }
                }

                private boolean isProgressEvent(OutputEvent event) {
                    return event instanceof ProgressStartEvent || event instanceof ProgressEvent || event instanceof ProgressCompleteEvent;
                }

                private boolean isMatchingBuildLogLevel(OutputEvent event) {
                    return buildLogLevel != null && event.getLogLevel() != null && event.getLogLevel().compareTo(buildLogLevel) >= 0;
                }
            };
            LOGGER.debug("About to start relaying all logs to the client via the connection.");
            LogToClient.this.loggingOutput.addOutputEventListener(this.listener);
        }

        public void submit(OutputEvent event) {
            this.eventQueue.add(event);
        }

        @Override
        public void run() {
            try {
                while (!this.shouldStop) {
                    OutputEvent event = this.eventQueue.poll();
                    if (event == null) {
                        Thread.sleep(10L);
                        continue;
                    }
                    this.dispatchAsync(event);
                }
            }
            catch (InterruptedException ex) {
                this.shouldStop = true;
            }
            this.sendRemainingEvents();
            this.completionLock.countDown();
        }

        private void sendRemainingEvents() {
            OutputEvent event;
            while ((event = this.eventQueue.poll()) != null) {
                this.dispatchAsync(event);
            }
        }

        private void dispatchAsync(OutputEvent event) {
            if (this.unableToSend) {
                return;
            }
            try {
                this.connection.logEvent(event);
            }
            catch (Exception ex) {
                this.shouldStop = true;
                this.unableToSend = true;
            }
        }

        public void waitForCompletion() {
            LogToClient.this.loggingOutput.removeOutputEventListener(this.listener);
            this.shouldStop = true;
            try {
                this.completionLock.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

