/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testing.jacoco.plugins;

import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.ExtensiblePolymorphicDomainObjectContainer;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.TestSuiteType;
import org.gradle.api.attributes.VerificationType;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRolesForMigration;
import org.gradle.api.internal.artifacts.configurations.RoleBasedConfigurationContainerInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.jvm.JvmTestSuite;
import org.gradle.api.plugins.jvm.internal.JvmEcosystemUtilities;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.internal.jacoco.DefaultJacocoCoverageReport;
import org.gradle.testing.base.TestSuite;
import org.gradle.testing.base.TestingExtension;
import org.gradle.testing.jacoco.plugins.JacocoCoverageReport;
import org.gradle.testing.jacoco.tasks.JacocoReport;

@Incubating
public abstract class JacocoReportAggregationPlugin
implements Plugin<Project> {
    public static final String JACOCO_AGGREGATION_CONFIGURATION_NAME = "jacocoAggregation";

    @Inject
    protected abstract JvmEcosystemUtilities getEcosystemUtilities();

    @Override
    public void apply(Project project) {
        project.getPluginManager().apply("org.gradle.reporting-base");
        project.getPluginManager().apply("jvm-ecosystem");
        project.getPluginManager().apply("jacoco");
        RoleBasedConfigurationContainerInternal configurations = ((ProjectInternal)project).getConfigurations();
        Configuration jacocoAggregation = configurations.bucket(JACOCO_AGGREGATION_CONFIGURATION_NAME);
        jacocoAggregation.setDescription("Collects project dependencies for purposes of JaCoCo coverage report aggregation");
        jacocoAggregation.setVisible(false);
        jacocoAggregation.setTransitive(true);
        ObjectFactory objects = project.getObjects();
        Configuration codeCoverageResultsConf = configurations.createWithRole("aggregateCodeCoverageReportResults", ConfigurationRolesForMigration.RESOLVABLE_BUCKET_TO_RESOLVABLE);
        codeCoverageResultsConf.setDescription("Graph needed for the aggregated JaCoCo coverage report.");
        codeCoverageResultsConf.extendsFrom(jacocoAggregation);
        codeCoverageResultsConf.setVisible(false);
        jacocoAggregation.setTransitive(true);
        ArtifactView sourceDirectories = codeCoverageResultsConf.getIncoming().artifactView(view -> {
            view.withVariantReselection();
            view.componentFilter(id -> id instanceof ProjectComponentIdentifier);
            view.attributes(attributes -> {
                attributes.attribute(Bundling.BUNDLING_ATTRIBUTE, objects.named(Bundling.class, "external"));
                attributes.attribute(Category.CATEGORY_ATTRIBUTE, objects.named(Category.class, "verification"));
                attributes.attribute(VerificationType.VERIFICATION_TYPE_ATTRIBUTE, objects.named(VerificationType.class, "main-sources"));
            });
        });
        ArtifactView classDirectories = codeCoverageResultsConf.getIncoming().artifactView(view -> {
            view.withVariantReselection();
            view.componentFilter(id -> id instanceof ProjectComponentIdentifier);
            view.attributes(attributes -> attributes.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, objects.named(LibraryElements.class, "classes")));
        });
        ReportingExtension reporting = project.getExtensions().getByType(ReportingExtension.class);
        reporting.getReports().registerBinding(JacocoCoverageReport.class, DefaultJacocoCoverageReport.class);
        reporting.getReports().withType(JacocoCoverageReport.class).all(report2 -> report2.getReportTask().configure(task -> {
            Callable<FileCollection> executionData = () -> codeCoverageResultsConf.getIncoming().artifactView(view -> {
                view.withVariantReselection();
                view.componentFilter(id -> id instanceof ProjectComponentIdentifier);
                view.attributes(attributes -> {
                    attributes.attribute(Category.CATEGORY_ATTRIBUTE, objects.named(Category.class, "verification"));
                    attributes.attributeProvider(TestSuiteType.TEST_SUITE_TYPE_ATTRIBUTE, report2.getTestType().map(tt -> objects.named(TestSuiteType.class, (String)tt)));
                    attributes.attribute(VerificationType.VERIFICATION_TYPE_ATTRIBUTE, objects.named(VerificationType.class, "jacoco-coverage"));
                    attributes.attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, "binary");
                });
            }).getFiles();
            this.configureReportTaskInputs((JacocoReport)task, classDirectories, sourceDirectories, executionData);
        }));
        project.getPlugins().withType(JavaBasePlugin.class, plugin -> this.getEcosystemUtilities().configureAsRuntimeClasspath(codeCoverageResultsConf));
        project.getPlugins().withId("jvm-test-suite", plugin -> {
            jacocoAggregation.getDependencies().add(project.getDependencyFactory().create(project));
            TestingExtension testing = project.getExtensions().getByType(TestingExtension.class);
            ExtensiblePolymorphicDomainObjectContainer<TestSuite> testSuites = testing.getSuites();
            testSuites.withType(JvmTestSuite.class).all(testSuite -> reporting.getReports().create(testSuite.getName() + "CodeCoverageReport", JacocoCoverageReport.class, report2 -> report2.getTestType().convention(testSuite.getTestType())));
        });
    }

    private void configureReportTaskInputs(JacocoReport task, ArtifactView classDirectories, ArtifactView sourceDirectories, Callable<FileCollection> executionData) {
        task.getExecutionData().from(executionData);
        task.getClassDirectories().from(classDirectories.getFiles());
        task.getSourceDirectories().from(sourceDirectories.getFiles());
    }
}

