/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.converters.MavenConsumerPomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomParent;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J<\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u000f0\rH\u0007J,\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u000f0\rH\u0007J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/idea/maven/dom/converters/MavenConsumerPomUtil;", "", "()V", "getAutomaticParentVersion", "", "context", "Lcom/intellij/util/xml/ConvertContext;", "getDerivedParentPropertyForConsumerPom", "currentPomFile", "Lcom/intellij/psi/xml/XmlFile;", "parentElementArtifactId", "parentElementGroupId", "extractor", "Lkotlin/Function1;", "Lorg/jetbrains/idea/maven/dom/model/MavenDomProjectModel;", "Lcom/intellij/util/xml/GenericDomValue;", "getDerivedPropertiesForConsumerPom", "getMavenParentElementFromContext", "Lorg/jetbrains/idea/maven/dom/model/MavenDomParent;", "isAutomaticVersionFeatureEnabled", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.maven"})
public final class MavenConsumerPomUtil {
    @NotNull
    public static final MavenConsumerPomUtil INSTANCE = new MavenConsumerPomUtil();

    private MavenConsumerPomUtil() {
    }

    @JvmStatic
    public static final boolean isAutomaticVersionFeatureEnabled(@NotNull VirtualFile file, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return StringUtil.compareVersionNumbers((String)MavenDomUtil.getMavenVersion(file, project2), (String)"4") >= 0;
    }

    @JvmStatic
    public static final boolean isAutomaticVersionFeatureEnabled(@NotNull ConvertContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        VirtualFile virtualFile = context2.getFile().getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"context.file.virtualFile");
        Project project2 = context2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"context.project");
        return MavenConsumerPomUtil.isAutomaticVersionFeatureEnabled(virtualFile, project2);
    }

    @JvmStatic
    @Nullable
    public static final String getAutomaticParentVersion(@NotNull ConvertContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return MavenConsumerPomUtil.getDerivedPropertiesForConsumerPom(context2, (Function1<? super MavenDomProjectModel, ? extends GenericDomValue<String>>)((Function1)getAutomaticParentVersion.1.INSTANCE));
    }

    @JvmStatic
    @Nullable
    public static final String getDerivedPropertiesForConsumerPom(@NotNull ConvertContext context2, @NotNull Function1<? super MavenDomProjectModel, ? extends GenericDomValue<String>> extractor) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(extractor, (String)"extractor");
        MavenDomParent mavenDomParent = INSTANCE.getMavenParentElementFromContext(context2);
        if (mavenDomParent == null) {
            return null;
        }
        MavenDomParent parentElement = mavenDomParent;
        String artifactId = (String)parentElement.getArtifactId().getValue();
        String groupId = (String)parentElement.getGroupId().getValue();
        if (artifactId == null || groupId == null) {
            return null;
        }
        XmlFile xmlFile = context2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)xmlFile, (String)"context.file");
        return MavenConsumerPomUtil.getDerivedParentPropertyForConsumerPom(xmlFile, artifactId, groupId, extractor);
    }

    @JvmStatic
    @Nullable
    public static final String getDerivedParentPropertyForConsumerPom(@NotNull XmlFile currentPomFile, @NotNull String parentElementArtifactId, @NotNull String parentElementGroupId, @NotNull Function1<? super MavenDomProjectModel, ? extends GenericDomValue<String>> extractor) {
        String parentRealGroupId;
        Intrinsics.checkNotNullParameter((Object)currentPomFile, (String)"currentPomFile");
        Intrinsics.checkNotNullParameter((Object)parentElementArtifactId, (String)"parentElementArtifactId");
        Intrinsics.checkNotNullParameter((Object)parentElementGroupId, (String)"parentElementGroupId");
        Intrinsics.checkNotNullParameter(extractor, (String)"extractor");
        PsiDirectory psiDirectory = currentPomFile.getParent();
        PsiFile psiFile = psiDirectory != null && (psiDirectory = psiDirectory.getParent()) != null ? psiDirectory.findFile("pom.xml") : null;
        XmlFile xmlFile = psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
        if (xmlFile == null) {
            return null;
        }
        XmlFile parentPsi = xmlFile;
        MavenDomProjectModel mavenDomProjectModel = MavenDomUtil.getMavenDomModel((PsiFile)parentPsi, MavenDomProjectModel.class);
        if (mavenDomProjectModel == null) {
            return null;
        }
        MavenDomProjectModel mavenParentDomPsiModel = mavenDomProjectModel;
        String string = (String)mavenParentDomPsiModel.getGroupId().getValue();
        if (string == null) {
            string = parentRealGroupId = (String)mavenParentDomPsiModel.getMavenParent().getGroupId().getValue();
        }
        if (Intrinsics.areEqual((Object)mavenParentDomPsiModel.getArtifactId().getValue(), (Object)parentElementArtifactId) && Intrinsics.areEqual((Object)parentRealGroupId, (Object)parentElementGroupId)) {
            return (String)((GenericDomValue)extractor.invoke((Object)mavenParentDomPsiModel)).getValue();
        }
        return null;
    }

    private final MavenDomParent getMavenParentElementFromContext(ConvertContext context2) {
        MavenDomParent mavenDomParent;
        DomElement domElement = context2.getInvocationElement().getParent();
        MavenDomParent mavenDomParent2 = mavenDomParent = domElement instanceof MavenDomParent ? (MavenDomParent)domElement : null;
        if (mavenDomParent != null) {
            return mavenDomParent;
        }
        DomElement domElement2 = context2.getInvocationElement().getParent();
        MavenDomProjectModel mavenDomProjectModel = domElement2 instanceof MavenDomProjectModel ? (MavenDomProjectModel)domElement2 : null;
        return mavenDomProjectModel != null ? mavenDomProjectModel.getMavenParent() : null;
    }
}

