/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters.repositories;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.paths.WebReference;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import icons.MavenIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.converters.MavenUrlConverter;
import org.jetbrains.idea.maven.dom.converters.repositories.MavenRepositoriesProvider;
import org.jetbrains.idea.maven.dom.model.MavenDomRepositoryBase;

public abstract class MavenRepositoryConverter
extends ResolvingConverter<String> {
    @Nullable
    private static String getRepositoryId(ConvertContext context2) {
        MavenDomRepositoryBase repository = (MavenDomRepositoryBase)context2.getInvocationElement().getParentOfType(MavenDomRepositoryBase.class, false);
        if (repository != null) {
            return repository.getId().getStringValue();
        }
        return null;
    }

    public String fromString(@Nullable @NonNls String s, ConvertContext context2) {
        return s;
    }

    public String toString(@Nullable String s, ConvertContext convertContext) {
        return s;
    }

    public static class Url
    extends MavenUrlConverter {
        @Override
        public PsiReference @NotNull [] createReferences(GenericDomValue value, PsiElement element, final ConvertContext context2) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new WebReference(element){

                public Object @NotNull [] getVariants() {
                    String name;
                    Module module2 = context2.getModule();
                    if (module2 != null && !StringUtil.isEmptyOrSpaces((String)(name = MavenRepositoriesProvider.getInstance().getRepositoryUrl(MavenRepositoryConverter.getRepositoryId(context2))))) {
                        Object[] objectArray = new Object[]{name};
                        if (objectArray == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return objectArray;
                    }
                    Object[] objectArray = super.getVariants();
                    if (objectArray == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return objectArray;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/converters/repositories/MavenRepositoryConverter$Url$1", "getVariants"));
                }
            }};
            if (psiReferenceArray == null) {
                Url.$$$reportNull$$$0(0);
            }
            return psiReferenceArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/converters/repositories/MavenRepositoryConverter$Url", "createReferences"));
        }
    }

    public static class Name
    extends MavenRepositoryConverter {
        @NotNull
        public Collection<String> getVariants(ConvertContext context2) {
            String name;
            Module module2 = context2.getModule();
            if (module2 != null && !StringUtil.isEmptyOrSpaces((String)(name = MavenRepositoriesProvider.getInstance().getRepositoryName(MavenRepositoryConverter.getRepositoryId(context2))))) {
                Set<String> set = Collections.singleton(name);
                if (set == null) {
                    Name.$$$reportNull$$$0(0);
                }
                return set;
            }
            Set<String> set = Collections.emptySet();
            if (set == null) {
                Name.$$$reportNull$$$0(1);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/converters/repositories/MavenRepositoryConverter$Name", "getVariants"));
        }
    }

    public static class Id
    extends MavenRepositoryConverter {
        @NotNull
        public Collection<String> getVariants(ConvertContext context2) {
            Module module2 = context2.getModule();
            if (module2 != null) {
                Set<String> set = MavenRepositoriesProvider.getInstance().getRepositoryIds();
                if (set == null) {
                    Id.$$$reportNull$$$0(0);
                }
                return set;
            }
            Set<String> set = Collections.emptySet();
            if (set == null) {
                Id.$$$reportNull$$$0(1);
            }
            return set;
        }

        public LookupElement createLookupElement(String s) {
            return LookupElementBuilder.create((String)s).withIcon(MavenIcons.MavenPlugin).withTailText(" (" + MavenRepositoriesProvider.getInstance().getRepositoryUrl(s) + ")", true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/converters/repositories/MavenRepositoryConverter$Id", "getVariants"));
        }
    }
}

