/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.openapi.externalSystem.model.project.ProjectId;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenImportUtil;
import org.jetbrains.idea.maven.importing.MavenImporter;
import org.jetbrains.idea.maven.importing.MavenLegacyFoldersImporter;
import org.jetbrains.idea.maven.importing.MavenPomPathModuleService;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapterLegacyImpl;
import org.jetbrains.idea.maven.importing.StandardMavenModuleType;
import org.jetbrains.idea.maven.importing.tree.MavenTreeModuleImportData;
import org.jetbrains.idea.maven.importing.tree.dependency.BaseDependency;
import org.jetbrains.idea.maven.importing.tree.dependency.LibraryDependency;
import org.jetbrains.idea.maven.importing.tree.dependency.MavenImportDependency;
import org.jetbrains.idea.maven.importing.tree.dependency.ModuleDependency;
import org.jetbrains.idea.maven.importing.tree.dependency.SystemDependency;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.SupportedRequestType;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

public final class MavenLegacyModuleImporter {
    public static final String SUREFIRE_PLUGIN_LIBRARY_NAME = "maven-surefire-plugin urls";
    public static final Set<String> IMPORTED_CLASSIFIERS = Set.of("client");
    private static final Map<String, LanguageLevel> MAVEN_IDEA_PLUGIN_LEVELS = ImmutableMap.of((Object)"JDK_1_3", (Object)LanguageLevel.JDK_1_3, (Object)"JDK_1_4", (Object)LanguageLevel.JDK_1_4, (Object)"JDK_1_5", (Object)LanguageLevel.JDK_1_5, (Object)"JDK_1_6", (Object)LanguageLevel.JDK_1_6, (Object)"JDK_1_7", (Object)LanguageLevel.JDK_1_7);
    private final Module myModule;
    private final MavenProjectsTree myMavenTree;
    private final MavenProject myMavenProject;
    private final Map<MavenProject, String> myMavenProjectToModuleName;
    private final MavenImportingSettings mySettings;
    private final IdeModifiableModelsProvider myModifiableModelsProvider;
    @Nullable
    private MavenRootModelAdapter myRootModelAdapter;

    public MavenLegacyModuleImporter(Module module2, MavenProjectsTree mavenTree, MavenProject mavenProject2, Map<MavenProject, String> mavenProjectToModuleName, MavenImportingSettings settings, IdeModifiableModelsProvider modifiableModelsProvider) {
        this.myModule = module2;
        this.myMavenTree = mavenTree;
        this.myMavenProject = mavenProject2;
        this.myMavenProjectToModuleName = mavenProjectToModuleName;
        this.mySettings = settings;
        this.myModifiableModelsProvider = modifiableModelsProvider;
        VirtualFile pomFile = mavenProject2.getFile();
        if (!FileUtil.namesEqual((String)"pom", (String)pomFile.getNameWithoutExtension())) {
            MavenPomPathModuleService.getInstance(module2).setPomFileUrl(pomFile.getUrl());
        }
    }

    public void config(MavenRootModelAdapter mavenRootModelAdapter) {
        this.myRootModelAdapter = mavenRootModelAdapter;
        this.configFolders();
        this.configDependencies();
        this.configLanguageLevel();
    }

    public void config(MavenRootModelAdapter mavenRootModelAdapter, MavenTreeModuleImportData importData) {
        this.myRootModelAdapter = mavenRootModelAdapter;
        this.configFolders();
        this.configDependencies(importData.getDependencies());
        LanguageLevel level = MavenImportUtil.getLanguageLevel(this.myMavenProject, () -> importData.getModuleData().getSourceLanguageLevel());
        this.configLanguageLevel(level);
    }

    private void configFolders() {
        new MavenLegacyFoldersImporter(this.myMavenProject, this.mySettings, this.myRootModelAdapter).config();
    }

    private void configDependencies() {
        HashSet dependencyTypesFromSettings = new HashSet();
        if (!((Boolean)ReadAction.compute(() -> {
            if (this.myModule.getProject().isDisposed()) {
                return false;
            }
            dependencyTypesFromSettings.addAll(MavenProjectsManager.getInstance(this.myModule.getProject()).getImportingSettings().getDependencyTypesAsSet());
            return true;
        })).booleanValue()) {
            return;
        }
        for (MavenArtifact artifact : this.myMavenProject.getDependencies()) {
            String dependencyType = artifact.getType();
            if (!dependencyTypesFromSettings.contains(dependencyType) && !this.myMavenProject.getDependencyTypesFromImporters(SupportedRequestType.FOR_IMPORT).contains(dependencyType)) continue;
            DependencyScope scope = MavenLegacyModuleImporter.selectScope(artifact.getScope());
            MavenProject depProject = this.myMavenTree.findProject(artifact.getMavenId());
            if (depProject != null) {
                String classifier;
                if (depProject == this.myMavenProject) continue;
                String moduleName = this.myMavenProjectToModuleName.get(depProject);
                if (moduleName == null || this.myMavenTree.isIgnored(depProject)) {
                    MavenArtifact projectsArtifactInRepository = MavenLegacyModuleImporter.createCopyForLocalRepo(artifact, this.myMavenProject);
                    this.myRootModelAdapter.addLibraryDependency(projectsArtifactInRepository, scope, this.myModifiableModelsProvider, this.myMavenProject);
                    continue;
                }
                boolean isTestJar = "test-jar".equals(dependencyType) || "tests".equals(artifact.getClassifier());
                this.myRootModelAdapter.addModuleDependency(moduleName, scope, isTestJar);
                Element buildHelperCfg = depProject.getPluginGoalConfiguration("org.codehaus.mojo", "build-helper-maven-plugin", "attach-artifact");
                if (buildHelperCfg != null) {
                    this.addAttachArtifactDependency(buildHelperCfg, scope, depProject, artifact);
                }
                if ((classifier = artifact.getClassifier()) == null || !IMPORTED_CLASSIFIERS.contains(classifier) || isTestJar || "system".equals(artifact.getScope()) || "false".equals(System.getProperty("idea.maven.classifier.dep"))) continue;
                MavenArtifact a = MavenLegacyModuleImporter.createCopyForLocalRepo(artifact, this.myMavenProject);
                this.myRootModelAdapter.addLibraryDependency(a, scope, this.myModifiableModelsProvider, this.myMavenProject);
                continue;
            }
            if ("system".equals(artifact.getScope())) {
                this.myRootModelAdapter.addSystemDependency(artifact, scope);
                continue;
            }
            if ("bundle".equals(dependencyType)) {
                artifact = new MavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getBaseVersion(), "jar", artifact.getClassifier(), artifact.getScope(), artifact.isOptional(), "jar", null, this.myMavenProject.getLocalRepository(), false, false);
            }
            LibraryOrderEntry libraryOrderEntry = this.myRootModelAdapter.addLibraryDependency(artifact, scope, this.myModifiableModelsProvider, this.myMavenProject);
            this.myModifiableModelsProvider.trySubstitute(this.myModule, libraryOrderEntry, (ProjectCoordinate)new ProjectId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()));
        }
        this.configSurefirePlugin();
    }

    public void configDependencies(@NotNull List<MavenImportDependency<?>> dependencies) {
        if (dependencies == null) {
            MavenLegacyModuleImporter.$$$reportNull$$$0(0);
        }
        for (MavenImportDependency<?> dependency : dependencies) {
            if (dependency instanceof SystemDependency) {
                this.myRootModelAdapter.addSystemDependency((MavenArtifact)((SystemDependency)dependency).getArtifact(), dependency.getScope());
                continue;
            }
            if (dependency instanceof LibraryDependency) {
                this.myRootModelAdapter.addLibraryDependency((MavenArtifact)((LibraryDependency)dependency).getArtifact(), dependency.getScope(), this.myModifiableModelsProvider, this.myMavenProject);
                continue;
            }
            if (dependency instanceof ModuleDependency) {
                ModuleDependency moduleDependency = (ModuleDependency)dependency;
                this.myRootModelAdapter.addModuleDependency((String)moduleDependency.getArtifact(), dependency.getScope(), moduleDependency.isTestJar());
                continue;
            }
            if (!(dependency instanceof BaseDependency)) continue;
            MavenArtifact artifact = (MavenArtifact)((BaseDependency)dependency).getArtifact();
            LibraryOrderEntry libraryOrderEntry = this.myRootModelAdapter.addLibraryDependency(artifact, dependency.getScope(), this.myModifiableModelsProvider, this.myMavenProject);
            this.myModifiableModelsProvider.trySubstitute(this.myModule, libraryOrderEntry, (ProjectCoordinate)new ProjectId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()));
        }
    }

    @NotNull
    public static MavenArtifact createCopyForLocalRepo(@NotNull MavenArtifact artifact, @NotNull MavenProject project2) {
        if (artifact == null) {
            MavenLegacyModuleImporter.$$$reportNull$$$0(1);
        }
        if (project2 == null) {
            MavenLegacyModuleImporter.$$$reportNull$$$0(2);
        }
        return new MavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getBaseVersion(), artifact.getType(), artifact.getClassifier(), artifact.getScope(), artifact.isOptional(), artifact.getExtension(), null, project2.getLocalRepository(), false, false);
    }

    private void configSurefirePlugin() {
        LibraryTable moduleLibraryTable = this.myRootModelAdapter.getRootModel().getModuleLibraryTable();
        Library library = moduleLibraryTable.getLibraryByName(SUREFIRE_PLUGIN_LIBRARY_NAME);
        if (library != null) {
            moduleLibraryTable.removeLibrary(library);
        }
    }

    private void addAttachArtifactDependency(@NotNull Element buildHelperCfg, @NotNull DependencyScope scope, @NotNull MavenProject mavenProject2, @NotNull MavenArtifact artifact) {
        if (buildHelperCfg == null) {
            MavenLegacyModuleImporter.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            MavenLegacyModuleImporter.$$$reportNull$$$0(4);
        }
        if (mavenProject2 == null) {
            MavenLegacyModuleImporter.$$$reportNull$$$0(5);
        }
        if (artifact == null) {
            MavenLegacyModuleImporter.$$$reportNull$$$0(6);
        }
        Library.ModifiableModel libraryModel = null;
        for (Element artifactsElement : buildHelperCfg.getChildren("artifacts")) {
            for (Element artifactElement : artifactsElement.getChildren("artifact")) {
                VirtualFile file;
                String filePath;
                String typeString = artifactElement.getChildTextTrim("type");
                if (typeString != null && !typeString.equals("jar")) continue;
                OrderRootType rootType = OrderRootType.CLASSES;
                String classifier = artifactElement.getChildTextTrim("classifier");
                if ("sources".equals(classifier)) {
                    rootType = OrderRootType.SOURCES;
                } else if ("javadoc".equals(classifier)) {
                    rootType = JavadocOrderRootType.getInstance();
                }
                if (StringUtil.isEmpty((String)(filePath = artifactElement.getChildTextTrim("file"))) || (file = VfsUtil.findRelativeFile((String)filePath, (VirtualFile)mavenProject2.getDirectoryFile())) == null || (file = JarFileSystem.getInstance().getJarRootForLocalFile(file)) == null) continue;
                if (libraryModel == null) {
                    String libraryName = MavenLegacyModuleImporter.getAttachedJarsLibName(artifact);
                    Library library = this.myModifiableModelsProvider.getLibraryByName(libraryName);
                    if (library == null) {
                        library = this.myModifiableModelsProvider.createLibrary(libraryName, MavenRootModelAdapter.getMavenExternalSource());
                    }
                    libraryModel = this.myModifiableModelsProvider.getModifiableLibraryModel(library);
                    LibraryOrderEntry entry = this.myRootModelAdapter.getRootModel().addLibraryEntry(library);
                    entry.setScope(scope);
                }
                if (libraryModel == null) continue;
                libraryModel.addRoot(file, rootType);
            }
        }
    }

    @NotNull
    public static String getAttachedJarsLibName(@NotNull MavenArtifact artifact) {
        if (artifact == null) {
            MavenLegacyModuleImporter.$$$reportNull$$$0(7);
        }
        Object libraryName = artifact.getLibraryName();
        assert (((String)libraryName).startsWith("Maven: "));
        Object object = libraryName = "Maven: ATTACHED-JAR: " + ((String)libraryName).substring("Maven: ".length());
        if (object == null) {
            MavenLegacyModuleImporter.$$$reportNull$$$0(8);
        }
        return object;
    }

    @NotNull
    public static DependencyScope selectScope(String mavenScope) {
        if ("runtime".equals(mavenScope)) {
            DependencyScope dependencyScope = DependencyScope.RUNTIME;
            if (dependencyScope == null) {
                MavenLegacyModuleImporter.$$$reportNull$$$0(9);
            }
            return dependencyScope;
        }
        if ("test".equals(mavenScope)) {
            DependencyScope dependencyScope = DependencyScope.TEST;
            if (dependencyScope == null) {
                MavenLegacyModuleImporter.$$$reportNull$$$0(10);
            }
            return dependencyScope;
        }
        if ("provided".equals(mavenScope)) {
            DependencyScope dependencyScope = DependencyScope.PROVIDED;
            if (dependencyScope == null) {
                MavenLegacyModuleImporter.$$$reportNull$$$0(11);
            }
            return dependencyScope;
        }
        DependencyScope dependencyScope = DependencyScope.COMPILE;
        if (dependencyScope == null) {
            MavenLegacyModuleImporter.$$$reportNull$$$0(12);
        }
        return dependencyScope;
    }

    private void configLanguageLevel() {
        if ("false".equalsIgnoreCase(System.getProperty("idea.maven.configure.language.level"))) {
            return;
        }
        LanguageLevel level = MavenLegacyModuleImporter.getLanguageLevel(this.myMavenProject);
        this.myRootModelAdapter.setLanguageLevel(level);
    }

    private void configLanguageLevel(@NotNull LanguageLevel level) {
        if (level == null) {
            MavenLegacyModuleImporter.$$$reportNull$$$0(13);
        }
        if ("false".equalsIgnoreCase(System.getProperty("idea.maven.configure.language.level"))) {
            return;
        }
        this.myRootModelAdapter.setLanguageLevel(level);
    }

    @Deprecated
    @NotNull
    public static LanguageLevel getLanguageLevel(MavenProject mavenProject2) {
        LanguageLevel languageLevel = MavenImportUtil.getSourceLanguageLevel(mavenProject2);
        if (languageLevel == null) {
            MavenLegacyModuleImporter.$$$reportNull$$$0(14);
        }
        return languageLevel;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static LanguageLevel getDefaultLevel(MavenProject mavenProject2) {
        LanguageLevel languageLevel = MavenImportUtil.getDefaultLevel(mavenProject2);
        if (languageLevel == null) {
            MavenLegacyModuleImporter.$$$reportNull$$$0(15);
        }
        return languageLevel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 11, 12, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildHelperCfg";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/importing/MavenLegacyModuleImporter";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/importing/MavenLegacyModuleImporter";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttachedJarsLibName";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "selectScope";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "configDependencies";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createCopyForLocalRepo";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addAttachArtifactDependency";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAttachedJarsLibName";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "configLanguageLevel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 11, 12, 14, 15 -> new IllegalStateException(string);
        };
    }

    public static class ExtensionImporter {
        private final Module myModule;
        private final MavenProjectsTree myMavenProjectsTree;
        private final MavenProject myMavenProject;
        private final MavenProjectChanges myMavenProjectChanges;
        private final Map<MavenProject, String> myMavenProjectToModuleName;
        @NotNull
        private final List<MavenImporter> myImporters;
        private MavenRootModelAdapter myRootModelAdapter;
        private IdeModifiableModelsProvider myModifiableModelsProvider;

        @Nullable
        public static ExtensionImporter createIfApplicable(@NotNull MavenProject mavenProject2, @NotNull Module module2, @NotNull StandardMavenModuleType moduleType, @NotNull MavenProjectsTree mavenTree, @NotNull MavenProjectChanges changes, @NotNull Map<MavenProject, String> mavenProjectToModuleName, boolean isWorkspaceImport) {
            if (mavenProject2 == null) {
                ExtensionImporter.$$$reportNull$$$0(0);
            }
            if (module2 == null) {
                ExtensionImporter.$$$reportNull$$$0(1);
            }
            if (moduleType == null) {
                ExtensionImporter.$$$reportNull$$$0(2);
            }
            if (mavenTree == null) {
                ExtensionImporter.$$$reportNull$$$0(3);
            }
            if (changes == null) {
                ExtensionImporter.$$$reportNull$$$0(4);
            }
            if (mavenProjectToModuleName == null) {
                ExtensionImporter.$$$reportNull$$$0(5);
            }
            if (moduleType == StandardMavenModuleType.COMPOUND_MODULE) {
                return null;
            }
            List suitableImporters = MavenImporter.getSuitableImporters(mavenProject2, isWorkspaceImport);
            if (!isWorkspaceImport && !changes.hasChanges()) {
                suitableImporters = ContainerUtil.filter(suitableImporters, it -> !it.processChangedModulesOnly());
            }
            if (suitableImporters.isEmpty()) {
                return null;
            }
            return new ExtensionImporter(module2, mavenTree, mavenProject2, changes, mavenProjectToModuleName, suitableImporters);
        }

        private ExtensionImporter(@NotNull Module module2, @NotNull MavenProjectsTree mavenTree, @NotNull MavenProject mavenProject2, @NotNull MavenProjectChanges changes, @NotNull Map<MavenProject, String> mavenProjectToModuleName, @NotNull List<MavenImporter> importers) {
            if (module2 == null) {
                ExtensionImporter.$$$reportNull$$$0(6);
            }
            if (mavenTree == null) {
                ExtensionImporter.$$$reportNull$$$0(7);
            }
            if (mavenProject2 == null) {
                ExtensionImporter.$$$reportNull$$$0(8);
            }
            if (changes == null) {
                ExtensionImporter.$$$reportNull$$$0(9);
            }
            if (mavenProjectToModuleName == null) {
                ExtensionImporter.$$$reportNull$$$0(10);
            }
            if (importers == null) {
                ExtensionImporter.$$$reportNull$$$0(11);
            }
            this.myModule = module2;
            this.myMavenProject = mavenProject2;
            this.myMavenProjectsTree = mavenTree;
            this.myMavenProjectChanges = changes;
            this.myMavenProjectToModuleName = mavenProjectToModuleName;
            this.myImporters = importers;
        }

        boolean isModuleDisposed() {
            return this.myModule.isDisposed();
        }

        void init(@NotNull IdeModifiableModelsProvider ideModelsProvider) {
            if (ideModelsProvider == null) {
                ExtensionImporter.$$$reportNull$$$0(12);
            }
            this.myModifiableModelsProvider = ideModelsProvider;
            this.myRootModelAdapter = new MavenRootModelAdapter(new MavenRootModelAdapterLegacyImpl(this.myMavenProject, this.myModule, this.myModifiableModelsProvider));
        }

        private void doConfigurationStep(Runnable step) {
            if (Registry.is((String)"maven.import.to.workspace.model.fast.facet.creation")) {
                step.run();
            } else {
                MavenUtil.invokeAndWaitWriteAction(this.myModule.getProject(), step);
            }
        }

        void preConfig(Map<Class<? extends MavenImporter>, CountAndTime> counters) {
            this.doConfigurationStep(() -> this.doPreConfig(counters));
        }

        private void doPreConfig(Map<Class<? extends MavenImporter>, CountAndTime> counters) {
            if (this.myModule.isDisposed()) {
                return;
            }
            ModuleType moduleType = ModuleType.get((Module)this.myModule);
            for (MavenImporter importer : this.myImporters) {
                try {
                    if (importer.getModuleType() != moduleType) continue;
                    ExtensionImporter.measureImporterTime(importer, counters, true, () -> importer.preProcess(this.myModule, this.myMavenProject, this.myMavenProjectChanges, this.myModifiableModelsProvider));
                }
                catch (Exception e) {
                    MavenLog.LOG.error("Exception in MavenImporter.preConfig, skipping it.", (Throwable)e);
                }
            }
        }

        void config(List<MavenProjectsProcessorTask> postTasks, Map<Class<? extends MavenImporter>, CountAndTime> counters) {
            this.doConfigurationStep(() -> this.doConfig(postTasks, counters));
        }

        private void doConfig(List<MavenProjectsProcessorTask> postTasks, Map<Class<? extends MavenImporter>, CountAndTime> counters) {
            if (this.myModule.isDisposed()) {
                return;
            }
            ModuleType moduleType = ModuleType.get((Module)this.myModule);
            for (MavenImporter importer : this.myImporters) {
                if (importer.getModuleType() != moduleType) continue;
                try {
                    ExtensionImporter.measureImporterTime(importer, counters, false, () -> importer.process(this.myModifiableModelsProvider, this.myModule, this.myRootModelAdapter, this.myMavenProjectsTree, this.myMavenProject, this.myMavenProjectChanges, this.myMavenProjectToModuleName, postTasks));
                }
                catch (Exception e) {
                    MavenLog.LOG.error("Exception in MavenImporter.config, skipping it.", (Throwable)e);
                }
            }
        }

        void postConfig(Map<Class<? extends MavenImporter>, CountAndTime> counters) {
            this.doConfigurationStep(() -> this.doPostConfig(counters));
        }

        private void doPostConfig(Map<Class<? extends MavenImporter>, CountAndTime> counters) {
            if (this.myModule.isDisposed()) {
                return;
            }
            ModuleType moduleType = ModuleType.get((Module)this.myModule);
            for (MavenImporter importer : this.myImporters) {
                try {
                    if (importer.getModuleType() != moduleType) continue;
                    ExtensionImporter.measureImporterTime(importer, counters, false, () -> importer.postProcess(this.myModule, this.myMavenProject, this.myMavenProjectChanges, this.myModifiableModelsProvider));
                }
                catch (Exception e) {
                    MavenLog.LOG.error("Exception in MavenImporter.postConfig, skipping it.", (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void measureImporterTime(MavenImporter importer, Map<Class<? extends MavenImporter>, CountAndTime> counters, boolean increaseModuleCounter, Runnable r) {
            long before;
            block3: {
                before = System.nanoTime();
                try {
                    r.run();
                    CountAndTime countAndTime = counters.computeIfAbsent(importer.getClass(), __ -> new CountAndTime());
                    if (!increaseModuleCounter) break block3;
                    ++countAndTime.count;
                }
                catch (Throwable throwable) {
                    CountAndTime countAndTime = counters.computeIfAbsent(importer.getClass(), __ -> new CountAndTime());
                    if (increaseModuleCounter) {
                        ++countAndTime.count;
                    }
                    countAndTime.timeNano += System.nanoTime() - before;
                    throw throwable;
                }
            }
            countAndTime.timeNano += System.nanoTime() - before;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mavenProject";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleType";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mavenTree";
                    break;
                }
                case 4: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 5: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mavenProjectToModuleName";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importers";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ideModelsProvider";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/maven/importing/MavenLegacyModuleImporter$ExtensionImporter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createIfApplicable";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "init";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        static class CountAndTime {
            int count = 0;
            long timeNano = 0L;

            CountAndTime() {
            }
        }
    }
}

