/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.performancePlugin;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectTrackerSettings;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.util.DisposeAwareRunnable;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.idea.maven.buildtool.MavenImportSpec;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.importing.FilesList;
import org.jetbrains.idea.maven.project.importing.MavenImportingManager;
import org.jetbrains.idea.maven.utils.MavenUtil;

public final class ImportMavenProjectCommand
extends AbstractCommand {
    public static final String PREFIX = "%importMavenProject";

    public ImportMavenProjectCommand(@NotNull String text, int line) {
        if (text == null) {
            ImportMavenProjectCommand.$$$reportNull$$$0(0);
        }
        super(text, line);
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context2) {
        if (context2 == null) {
            ImportMavenProjectCommand.$$$reportNull$$$0(1);
        }
        @NotNull Project project2 = context2.getProject();
        if (MavenUtil.isLinearImportEnabled()) {
            Promise<Object> promise2 = this.runLinearMavenImport(context2, project2);
            if (promise2 == null) {
                ImportMavenProjectCommand.$$$reportNull$$$0(2);
            }
            return promise2;
        }
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        this.runWhenMavenImportAndIndexingFinished(context2, () -> ImportMavenProjectCommand.lambda$_execute$0((ActionCallback)actionCallback), project2);
        Promise promise3 = Promises.toPromise((ActionCallback)actionCallback);
        if (promise3 == null) {
            ImportMavenProjectCommand.$$$reportNull$$$0(3);
        }
        return promise3;
    }

    private Promise<Object> runLinearMavenImport(PlaybackContext context2, Project project2) {
        ExternalSystemProjectTrackerSettings projectTrackerSettings = ExternalSystemProjectTrackerSettings.getInstance((Project)project2);
        ExternalSystemProjectTrackerSettings.AutoReloadType currentAutoReloadType = projectTrackerSettings.getAutoReloadType();
        projectTrackerSettings.setAutoReloadType(ExternalSystemProjectTrackerSettings.AutoReloadType.NONE);
        context2.message("Waiting for fully open and initialized maven project", this.getLine());
        context2.message("Import of the project has been started", this.getLine());
        AsyncPromise result2 = new AsyncPromise();
        ExternalProjectsManagerImpl.getInstance((Project)project2).runWhenInitialized(() -> {
            MavenProjectsManager mavenManager = MavenProjectsManager.getInstance(project2);
            MavenImportingManager.getInstance(project2).openProjectAndImport(new FilesList(mavenManager.collectAllAvailablePomFiles())).getFinishPromise().onSuccess(t -> {
                context2.message("Import of the maven project has been finished", this.getLine());
                projectTrackerSettings.setAutoReloadType(currentAutoReloadType);
                DumbService.getInstance((Project)project2).runWhenSmart(DisposeAwareRunnable.create(() -> result2.setResult(t), (Project)project2));
            }).onError(t -> result2.setError(t));
        });
        return result2;
    }

    private void runWhenMavenImportAndIndexingFinished(@NotNull PlaybackContext context2, @NotNull Runnable runnable, @NotNull Project project2) {
        if (context2 == null) {
            ImportMavenProjectCommand.$$$reportNull$$$0(4);
        }
        if (runnable == null) {
            ImportMavenProjectCommand.$$$reportNull$$$0(5);
        }
        if (project2 == null) {
            ImportMavenProjectCommand.$$$reportNull$$$0(6);
        }
        ExternalSystemProjectTrackerSettings projectTrackerSettings = ExternalSystemProjectTrackerSettings.getInstance((Project)project2);
        ExternalSystemProjectTrackerSettings.AutoReloadType currentAutoReloadType = projectTrackerSettings.getAutoReloadType();
        projectTrackerSettings.setAutoReloadType(ExternalSystemProjectTrackerSettings.AutoReloadType.NONE);
        context2.message("Waiting for fully open and initialized maven project", this.getLine());
        ExternalProjectsManagerImpl.getInstance((Project)project2).runWhenInitialized(() -> MavenUtil.runWhenInitialized(project2, () -> ApplicationManager.getApplication().executeOnPooledThread(() -> this.waitForCurrentMavenImportActivities(context2, project2).thenAsync(promise2 -> {
            context2.message("Import of the project has been started", this.getLine());
            MavenProjectsManager mavenManager = MavenProjectsManager.getInstance(project2);
            if (!mavenManager.isMavenizedProject()) {
                mavenManager.addManagedFiles(mavenManager.collectAllAvailablePomFiles());
            }
            mavenManager.updateAllMavenProjectsSync(MavenImportSpec.EXPLICIT_IMPORT);
            return this.waitForCurrentMavenImportActivities(context2, project2);
        }).onProcessed(promise2 -> {
            context2.message("Import of the maven project has been finished", this.getLine());
            projectTrackerSettings.setAutoReloadType(currentAutoReloadType);
            DumbService.getInstance((Project)project2).runWhenSmart(DisposeAwareRunnable.create((Runnable)runnable, (Project)project2));
        }))));
    }

    private Promise<?> waitForCurrentMavenImportActivities(@NotNull PlaybackContext context2, @NotNull Project project2) {
        if (context2 == null) {
            ImportMavenProjectCommand.$$$reportNull$$$0(7);
        }
        if (project2 == null) {
            ImportMavenProjectCommand.$$$reportNull$$$0(8);
        }
        context2.message("Waiting for current maven import activities", this.getLine());
        return MavenProjectsManager.getInstance(project2).waitForImportCompletion().onProcessed(o -> context2.message("Maven import activities completed", this.getLine()));
    }

    private static /* synthetic */ void lambda$_execute$0(ActionCallback actionCallback) {
        actionCallback.setDone();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/performancePlugin/ImportMavenProjectCommand";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/performancePlugin/ImportMavenProjectCommand";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "runWhenMavenImportAndIndexingFinished";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "waitForCurrentMavenImportActivities";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

