/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectTrackerSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettings;
import org.jetbrains.idea.maven.utils.MavenWslUtil;

@State(name="MavenImportPreferences", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class MavenWorkspaceSettingsComponent
implements PersistentStateComponent<MavenWorkspaceSettings> {
    private MavenWorkspaceSettings mySettings;
    private final Project myProject;

    public MavenWorkspaceSettingsComponent(@NotNull Project project2) {
        if (project2 == null) {
            MavenWorkspaceSettingsComponent.$$$reportNull$$$0(0);
        }
        this.myProject = project2;
        this.mySettings = new MavenWorkspaceSettings();
        this.mySettings.getGeneralSettings().setProject(project2);
        this.applyDefaults(this.mySettings);
    }

    public static MavenWorkspaceSettingsComponent getInstance(@NotNull Project project2) {
        if (project2 == null) {
            MavenWorkspaceSettingsComponent.$$$reportNull$$$0(1);
        }
        return (MavenWorkspaceSettingsComponent)project2.getService(MavenWorkspaceSettingsComponent.class);
    }

    @NotNull
    public MavenWorkspaceSettings getState() {
        MavenExplicitProfiles profiles2 = MavenProjectsManager.getInstance(this.myProject).getExplicitProfiles();
        this.mySettings.setEnabledProfiles(profiles2.getEnabledProfiles());
        this.mySettings.setDisabledProfiles(profiles2.getDisabledProfiles());
        MavenWorkspaceSettings mavenWorkspaceSettings = this.mySettings;
        if (mavenWorkspaceSettings == null) {
            MavenWorkspaceSettingsComponent.$$$reportNull$$$0(2);
        }
        return mavenWorkspaceSettings;
    }

    public void loadState(@NotNull MavenWorkspaceSettings state2) {
        if (state2 == null) {
            MavenWorkspaceSettingsComponent.$$$reportNull$$$0(3);
        }
        this.mySettings = state2;
        this.applyDefaults(this.mySettings);
        this.migrateSettings(this.mySettings);
    }

    public MavenWorkspaceSettings getSettings() {
        return this.mySettings;
    }

    private void applyDefaults(MavenWorkspaceSettings settings) {
        settings.getGeneralSettings().setProject(this.myProject);
        if (StringUtil.isEmptyOrSpaces((String)settings.getGeneralSettings().getMavenHome())) {
            String home = MavenWslUtil.resolveWslAware(this.myProject, () -> "Bundled (Maven 3)", wsl -> {
                File file = MavenWslUtil.resolveMavenHomeDirectory(wsl, null);
                return file == null ? null : file.getAbsolutePath();
            });
            settings.getGeneralSettings().setMavenHome(home);
        }
    }

    private void migrateSettings(MavenWorkspaceSettings settings) {
        MavenImportingSettings importingSettings = settings.importingSettings;
        if (importingSettings.isImportAutomatically()) {
            importingSettings.setImportAutomatically(false);
            ExternalSystemProjectTrackerSettings projectTrackerSettings = ExternalSystemProjectTrackerSettings.getInstance((Project)this.myProject);
            projectTrackerSettings.setAutoReloadType(ExternalSystemProjectTrackerSettings.AutoReloadType.ALL);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/project/MavenWorkspaceSettingsComponent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/project/MavenWorkspaceSettingsComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

