/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.statistics;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemUsagesCollector;
import com.intellij.openapi.project.ExternalStorageConfigurationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Version;
import com.intellij.project.ProjectKt;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.execution.MavenExecutionOptions;
import org.jetbrains.idea.maven.execution.MavenExternalParameters;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.MavenDistributionsCache;
import org.jetbrains.idea.maven.statistics.MavenSettingsCollector;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\"\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/idea/maven/statistics/MavenSettingsCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getMavenWrapper", "Ljava/io/File;", "manager", "Lorg/jetbrains/idea/maven/project/MavenProjectsManager;", "generalSettings", "Lorg/jetbrains/idea/maven/project/MavenGeneralSettings;", "project", "Lcom/intellij/openapi/project/Project;", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "Companion", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenSettingsCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenSettingsCollector.kt\norg/jetbrains/idea/maven/statistics/MavenSettingsCollector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,167:1\n1#2:168\n*E\n"})
public final class MavenSettingsCollector
extends ProjectUsagesCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final EventLogGroup GROUP = new EventLogGroup("build.maven.state", 8, null, 4, null);
    @NotNull
    private static final EventId1<Boolean> HAS_MAVEN_PROJECT = GROUP.registerEvent("hasMavenProject", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> ALWAYS_UPDATE_SNAPSHOTS = GROUP.registerEvent("alwaysUpdateSnapshots", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> NON_RECURSIVE = GROUP.registerEvent("nonRecursive", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> PRINT_ERROR_STACK_TRACES = GROUP.registerEvent("printErrorStackTraces", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> USE_PLUGIN_REGISTRY = GROUP.registerEvent("usePluginRegistry", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> WORK_OFFLINE = GROUP.registerEvent("workOffline", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> LOCAL_REPOSITORY = GROUP.registerEvent("localRepository", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> USER_SETTINGS_FILE = GROUP.registerEvent("userSettingsFile", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> LOOK_FOR_NESTED = GROUP.registerEvent("lookForNested", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> USE_WORKSPACE_IMPORT = GROUP.registerEvent("useWorkspaceImport", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> DEDICATED_MODULE_DIR = GROUP.registerEvent("dedicatedModuleDir", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> STORE_PROJECT_FILES_EXTERNALLY = GROUP.registerEvent("storeProjectFilesExternally", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> IS_DIRECTORY_BASED_PROJECT = GROUP.registerEvent("useDirectoryBasedProject", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> AUTO_DETECT_COMPILER = GROUP.registerEvent("autoDetectCompiler", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> CREATE_MODULES_FOR_AGGREGATORS = GROUP.registerEvent("createModulesForAggregators", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> CREATE_MODULE_GROUPS = GROUP.registerEvent("createModuleGroups", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> KEEP_SOURCE_FOLDERS = GROUP.registerEvent("keepSourceFolders", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> EXCLUDE_TARGET_FOLDER = GROUP.registerEvent("excludeTargetFolder", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> USE_MAVEN_OUTPUT = GROUP.registerEvent("useMavenOutput", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> DOWNLOAD_DOCS_AUTOMATICALLY = GROUP.registerEvent("downloadDocsAutomatically", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> DOWNLOAD_SOURCES_AUTOMATICALLY = GROUP.registerEvent("downloadSourcesAutomatically", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> CUSTOM_DEPENDENCY_TYPES = GROUP.registerEvent("customDependencyTypes", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> HAS_VM_OPTIONS_FOR_IMPORTER = GROUP.registerEvent("hasVmOptionsForImporter", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> HAS_IGNORED_FILES = GROUP.registerEvent("hasIgnoredFiles", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> HAS_IGNORED_PATTERNS = GROUP.registerEvent("hasIgnoredPatterns", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> DELEGATE_BUILD_RUN = GROUP.registerEvent("delegateBuildRun", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> RUN_MAVEN_IN_BACKGROUND = GROUP.registerEvent("runMavenInBackground", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> HAS_RUNNER_VM_OPTIONS = GROUP.registerEvent("hasRunnerVmOptions", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> HAS_RUNNER_ENV_VARIABLES = GROUP.registerEvent("hasRunnerEnvVariables", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> PASS_PARENT_ENV = GROUP.registerEvent("passParentEnv", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> SKIP_TESTS = GROUP.registerEvent("skipTests", (EventField)EventFields.Enabled);
    @NotNull
    private static final EventId1<Boolean> HAS_RUNNER_MAVEN_PROPERTIES = GROUP.registerEvent("hasRunnerMavenProperties", (EventField)EventFields.Enabled);
    @NotNull
    private static final StringEventField VERSION_FIELD = EventFields.StringValidatedByRegexp((String)"value", (String)"version");
    @NotNull
    private static final EventId1<MavenExecutionOptions.ChecksumPolicy> CHECKSUM_POLICY = GROUP.registerEvent("checksumPolicy", (EventField)EventFields.Enum((String)"value", MavenExecutionOptions.ChecksumPolicy.class, (Function1)Companion.CHECKSUM_POLICY.1.INSTANCE));
    @NotNull
    private static final EventId1<MavenExecutionOptions.FailureMode> FAILURE_BEHAVIOR = GROUP.registerEvent("failureBehavior", (EventField)EventFields.Enum((String)"value", MavenExecutionOptions.FailureMode.class, (Function1)Companion.FAILURE_BEHAVIOR.1.INSTANCE));
    @NotNull
    private static final EventId1<MavenExecutionOptions.LoggingLevel> OUTPUT_LEVEL = GROUP.registerEvent("outputLevel", (EventField)EventFields.Enum((String)"value", MavenExecutionOptions.LoggingLevel.class, (Function1)Companion.OUTPUT_LEVEL.1.INSTANCE));
    @NotNull
    private static final EventId1<MavenExecutionOptions.LoggingLevel> LOGGING_LEVEL = GROUP.registerEvent("loggingLevel", (EventField)EventFields.Enum((String)"value", MavenExecutionOptions.LoggingLevel.class, (Function1)Companion.LOGGING_LEVEL.1.INSTANCE));
    @NotNull
    private static final EventId1<String> MAVEN_VERSION = GROUP.registerEvent("mavenVersion", (EventField)VERSION_FIELD);
    @NotNull
    private static final EventId1<MavenImportingSettings.GeneratedSourcesFolder> GENERATED_SOURCES_FOLDER = GROUP.registerEvent("generatedSourcesFolder", (EventField)EventFields.Enum((String)"value", MavenImportingSettings.GeneratedSourcesFolder.class, (Function1)Companion.GENERATED_SOURCES_FOLDER.1.INSTANCE));
    @NotNull
    private static final EventId1<String> UPDATE_FOLDERS_ON_IMPORT_PHASE;
    @NotNull
    private static final EventId1<String> RUNNER_JRE_VERSION;
    @NotNull
    private static final EventId1<String> JDK_VERSION_FOR_IMPORTER;
    @NotNull
    private static final EventId1<ExternalSystemUsagesCollector.JreType> RUNNER_JRE_TYPE;
    @NotNull
    private static final EventId1<ExternalSystemUsagesCollector.JreType> JDK_TYPE_FOR_IMPORTER;

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        MavenProjectsManager manager = MavenProjectsManager.getInstance(project2);
        if (!manager.isMavenizedProject()) {
            return SetsKt.emptySet();
        }
        Set usages = new LinkedHashSet();
        usages.add(HAS_MAVEN_PROJECT.metric((Object)true));
        MavenGeneralSettings generalSettings = manager.getGeneralSettings();
        MavenExecutionOptions.ChecksumPolicy checksumPolicy = generalSettings.getChecksumPolicy();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)checksumPolicy), (String)"generalSettings.checksumPolicy");
        usages.add(CHECKSUM_POLICY.metric((Object)checksumPolicy));
        MavenExecutionOptions.FailureMode failureMode = generalSettings.getFailureBehavior();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)failureMode), (String)"generalSettings.failureBehavior");
        usages.add(FAILURE_BEHAVIOR.metric((Object)failureMode));
        usages.add(ALWAYS_UPDATE_SNAPSHOTS.metric((Object)generalSettings.isAlwaysUpdateSnapshots()));
        usages.add(NON_RECURSIVE.metric((Object)generalSettings.isNonRecursive()));
        usages.add(PRINT_ERROR_STACK_TRACES.metric((Object)generalSettings.isPrintErrorStackTraces()));
        usages.add(USE_PLUGIN_REGISTRY.metric((Object)generalSettings.isUsePluginRegistry()));
        usages.add(WORK_OFFLINE.metric((Object)generalSettings.isWorkOffline()));
        MavenExecutionOptions.LoggingLevel loggingLevel = generalSettings.getOutputLevel();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)loggingLevel), (String)"generalSettings.outputLevel");
        usages.add(OUTPUT_LEVEL.metric((Object)loggingLevel));
        MavenExecutionOptions.LoggingLevel loggingLevel2 = generalSettings.getLoggingLevel();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)loggingLevel2), (String)"generalSettings.loggingLevel");
        usages.add(LOGGING_LEVEL.metric((Object)loggingLevel2));
        try {
            String string;
            String mavenVersion;
            block7: {
                block6: {
                    Intrinsics.checkNotNullExpressionValue((Object)manager, (String)"manager");
                    Intrinsics.checkNotNullExpressionValue((Object)generalSettings, (String)"generalSettings");
                    File mavenWrapperFile = this.getMavenWrapper(manager, generalSettings, project2);
                    mavenVersion = MavenUtil.getMavenVersion(MavenExternalParameters.resolveMavenHome(generalSettings, project2, null, mavenWrapperFile));
                    string = mavenVersion;
                    if (string == null) break block6;
                    String it = string;
                    boolean bl = false;
                    Version version2 = Version.parseVersion((String)it);
                    String string2 = version2 != null ? version2.toCompactString() : null;
                    string = string2;
                    if (string2 != null) break block7;
                }
                string = "unknown";
            }
            mavenVersion = string;
            usages.add(MAVEN_VERSION.metric((Object)mavenVersion));
        }
        catch (Exception mavenWrapperFile) {
            // empty catch block
        }
        String string = generalSettings.getLocalRepository();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generalSettings.localRepository");
        usages.add(LOCAL_REPOSITORY.metric((Object)(!StringsKt.isBlank((CharSequence)string) ? 1 : 0)));
        String string3 = generalSettings.getUserSettingsFile();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"generalSettings.userSettingsFile");
        usages.add(USER_SETTINGS_FILE.metric((Object)(!StringsKt.isBlank((CharSequence)string3) ? 1 : 0)));
        MavenImportingSettings importingSettings = manager.getImportingSettings();
        usages.add(LOOK_FOR_NESTED.metric((Object)importingSettings.isLookForNested()));
        usages.add(USE_WORKSPACE_IMPORT.metric((Object)importingSettings.isWorkspaceImportEnabled()));
        String string4 = importingSettings.getDedicatedModuleDir();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"importingSettings.dedicatedModuleDir");
        usages.add(DEDICATED_MODULE_DIR.metric((Object)(!StringsKt.isBlank((CharSequence)string4) ? 1 : 0)));
        usages.add(STORE_PROJECT_FILES_EXTERNALLY.metric((Object)ExternalStorageConfigurationManager.getInstance((Project)project2).isEnabled()));
        usages.add(IS_DIRECTORY_BASED_PROJECT.metric((Object)ProjectKt.isDirectoryBased((Project)project2)));
        usages.add(AUTO_DETECT_COMPILER.metric((Object)importingSettings.isAutoDetectCompiler()));
        usages.add(CREATE_MODULES_FOR_AGGREGATORS.metric((Object)importingSettings.isCreateModulesForAggregators()));
        usages.add(CREATE_MODULE_GROUPS.metric((Object)importingSettings.isCreateModuleGroups()));
        usages.add(KEEP_SOURCE_FOLDERS.metric((Object)importingSettings.isKeepSourceFolders()));
        usages.add(EXCLUDE_TARGET_FOLDER.metric((Object)importingSettings.isExcludeTargetFolder()));
        usages.add(USE_MAVEN_OUTPUT.metric((Object)importingSettings.isUseMavenOutput()));
        MavenImportingSettings.GeneratedSourcesFolder generatedSourcesFolder = importingSettings.getGeneratedSourcesFolder();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)generatedSourcesFolder), (String)"importingSettings.generatedSourcesFolder");
        usages.add(GENERATED_SOURCES_FOLDER.metric((Object)generatedSourcesFolder));
        usages.add(UPDATE_FOLDERS_ON_IMPORT_PHASE.metric((Object)importingSettings.getUpdateFoldersOnImportPhase()));
        usages.add(DOWNLOAD_DOCS_AUTOMATICALLY.metric((Object)importingSettings.isDownloadDocsAutomatically()));
        usages.add(DOWNLOAD_SOURCES_AUTOMATICALLY.metric((Object)importingSettings.isDownloadSourcesAutomatically()));
        usages.add(CUSTOM_DEPENDENCY_TYPES.metric((Object)(!Intrinsics.areEqual((Object)"jar, test-jar, maven-plugin, ejb, ejb-client, jboss-har, jboss-sar, war, ear, bundle", (Object)importingSettings.getDependencyTypes()) ? 1 : 0)));
        usages.add(JDK_TYPE_FOR_IMPORTER.metric((Object)ExternalSystemUsagesCollector.Companion.getJreType(importingSettings.getJdkForImporter())));
        usages.add(JDK_VERSION_FOR_IMPORTER.metric((Object)ExternalSystemUsagesCollector.Companion.getJreVersion(project2, importingSettings.getJdkForImporter())));
        String string5 = importingSettings.getVmOptionsForImporter();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"importingSettings.vmOptionsForImporter");
        usages.add(HAS_VM_OPTIONS_FOR_IMPORTER.metric((Object)(!StringsKt.isBlank((CharSequence)string5) ? 1 : 0)));
        List<String> list = manager.getIgnoredFilesPaths();
        Intrinsics.checkNotNullExpressionValue(list, (String)"manager.ignoredFilesPaths");
        usages.add(HAS_IGNORED_FILES.metric((Object)(!((Collection)list).isEmpty() ? 1 : 0)));
        List<String> list2 = manager.getIgnoredFilesPatterns();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"manager.ignoredFilesPatterns");
        usages.add(HAS_IGNORED_PATTERNS.metric((Object)(!((Collection)list2).isEmpty() ? 1 : 0)));
        MavenRunnerSettings runnerSettings = MavenRunner.getInstance(project2).getSettings();
        usages.add(DELEGATE_BUILD_RUN.metric((Object)runnerSettings.isDelegateBuildToMaven()));
        usages.add(RUN_MAVEN_IN_BACKGROUND.metric((Object)runnerSettings.isRunMavenInBackground()));
        usages.add(RUNNER_JRE_TYPE.metric((Object)ExternalSystemUsagesCollector.Companion.getJreType(runnerSettings.getJreName())));
        usages.add(RUNNER_JRE_VERSION.metric((Object)ExternalSystemUsagesCollector.Companion.getJreVersion(project2, runnerSettings.getJreName())));
        String string6 = runnerSettings.getVmOptions();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"runnerSettings.vmOptions");
        usages.add(HAS_RUNNER_VM_OPTIONS.metric((Object)(!StringsKt.isBlank((CharSequence)string6) ? 1 : 0)));
        usages.add(HAS_RUNNER_ENV_VARIABLES.metric((Object)(!runnerSettings.getEnvironmentProperties().isEmpty() ? 1 : 0)));
        usages.add(PASS_PARENT_ENV.metric((Object)runnerSettings.isPassParentEnv()));
        usages.add(SKIP_TESTS.metric((Object)runnerSettings.isSkipTests()));
        Map<String, String> map = runnerSettings.getMavenProperties();
        usages.add(HAS_RUNNER_MAVEN_PROPERTIES.metric((Object)(!(map == null || map.isEmpty()) ? 1 : 0)));
        return usages;
    }

    private final File getMavenWrapper(MavenProjectsManager manager, MavenGeneralSettings generalSettings, Project project2) {
        File file;
        if (MavenUtil.isWrapper(generalSettings) && manager.getRootProjects().size() == 1) {
            MavenDistributionsCache mavenDistributionsCache = MavenDistributionsCache.getInstance(project2);
            List<MavenProject> list = manager.getRootProjects();
            Intrinsics.checkNotNullExpressionValue(list, (String)"manager.rootProjects");
            Object object = mavenDistributionsCache.getWrapper(((MavenProject)CollectionsKt.first(list)).getDirectory());
            file = object != null && (object = object.getMavenHome()) != null ? object.toFile() : null;
        } else {
            file = null;
        }
        return file;
    }

    static {
        Intrinsics.checkNotNullExpressionValue((Object)MavenImportingSettings.UPDATE_FOLDERS_PHASES, (String)"UPDATE_FOLDERS_PHASES");
        UPDATE_FOLDERS_ON_IMPORT_PHASE = GROUP.registerEvent("updateFoldersOnImportPhase", (EventField)EventFields.String((String)"value", (List)ArraysKt.toList((Object[])MavenImportingSettings.UPDATE_FOLDERS_PHASES)));
        RUNNER_JRE_VERSION = GROUP.registerEvent("runnerJreVersion", (EventField)VERSION_FIELD);
        JDK_VERSION_FOR_IMPORTER = GROUP.registerEvent("jdkVersionForImporter", (EventField)VERSION_FIELD);
        RUNNER_JRE_TYPE = GROUP.registerEvent("runnerJreType", (EventField)ExternalSystemUsagesCollector.Companion.getJRE_TYPE_FIELD());
        JDK_TYPE_FOR_IMPORTER = GROUP.registerEvent("jdkTypeForImporter", (EventField)ExternalSystemUsagesCollector.Companion.getJRE_TYPE_FIELD());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\"0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\"0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020&0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020 0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010.\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\"0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00100\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00101\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00102\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\"0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00103\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00104\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00105\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00106\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00109\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lorg/jetbrains/idea/maven/statistics/MavenSettingsCollector$Companion;", "", "()V", "ALWAYS_UPDATE_SNAPSHOTS", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "AUTO_DETECT_COMPILER", "CHECKSUM_POLICY", "Lorg/jetbrains/idea/maven/execution/MavenExecutionOptions$ChecksumPolicy;", "CREATE_MODULES_FOR_AGGREGATORS", "CREATE_MODULE_GROUPS", "CUSTOM_DEPENDENCY_TYPES", "DEDICATED_MODULE_DIR", "DELEGATE_BUILD_RUN", "DOWNLOAD_DOCS_AUTOMATICALLY", "DOWNLOAD_SOURCES_AUTOMATICALLY", "EXCLUDE_TARGET_FOLDER", "FAILURE_BEHAVIOR", "Lorg/jetbrains/idea/maven/execution/MavenExecutionOptions$FailureMode;", "GENERATED_SOURCES_FOLDER", "Lorg/jetbrains/idea/maven/project/MavenImportingSettings$GeneratedSourcesFolder;", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "HAS_IGNORED_FILES", "HAS_IGNORED_PATTERNS", "HAS_MAVEN_PROJECT", "HAS_RUNNER_ENV_VARIABLES", "HAS_RUNNER_MAVEN_PROPERTIES", "HAS_RUNNER_VM_OPTIONS", "HAS_VM_OPTIONS_FOR_IMPORTER", "IS_DIRECTORY_BASED_PROJECT", "JDK_TYPE_FOR_IMPORTER", "Lcom/intellij/openapi/externalSystem/statistics/ExternalSystemUsagesCollector$JreType;", "JDK_VERSION_FOR_IMPORTER", "", "KEEP_SOURCE_FOLDERS", "LOCAL_REPOSITORY", "LOGGING_LEVEL", "Lorg/jetbrains/idea/maven/execution/MavenExecutionOptions$LoggingLevel;", "LOOK_FOR_NESTED", "MAVEN_VERSION", "NON_RECURSIVE", "OUTPUT_LEVEL", "PASS_PARENT_ENV", "PRINT_ERROR_STACK_TRACES", "RUNNER_JRE_TYPE", "RUNNER_JRE_VERSION", "RUN_MAVEN_IN_BACKGROUND", "SKIP_TESTS", "STORE_PROJECT_FILES_EXTERNALLY", "UPDATE_FOLDERS_ON_IMPORT_PHASE", "USER_SETTINGS_FILE", "USE_MAVEN_OUTPUT", "USE_PLUGIN_REGISTRY", "USE_WORKSPACE_IMPORT", "VERSION_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "WORK_OFFLINE", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

