/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.actions;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.externalSystem.action.ExternalSystemActionUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;

public final class MavenActionUtil {
    private MavenActionUtil() {
    }

    public static boolean hasProject(DataContext context2) {
        return CommonDataKeys.PROJECT.getData(context2) != null;
    }

    @Nullable
    public static Project getProject(DataContext context2) {
        return (Project)CommonDataKeys.PROJECT.getData(context2);
    }

    public static boolean isMavenizedProject(DataContext context2) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(context2);
        if (project2 == null) {
            return false;
        }
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstanceIfCreated(project2);
        if (mavenProjectsManager == null) {
            return false;
        }
        return mavenProjectsManager.isMavenizedProject();
    }

    @Nullable
    public static MavenProject getMavenProject(DataContext context2) {
        MavenProject result2;
        MavenProjectsManager manager = MavenActionUtil.getProjectsManager(context2);
        if (manager == null) {
            return null;
        }
        VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(context2);
        if (file != null && (result2 = manager.findProject(file)) != null) {
            return result2;
        }
        Module module2 = ExternalSystemActionUtil.getModule((DataContext)context2);
        if (module2 != null && (result2 = manager.findProject(module2)) != null) {
            return result2;
        }
        return null;
    }

    @Nullable
    public static MavenProjectsManager getProjectsManager(DataContext context2) {
        Project project2 = MavenActionUtil.getProject(context2);
        if (project2 == null) {
            return null;
        }
        return MavenProjectsManager.getInstanceIfCreated(project2);
    }

    public static boolean isMavenProjectFile(VirtualFile file) {
        return file != null && !file.isDirectory() && file.isInLocalFileSystem() && MavenUtil.isPomFile(file);
    }

    public static List<MavenProject> getMavenProjects(DataContext context2) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(context2);
        if (project2 == null) {
            return Collections.emptyList();
        }
        VirtualFile[] virtualFiles = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(context2);
        if (virtualFiles == null || virtualFiles.length == 0) {
            return Collections.emptyList();
        }
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstanceIfCreated(project2);
        if (projectsManager == null || !projectsManager.isMavenizedProject()) {
            return Collections.emptyList();
        }
        LinkedHashSet<MavenProject> res = new LinkedHashSet<MavenProject>();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        for (VirtualFile file : virtualFiles) {
            MavenProject mavenProject2;
            if (file.isDirectory()) {
                VirtualFile contentRoot = fileIndex.getContentRootForFile(file);
                if (!file.equals(contentRoot)) {
                    return Collections.emptyList();
                }
                Module module2 = fileIndex.getModuleForFile(file);
                if (module2 == null || !projectsManager.isMavenizedModule(module2)) {
                    return Collections.emptyList();
                }
                mavenProject2 = projectsManager.findProject(module2);
            } else {
                mavenProject2 = projectsManager.findProject(file);
            }
            if (mavenProject2 == null) {
                return Collections.emptyList();
            }
            res.add(mavenProject2);
        }
        return new ArrayList<MavenProject>(res);
    }

    public static List<VirtualFile> getMavenProjectsFiles(DataContext context2) {
        return MavenUtil.collectFiles(MavenActionUtil.getMavenProjects(context2));
    }
}

