/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.optional.imageio;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.optional.imageio.DrawOperation;
import org.apache.tools.ant.types.optional.imageio.ImageOperation;
import org.apache.tools.ant.types.optional.imageio.TransformOperation;

public class Scale
extends TransformOperation
implements DrawOperation {
    private static final int HUNDRED = 100;
    private String widthStr = "100%";
    private String heightStr = "100%";
    private boolean xPercent = true;
    private boolean yPercent = true;
    private String proportions = "ignore";

    public void setProportions(ProportionsAttribute pa) {
        this.proportions = pa.getValue();
    }

    public void setWidth(String width) {
        this.widthStr = width;
    }

    public void setHeight(String height) {
        this.heightStr = height;
    }

    public float getWidth() {
        int percIndex = this.widthStr.indexOf(37);
        if (percIndex > 0) {
            this.xPercent = true;
            float width = Float.parseFloat(this.widthStr.substring(0, percIndex));
            return width / 100.0f;
        }
        this.xPercent = false;
        return Float.parseFloat(this.widthStr);
    }

    public float getHeight() {
        int percIndex = this.heightStr.indexOf(37);
        if (percIndex > 0) {
            this.yPercent = true;
            return Float.parseFloat(this.heightStr.substring(0, percIndex)) / 100.0f;
        }
        this.yPercent = false;
        return Float.parseFloat(this.heightStr);
    }

    public BufferedImage performScale(BufferedImage image) {
        float xFl = this.getWidth();
        float yFl = this.getHeight();
        if (!this.xPercent) {
            xFl /= (float)image.getWidth();
        }
        if (!this.yPercent) {
            yFl /= (float)image.getHeight();
        }
        if ("width".equals(this.proportions)) {
            yFl = xFl;
        } else if ("height".equals(this.proportions)) {
            xFl = yFl;
        } else if ("fit".equals(this.proportions)) {
            xFl = yFl = Math.min(xFl, yFl);
        } else if ("cover".equals(this.proportions)) {
            xFl = yFl = Math.max(xFl, yFl);
        }
        this.log("\tScaling to " + xFl * 100.0f + "% x " + yFl * 100.0f + "%");
        AffineTransform tx = AffineTransform.getScaleInstance(xFl, yFl);
        BufferedImage scaleImage = new BufferedImage((int)(xFl * (float)image.getWidth()), (int)(yFl * (float)image.getHeight()), image.getType());
        AffineTransformOp scaleOp = new AffineTransformOp(tx, 2);
        scaleOp.filter(image, scaleImage);
        return scaleImage;
    }

    @Override
    public BufferedImage executeTransformOperation(BufferedImage image) {
        for (ImageOperation instr : this.instructions) {
            if (instr instanceof DrawOperation) {
                return this.performScale(image);
            }
            if (!(instr instanceof TransformOperation)) continue;
            image = ((TransformOperation)instr).executeTransformOperation(image);
        }
        return this.performScale(image);
    }

    @Override
    public BufferedImage executeDrawOperation() {
        for (ImageOperation instr : this.instructions) {
            if (!(instr instanceof DrawOperation)) continue;
            BufferedImage image = null;
            this.performScale(image);
            return image;
        }
        return null;
    }

    public static class ProportionsAttribute
    extends EnumeratedAttribute {
        @Override
        public String[] getValues() {
            return new String[]{"ignore", "width", "height", "cover", "fit"};
        }
    }
}

