/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.build.FileNavigatable;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.MessageEventImpl;
import com.intellij.build.events.impl.ProgressBuildEventImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemBuildEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.gradle.internal.impldep.com.google.gson.GsonBuilder;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationResult;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.tooling.events.ProgressListener;
import org.gradle.tooling.events.StatusEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.execution.GradleProgressEventConverter;
import org.jetbrains.plugins.gradle.tooling.Message;

public class GradleProgressListener
implements ProgressListener,
org.gradle.tooling.ProgressListener {
    private static final Logger LOG = Logger.getInstance(GradleProgressListener.class);
    private final ExternalSystemTaskNotificationListener myListener;
    private final ExternalSystemTaskId myTaskId;
    private final Map<Object, Long> myStatusEventIds;
    private final Map<Object, StatusEvent> myDownloadStatusEventIds;
    private final String myOperationId;
    private static final String STARTING_GRADLE_DAEMON_EVENT = "Starting Gradle Daemon";
    private ExternalSystemTaskNotificationEvent myLastStatusChange;

    public GradleProgressListener(@NotNull ExternalSystemTaskNotificationListener listener2, @NotNull ExternalSystemTaskId taskId) {
        if (listener2 == null) {
            GradleProgressListener.$$$reportNull$$$0(0);
        }
        if (taskId == null) {
            GradleProgressListener.$$$reportNull$$$0(1);
        }
        this(listener2, taskId, null);
    }

    public GradleProgressListener(@NotNull ExternalSystemTaskNotificationListener listener2, @NotNull ExternalSystemTaskId taskId, @Nullable String buildRootDir) {
        if (listener2 == null) {
            GradleProgressListener.$$$reportNull$$$0(2);
        }
        if (taskId == null) {
            GradleProgressListener.$$$reportNull$$$0(3);
        }
        this.myStatusEventIds = new HashMap<Object, Long>();
        this.myDownloadStatusEventIds = new HashMap<Object, StatusEvent>();
        this.myLastStatusChange = null;
        this.myListener = listener2;
        this.myTaskId = taskId;
        this.myOperationId = taskId.hashCode() + ":" + FileUtil.pathHashCode((String)(buildRootDir == null ? UUID.randomUUID().toString() : buildRootDir));
    }

    public void statusChanged(ProgressEvent event) {
        ExternalSystemTaskNotificationEvent taskNotificationEvent;
        this.sendProgressToOutputIfNeeded(event);
        ExternalSystemTaskNotificationEvent progressBuildEvent = GradleProgressEventConverter.convertProgressBuildEvent(this.myTaskId, this.myTaskId, event);
        if (progressBuildEvent != null) {
            if (event instanceof StatusEvent) {
                this.myListener.onStatusChange(progressBuildEvent);
            } else if (!progressBuildEvent.equals((Object)this.myLastStatusChange)) {
                this.myListener.onStatusChange(progressBuildEvent);
                this.myLastStatusChange = progressBuildEvent;
            }
        }
        if ((taskNotificationEvent = GradleProgressEventConverter.createTaskNotificationEvent(this.myTaskId, this.myOperationId, event)) != null) {
            this.myListener.onStatusChange(taskNotificationEvent);
        }
    }

    public void statusChanged(org.gradle.tooling.ProgressEvent event) {
        String eventDescription = event.getDescription();
        if (!this.maybeReportModelBuilderMessage(eventDescription)) {
            ExternalSystemTaskNotificationEvent progressBuildEvent = GradleProgressEventConverter.legacyConvertProgressBuildEvent(this.myTaskId, this.myTaskId, eventDescription);
            if (progressBuildEvent != null && !progressBuildEvent.equals((Object)this.myLastStatusChange)) {
                this.myListener.onStatusChange(progressBuildEvent);
                this.myLastStatusChange = progressBuildEvent;
            }
            ExternalSystemTaskNotificationEvent taskNotificationEvent = GradleProgressEventConverter.legacyConvertTaskNotificationEvent(this.myTaskId, eventDescription);
            this.myListener.onStatusChange(taskNotificationEvent);
            this.reportGradleDaemonStartingEvent(eventDescription);
        }
    }

    private boolean maybeReportModelBuilderMessage(String eventDescription) {
        if (!eventDescription.startsWith("ModelBuilderService message: ")) {
            return false;
        }
        try {
            Message message = (Message)new GsonBuilder().create().fromJson(StringUtil.substringAfter((String)eventDescription, (String)"ModelBuilderService message: "), Message.class);
            MessageEvent.Kind kind = MessageEvent.Kind.valueOf((String)message.getKind().name());
            Message.FilePosition messageFilePosition = message.getFilePosition();
            final FilePosition filePosition = messageFilePosition == null ? null : new FilePosition(new File(messageFilePosition.getFilePath()), messageFilePosition.getLine(), messageFilePosition.getColumn());
            MessageEventImpl messageEvent = new MessageEventImpl(this.myTaskId, kind, message.getGroup(), message.getTitle(), message.getText()){

                @Nullable
                public Navigatable getNavigatable(@NotNull Project project) {
                    if (project == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (filePosition == null) {
                        return null;
                    }
                    return new FileNavigatable(project, filePosition);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/service/execution/GradleProgressListener$1", "getNavigatable"));
                }
            };
            this.myListener.onStatusChange((ExternalSystemTaskNotificationEvent)new ExternalSystemBuildEvent(this.myTaskId, (BuildEvent)messageEvent));
            return true;
        }
        catch (Exception e) {
            LOG.warn("Failed to report model builder message using event '" + eventDescription + "'", (Throwable)e);
            return false;
        }
    }

    private void sendProgressToOutputIfNeeded(ProgressEvent progressEvent) {
        @NlsSafe String operationName = progressEvent.getDescriptor().getName();
        if (progressEvent instanceof StatusEvent) {
            StatusEvent statusEvent = (StatusEvent)progressEvent;
            if ("bytes".equals(statusEvent.getUnit())) {
                StatusEvent oldStatusEvent = this.myDownloadStatusEventIds.get(operationName);
                this.myDownloadStatusEventIds.put(operationName, statusEvent);
                if (oldStatusEvent == null || oldStatusEvent.getProgress() != statusEvent.getProgress()) {
                    long progress = statusEvent.getProgress() > 0L ? statusEvent.getProgress() : 0L;
                    long total = statusEvent.getTotal() > 0L ? statusEvent.getTotal() : 0L;
                    String text = String.format("%s (%s / %s)", operationName, StringUtil.formatFileSize((long)progress), StringUtil.formatFileSize((long)total));
                    if (oldStatusEvent == null) {
                        this.myListener.onTaskOutput(this.myTaskId, text, true);
                    } else {
                        this.myListener.onTaskOutput(this.myTaskId, "\r" + text, true);
                    }
                }
            }
        } else if (progressEvent instanceof FinishEvent) {
            FinishEvent finishEvent = (FinishEvent)progressEvent;
            StatusEvent statusEvent = this.myDownloadStatusEventIds.remove(operationName);
            if (statusEvent != null) {
                OperationResult operationResult = finishEvent.getResult();
                long duration = operationResult.getEndTime() - operationResult.getStartTime();
                long progress = statusEvent.getProgress() > 0L ? statusEvent.getProgress() : 0L;
                long total = statusEvent.getTotal() > 0L ? statusEvent.getTotal() : 0L;
                String text = String.format("%s, took %s (%s)", operationName, StringUtil.formatDuration((long)duration), StringUtil.formatFileSize((long)total));
                this.myListener.onTaskOutput(this.myTaskId, "\r" + text + "\n", true);
                if (total != progress) {
                    ProgressBuildEventImpl progressBuildEvent = new ProgressBuildEventImpl((Object)this.myTaskId, (Object)this.myTaskId, System.currentTimeMillis(), operationName, total, progress, "bytes");
                    this.myListener.onStatusChange((ExternalSystemTaskNotificationEvent)new ExternalSystemBuildEvent(this.myTaskId, (BuildEvent)progressBuildEvent));
                }
            }
        }
    }

    private void reportGradleDaemonStartingEvent(String eventDescription) {
        if (StringUtil.equals((CharSequence)STARTING_GRADLE_DAEMON_EVENT, (CharSequence)eventDescription)) {
            long eventTime = System.currentTimeMillis();
            Long startTime = this.myStatusEventIds.remove(eventDescription);
            if (startTime == null) {
                this.myListener.onTaskOutput(this.myTaskId, "Starting Gradle Daemon...\n", true);
                this.myStatusEventIds.put(eventDescription, eventTime);
            } else {
                String duration = StringUtil.formatDuration((long)(eventTime - startTime));
                this.myListener.onTaskOutput(this.myTaskId, "\rGradle Daemon started in " + duration + "\n", true);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "listener";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "taskId";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/gradle/service/execution/GradleProgressListener";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

