/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class CapturingProcessRunner {
    @NotNull
    private static final Logger LOG = Logger.getInstance(CapturingProcessRunner.class);
    @NotNull
    private final ProcessOutput myOutput;
    @NotNull
    private final ProcessHandler myProcessHandler;

    public CapturingProcessRunner(@NotNull BaseProcessHandler<?> processHandler) {
        if (processHandler == null) {
            CapturingProcessRunner.$$$reportNull$$$0(0);
        }
        this((ProcessHandler)processHandler);
    }

    public CapturingProcessRunner(@NotNull BaseProcessHandler<?> processHandler, @NotNull Function<? super ProcessOutput, ? extends ProcessAdapter> processAdapterProducer) {
        if (processHandler == null) {
            CapturingProcessRunner.$$$reportNull$$$0(1);
        }
        if (processAdapterProducer == null) {
            CapturingProcessRunner.$$$reportNull$$$0(2);
        }
        this((ProcessHandler)processHandler, processAdapterProducer);
    }

    public CapturingProcessRunner(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            CapturingProcessRunner.$$$reportNull$$$0(3);
        }
        this(processHandler, (? super ProcessOutput processOutput) -> new CapturingProcessAdapter((ProcessOutput)processOutput));
    }

    public CapturingProcessRunner(@NotNull ProcessHandler processHandler, @NotNull Function<? super ProcessOutput, ? extends ProcessAdapter> processAdapterProducer) {
        if (processHandler == null) {
            CapturingProcessRunner.$$$reportNull$$$0(4);
        }
        if (processAdapterProducer == null) {
            CapturingProcessRunner.$$$reportNull$$$0(5);
        }
        this.myOutput = new ProcessOutput();
        this.myProcessHandler = processHandler;
        this.myProcessHandler.addProcessListener((ProcessListener)processAdapterProducer.apply(this.myOutput));
    }

    @NotNull
    public ProcessOutput runProcess() {
        this.myProcessHandler.startNotify();
        if (this.myProcessHandler.waitFor()) {
            this.setErrorCodeIfNotYetSet();
        } else {
            LOG.info("runProcess: exit value unavailable");
        }
        ProcessOutput processOutput = this.myOutput;
        if (processOutput == null) {
            CapturingProcessRunner.$$$reportNull$$$0(6);
        }
        return processOutput;
    }

    @NotNull
    public ProcessOutput runProcess(int timeoutInMilliseconds) {
        ProcessOutput processOutput = this.runProcess(timeoutInMilliseconds, true);
        if (processOutput == null) {
            CapturingProcessRunner.$$$reportNull$$$0(7);
        }
        return processOutput;
    }

    @NotNull
    public ProcessOutput runProcess(int timeoutInMilliseconds, boolean destroyOnTimeout) {
        if (timeoutInMilliseconds <= 0) {
            ProcessOutput processOutput = this.runProcess();
            if (processOutput == null) {
                CapturingProcessRunner.$$$reportNull$$$0(8);
            }
            return processOutput;
        }
        this.myProcessHandler.startNotify();
        if (this.myProcessHandler.waitFor((long)timeoutInMilliseconds)) {
            this.setErrorCodeIfNotYetSet();
        } else {
            if (destroyOnTimeout) {
                this.myProcessHandler.destroyProcess();
            }
            this.myOutput.setTimeout();
        }
        ProcessOutput processOutput = this.myOutput;
        if (processOutput == null) {
            CapturingProcessRunner.$$$reportNull$$$0(9);
        }
        return processOutput;
    }

    @NotNull
    public ProcessOutput runProcess(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            CapturingProcessRunner.$$$reportNull$$$0(10);
        }
        ProcessOutput processOutput = this.runProcess(indicator, -1);
        if (processOutput == null) {
            CapturingProcessRunner.$$$reportNull$$$0(11);
        }
        return processOutput;
    }

    @NotNull
    public ProcessOutput runProcess(@NotNull ProgressIndicator indicator, int timeoutInMilliseconds) {
        if (indicator == null) {
            CapturingProcessRunner.$$$reportNull$$$0(12);
        }
        ProcessOutput processOutput = this.runProcess(indicator, timeoutInMilliseconds, true);
        if (processOutput == null) {
            CapturingProcessRunner.$$$reportNull$$$0(13);
        }
        return processOutput;
    }

    @NotNull
    public ProcessOutput runProcess(@NotNull ProgressIndicator indicator, int timeoutInMilliseconds, boolean destroyOnTimeout) {
        if (indicator == null) {
            CapturingProcessRunner.$$$reportNull$$$0(14);
        }
        if (timeoutInMilliseconds <= 0) {
            timeoutInMilliseconds = Integer.MAX_VALUE;
        }
        int WAIT_INTERVAL = 10;
        int waitingTime = 0;
        boolean setExitCode2 = true;
        this.myProcessHandler.startNotify();
        while (!this.myProcessHandler.waitFor(10L)) {
            boolean destroying;
            boolean timeout = (waitingTime += 10) >= timeoutInMilliseconds;
            boolean canceled = indicator.isCanceled();
            if (!canceled && !timeout) continue;
            setExitCode2 = destroying = canceled || destroyOnTimeout;
            if (destroying && !this.myProcessHandler.isProcessTerminating() && !this.myProcessHandler.isProcessTerminated()) {
                this.myProcessHandler.destroyProcess();
            }
            if (canceled) {
                this.myOutput.setCancelled();
                break;
            }
            this.myOutput.setTimeout();
            break;
        }
        if (setExitCode2) {
            if (this.myProcessHandler.waitFor()) {
                this.setErrorCodeIfNotYetSet();
            } else {
                LOG.info("runProcess: exit value unavailable");
            }
        }
        ProcessOutput processOutput = this.myOutput;
        if (processOutput == null) {
            CapturingProcessRunner.$$$reportNull$$$0(15);
        }
        return processOutput;
    }

    private void setErrorCodeIfNotYetSet() {
        if (!this.myOutput.isExitCodeSet() && this.myProcessHandler instanceof BaseProcessHandler) {
            this.myOutput.setExitCode(((BaseProcessHandler)this.myProcessHandler).getProcess().exitValue());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9, 11, 13, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processAdapterProducer";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/process/CapturingProcessRunner";
                break;
            }
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/process/CapturingProcessRunner";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "runProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                break;
            }
            case 10: 
            case 12: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "runProcess";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9, 11, 13, 15 -> new IllegalStateException(string);
        };
    }
}

