/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.awt.PWindow;
import org.jetbrains.projector.awt.PWindowUtils;
import org.jetbrains.projector.awt.data.Direction;
import org.jetbrains.projector.awt.image.PGraphics2D;
import org.jetbrains.projector.awt.image.PGraphicsDevice;
import org.jetbrains.projector.awt.image.PGraphicsEnvironment;
import org.jetbrains.projector.awt.peer.base.PWindowPeerBase;
import org.jetbrains.projector.awt.service.ImageCacher;
import org.jetbrains.projector.util.logging.Logger;
import org.jetbrains.projector.util.logging.LoggerKt;
import sun.awt.AWTAccessor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u000f\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 S2\u00020\u0001:\u0002STB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010>\u001a\u00020?J\u0006\u0010@\u001a\u00020?J\u0016\u0010A\u001a\u00020?2\u0006\u0010B\u001a\u00020\u00142\u0006\u0010C\u001a\u00020\u0014J\u0006\u0010D\u001a\u00020?J\u001e\u0010E\u001a\u00020?2\u0006\u0010B\u001a\u00020\u00142\u0006\u0010C\u001a\u00020\u00142\u0006\u0010F\u001a\u00020GJ&\u0010H\u001a\u00020?2\u0006\u0010I\u001a\u00020\u00142\u0006\u0010J\u001a\u00020\u00142\u0006\u0010K\u001a\u00020\u00142\u0006\u0010L\u001a\u00020\u0014J\u0006\u0010M\u001a\u00020?J\u0006\u0010N\u001a\u00020?J\u0006\u0010O\u001a\u00020?J\r\u0010P\u001a\u00020?H\u0000\u00a2\u0006\u0002\bQJ\u0006\u0010R\u001a\u00020?R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R.\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00182\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0018@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001f\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010 R\u0011\u0010\"\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010 R\u0013\u0010$\u001a\u0004\u0018\u00010\u00008F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0011\u0010+\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010 R)\u0010-\u001a\u0010\u0012\f\u0012\n /*\u0004\u0018\u00010\u00000\u00000.8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b2\u00103\u001a\u0004\b0\u00101R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u001c\u00106\u001a\u0004\u0018\u000107X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\u0011\u0010<\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010 \u00a8\u0006U"}, d2={"Lorg/jetbrains/projector/awt/PWindow;", "", "target", "Ljava/awt/Component;", "isAgent", "", "(Ljava/awt/Component;Z)V", "graphicsOverride", "Ljava/awt/Graphics2D;", "(Ljava/awt/Component;ZLjava/awt/Graphics2D;)V", "cursor", "Ljava/awt/Cursor;", "getCursor", "()Ljava/awt/Cursor;", "setCursor", "(Ljava/awt/Cursor;)V", "graphics", "getGraphics", "()Ljava/awt/Graphics2D;", "headerHeight", "", "getHeaderHeight", "()Ljava/lang/Integer;", "<set-?>", "", "icons", "getIcons", "()Ljava/util/List;", "id", "getId", "()I", "isAlwaysOnTop", "()Z", "isAutoRequestFocus", "modal", "getModal", "parentWindow", "getParentWindow", "()Lorg/jetbrains/projector/awt/PWindow;", "renderingScale", "", "getRenderingScale", "()F", "resizable", "getResizable", "self", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "getSelf", "()Ljava/lang/ref/WeakReference;", "self$delegate", "Lkotlin/Lazy;", "getTarget", "()Ljava/awt/Component;", "title", "", "getTitle", "()Ljava/lang/String;", "setTitle", "(Ljava/lang/String;)V", "undecorated", "getUndecorated", "close", "", "dispose", "move", "deltaX", "deltaY", "repaint", "resize", "direction", "Lorg/jetbrains/projector/awt/data/Direction;", "setBounds", "x", "y", "width", "height", "toBack", "toFront", "transferNativeFocus", "updateGraphics", "updateGraphics$projector_awt_common", "updateIcons", "Companion", "Descriptor", "projector-awt-common"})
public final class PWindow {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Component target;
    private final boolean isAgent;
    @NotNull
    private final Graphics2D graphics;
    private final int id;
    @Nullable
    private String title;
    private final boolean resizable;
    private final boolean modal;
    private final boolean undecorated;
    private final boolean isAutoRequestFocus;
    @Nullable
    private List<? extends Object> icons;
    @NotNull
    private final Lazy self$delegate;
    @Nullable
    private Cursor cursor;
    @NotNull
    private static ArrayDeque<WeakReference<PWindow>> weakWindows = new ArrayDeque();
    @NotNull
    private static final AtomicInteger windowIdCounter = new AtomicInteger();
    @NotNull
    private static final Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PWindow(Component target, boolean isAgent, Graphics2D graphicsOverride) {
        this.target = target;
        this.isAgent = isAgent;
        Serializable serializable = this.target;
        this.title = serializable instanceof Frame ? ((Frame)this.target).getTitle() : (serializable instanceof Dialog ? ((Dialog)this.target).getTitle() : null);
        serializable = this.target;
        this.resizable = serializable instanceof Frame ? ((Frame)this.target).isResizable() : (serializable instanceof Dialog ? ((Dialog)this.target).isResizable() : false);
        this.modal = this.target instanceof Dialog ? ((Dialog)this.target).isModal() : false;
        serializable = this.target;
        this.undecorated = serializable instanceof Frame ? ((Frame)this.target).isUndecorated() : (serializable instanceof Dialog ? ((Dialog)this.target).isUndecorated() : true);
        this.isAutoRequestFocus = this.target instanceof Window ? ((Window)this.target).isAutoRequestFocus() : false;
        this.updateIcons();
        this.self$delegate = LazyKt.lazy((Function0)((Function0)new Function0<WeakReference<PWindow>>(this){
            final /* synthetic */ PWindow this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final WeakReference<PWindow> invoke() {
                return new WeakReference<PWindow>(this.this$0);
            }
        }));
        this.cursor = this.target.getCursor();
        serializable = weakWindows;
        synchronized (serializable) {
            boolean bl = false;
            this.id = windowIdCounter.incrementAndGet();
            if (this.getId() == 0) {
                Logger.DefaultImpls.error$default(logger, null, 1.1.INSTANCE, 1, null);
            }
            weakWindows.addLast(this.getSelf());
            Unit unit = Unit.INSTANCE;
        }
        Graphics2D graphics2D = graphicsOverride;
        if (graphics2D == null) {
            graphics2D = new PGraphics2D(this.target, new Descriptor(this.id));
        }
        this.graphics = graphics2D;
        this.updateGraphics$projector_awt_common();
    }

    @NotNull
    public final Component getTarget() {
        return this.target;
    }

    public PWindow(@NotNull Component target, boolean isAgent) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this(target, isAgent, null);
    }

    @NotNull
    public final Graphics2D getGraphics() {
        return this.graphics;
    }

    public final int getId() {
        return this.id;
    }

    @Nullable
    public final String getTitle() {
        return this.title;
    }

    public final void setTitle(@Nullable String string) {
        this.title = string;
    }

    public final boolean getResizable() {
        return this.resizable;
    }

    public final boolean getModal() {
        return this.modal;
    }

    public final boolean getUndecorated() {
        return this.undecorated;
    }

    public final boolean isAutoRequestFocus() {
        return this.isAutoRequestFocus;
    }

    public final boolean isAlwaysOnTop() {
        return this.target instanceof Window ? ((Window)this.target).isAlwaysOnTop() : false;
    }

    @Nullable
    public final PWindow getParentWindow() {
        PWindow pWindow;
        Component component = this.target;
        Window window = component instanceof Window ? (Window)component : null;
        if (window == null) {
            pWindow = null;
        } else {
            Window window2 = window.getOwner();
            if (window2 == null) {
                pWindow = null;
            } else {
                Window it = window2;
                boolean bl = false;
                Object t = AWTAccessor.getComponentAccessor().getPeer(it);
                PWindowPeerBase pWindowPeerBase = t instanceof PWindowPeerBase ? (PWindowPeerBase)t : null;
                pWindow = pWindowPeerBase == null ? null : pWindowPeerBase.getPWindow();
            }
        }
        return pWindow;
    }

    @Nullable
    public final List<Object> getIcons() {
        return this.icons;
    }

    @Nullable
    public final Integer getHeaderHeight() {
        Integer n;
        if (this.target instanceof Container) {
            int n2;
            Insets insets = ((Container)this.target).getInsets();
            n = insets == null ? 0 : (n2 = insets.top);
        } else {
            n = null;
        }
        return n;
    }

    private final WeakReference<PWindow> getSelf() {
        Lazy lazy = this.self$delegate;
        return (WeakReference)lazy.getValue();
    }

    @Nullable
    public final Cursor getCursor() {
        return this.cursor;
    }

    public final void setCursor(@Nullable Cursor cursor) {
        this.cursor = cursor;
    }

    public final void transferNativeFocus() {
        if (!this.isAgent) {
            if (this.target instanceof Window) {
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent((Window)this.target, 207));
            } else {
                this.target.requestFocusInWindow();
            }
        } else {
            this.target.requestFocusInWindow();
        }
    }

    public final void setBounds(int x, int y, int width, int height) {
        Component component;
        boolean hasResized;
        boolean hasMoved = this.target.getX() != x || this.target.getY() != y;
        boolean bl = hasResized = this.target.getWidth() != width || this.target.getHeight() != height;
        if (!hasMoved && !hasResized) {
            return;
        }
        this.toFront();
        this.transferNativeFocus();
        if (PGraphicsEnvironment.Companion.getClientDoesWindowManagement()) {
            AWTAccessor.getComponentAccessor().setLocation(this.target, x, y);
            AWTAccessor.getComponentAccessor().setSize(this.target, width, height);
        } else {
            Rectangle visibleBounds = PWindowUtils.INSTANCE.getVisibleWindowBoundsIfNeeded(x, y, width, height);
            if (visibleBounds == null) {
                AWTAccessor.getComponentAccessor().setLocation(this.target, x, y);
                AWTAccessor.getComponentAccessor().setSize(this.target, width, height);
            } else {
                AWTAccessor.getComponentAccessor().setLocation(this.target, visibleBounds.x, visibleBounds.y);
                AWTAccessor.getComponentAccessor().setSize(this.target, visibleBounds.width, visibleBounds.height);
            }
        }
        this.updateGraphics$projector_awt_common();
        if (hasMoved) {
            component = this.target;
            Window window = component instanceof Window ? (Window)component : null;
            if (window != null) {
                window.dispatchEvent(new ComponentEvent(this.target, 100));
            }
        }
        if (hasResized) {
            component = this.target;
            Window window = component instanceof Window ? (Window)component : null;
            if (window != null) {
                window.dispatchEvent(new ComponentEvent(this.target, 101));
            }
        }
        if (hasResized) {
            this.target.revalidate();
        }
        this.repaint();
    }

    public final void updateGraphics$projector_awt_common() {
        if (!this.isAgent) {
            Object v0;
            Rectangle $this$updateGraphics_u24lambda_u2d2 = this.target.getBounds();
            boolean bl = false;
            Point windowMidpoint = new Point($this$updateGraphics_u24lambda_u2d2.x + $this$updateGraphics_u24lambda_u2d2.width / 2, $this$updateGraphics_u24lambda_u2d2.y + $this$updateGraphics_u24lambda_u2d2.height / 2);
            Iterable $this$minByOrNull$iv = PGraphicsEnvironment.Companion.getDevices();
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = minElem$iv;
                } else {
                    PGraphicsDevice it = (PGraphicsDevice)minElem$iv;
                    boolean bl2 = false;
                    Rectangle deviceBounds = it.getBounds();
                    int minValue$iv = deviceBounds.contains(windowMidpoint) ? 0 : Math.min(Math.min(Math.abs(deviceBounds.x - windowMidpoint.x), Math.abs(deviceBounds.x + deviceBounds.width - windowMidpoint.x)), Math.min(Math.abs(deviceBounds.y - windowMidpoint.y), Math.abs(deviceBounds.y + deviceBounds.height - windowMidpoint.y)));
                    do {
                        Object e$iv = iterator$iv.next();
                        PGraphicsDevice it2 = (PGraphicsDevice)e$iv;
                        $i$a$-minByOrNull-PWindow$updateGraphics$newDevice$1 = false;
                        Rectangle deviceBounds2 = it2.getBounds();
                        int v$iv = deviceBounds2.contains(windowMidpoint) ? 0 : Math.min(Math.min(Math.abs(deviceBounds2.x - windowMidpoint.x), Math.abs(deviceBounds2.x + deviceBounds2.width - windowMidpoint.x)), Math.min(Math.abs(deviceBounds2.y - windowMidpoint.y), Math.abs(deviceBounds2.y + deviceBounds2.height - windowMidpoint.y)));
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = minElem$iv;
                }
            }
            PGraphicsDevice pGraphicsDevice = v0;
            if (pGraphicsDevice == null) {
                return;
            }
            PGraphicsDevice newDevice = pGraphicsDevice;
            Graphics2D graphics2D = this.graphics;
            PGraphics2D pGraphics2D = graphics2D instanceof PGraphics2D ? (PGraphics2D)graphics2D : null;
            if (pGraphics2D != null) {
                pGraphics2D.setDevice(newDevice);
            }
            this.graphics.setTransform(newDevice.getConfiguration().getDefaultTransform());
            AWTAccessor.getComponentAccessor().setGraphicsConfiguration(this.target, newDevice.getConfiguration());
        }
    }

    public final float getRenderingScale() {
        return (float)this.graphics.getTransform().getScaleX();
    }

    public final void move(int deltaX, int deltaY) {
        if (this.isAgent) {
            this.toFront();
            this.target.requestFocusInWindow();
            this.target.setLocation(this.target.getX() + deltaX, this.target.getY() + deltaY);
            this.repaint();
        } else {
            this.setBounds(this.target.getX() + deltaX, this.target.getY() + deltaY, this.target.getWidth(), this.target.getHeight());
        }
    }

    public final void resize(int deltaX, int deltaY, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        if (this.isAgent) {
            this.toFront();
            this.target.requestFocusInWindow();
            switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    this.target.setSize(this.target.getSize().width + deltaX, this.target.getSize().height + deltaY);
                    break;
                }
                case 4: {
                    this.target.setBounds(this.target.getX() + deltaX, this.target.getY(), this.target.getWidth() - deltaX, this.target.getSize().height + deltaY);
                    break;
                }
                case 5: {
                    this.target.setBounds(this.target.getX(), this.target.getY() + deltaY, this.target.getWidth() + deltaX, this.target.getHeight() - deltaY);
                    break;
                }
                default: {
                    this.target.setBounds(this.target.getX() + deltaX, this.target.getY() + deltaY, this.target.getWidth() - deltaX, this.target.getHeight() - deltaY);
                }
            }
            this.target.revalidate();
            this.repaint();
        } else {
            switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    this.setBounds(this.target.getX(), this.target.getY(), this.target.getSize().width + deltaX, this.target.getSize().height + deltaY);
                    break;
                }
                case 4: {
                    this.setBounds(this.target.getX() + deltaX, this.target.getY(), this.target.getWidth() - deltaX, this.target.getSize().height + deltaY);
                    break;
                }
                case 5: {
                    this.setBounds(this.target.getX(), this.target.getY() + deltaY, this.target.getWidth() + deltaX, this.target.getHeight() - deltaY);
                    break;
                }
                default: {
                    this.setBounds(this.target.getX() + deltaX, this.target.getY() + deltaY, this.target.getWidth() - deltaX, this.target.getHeight() - deltaY);
                }
            }
        }
    }

    public final void close() {
        Component component = this.target;
        Window window = component instanceof Window ? (Window)component : null;
        if (window != null) {
            window.dispose();
        }
    }

    public final void repaint() {
        this.target.repaint();
    }

    /*
     * WARNING - void declaration
     */
    public final void updateIcons() {
        List list;
        PWindow pWindow = this;
        Component component = this.target;
        Window window = component instanceof Window ? (Window)component : null;
        if (window == null) {
            list = null;
        } else {
            List<Image> list2 = window.getIconImages();
            if (list2 == null) {
                list = null;
            } else {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = list2;
                PWindow pWindow2 = pWindow;
                boolean $i$f$map = false;
                void var4_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Image image = (Image)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    ImageCacher imageCacher = ImageCacher.Companion.getInstance();
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    collection.add(imageCacher.getImageId((Image)it, "updateIcons"));
                }
                list = (List)destination$iv$iv;
                pWindow = pWindow2;
            }
        }
        pWindow.icons = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void toFront() {
        ArrayDeque<WeakReference<PWindow>> arrayDeque = weakWindows;
        synchronized (arrayDeque) {
            boolean bl = false;
            if (!Intrinsics.areEqual(weakWindows.getLast(), this.getSelf())) {
                weakWindows.remove(this.getSelf());
                weakWindows.addLast(this.getSelf());
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void toBack() {
        ArrayDeque<WeakReference<PWindow>> arrayDeque = weakWindows;
        synchronized (arrayDeque) {
            boolean bl = false;
            if (!Intrinsics.areEqual(weakWindows.getFirst(), this.getSelf())) {
                weakWindows.remove(this.getSelf());
                weakWindows.addFirst(this.getSelf());
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void dispose() {
        PWindow.Companion.disposeWindow(this);
    }

    public /* synthetic */ PWindow(Component target, boolean isAgent, Graphics2D graphicsOverride, DefaultConstructorMarker $constructor_marker) {
        this(target, isAgent, graphicsOverride);
    }

    static {
        boolean $i$f$Logger = false;
        String string = Reflection.getOrCreateKotlinClass(PWindow.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        logger = LoggerKt.Logger(string);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\bH\u0002J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0018\u001a\u00020\u001aJ\u0010\u0010\u0019\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001b\u001a\u00020\u001cR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/projector/awt/PWindow$Companion;", "", "()V", "logger", "Lorg/jetbrains/projector/util/logging/Logger;", "weakWindows", "Ljava/util/ArrayDeque;", "Ljava/lang/ref/WeakReference;", "Lorg/jetbrains/projector/awt/PWindow;", "windowIdCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "windows", "", "getWindows", "()Ljava/util/List;", "createWithGraphicsOverride", "target", "Ljava/awt/Component;", "isAgent", "", "graphicsOverride", "Ljava/awt/Graphics2D;", "disposeWindow", "", "window", "getWindow", "Ljava/awt/Window;", "windowId", "", "projector-awt-common"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final List<PWindow> getWindows() {
            List list;
            ArrayDeque arrayDeque = weakWindows;
            synchronized (arrayDeque) {
                Iterable $this$mapNotNullTo$iv$iv;
                boolean bl = false;
                Iterable $this$mapNotNull$iv = weakWindows;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Object object = $this$forEach$iv$iv$iv.iterator();
                while (object.hasNext()) {
                    PWindow it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = object.next();
                    boolean bl2 = false;
                    WeakReference p0 = (WeakReference)element$iv$iv;
                    boolean bl3 = false;
                    if ((PWindow)p0.get() == null) continue;
                    boolean bl4 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List windows = (List)destination$iv$iv;
                if (weakWindows.size() != windows.size()) {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = windows;
                    boolean $i$f$map = false;
                    $this$mapNotNullTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void p0;
                        object = (PWindow)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl5 = false;
                        collection.add(new WeakReference<void>(p0));
                    }
                    Collection collection = (List)destination$iv$iv;
                    weakWindows = new ArrayDeque(collection);
                }
                list = windows;
            }
            return list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void disposeWindow(PWindow window) {
            ArrayDeque arrayDeque = weakWindows;
            synchronized (arrayDeque) {
                boolean bl = false;
                boolean bl2 = weakWindows.removeIf(arg_0 -> Companion.disposeWindow$lambda-3$lambda-2(window, arg_0));
            }
        }

        @Nullable
        public final PWindow getWindow(int windowId) {
            Object v0;
            block1: {
                for (Object t : (Iterable)this.getWindows()) {
                    PWindow it = (PWindow)t;
                    boolean bl = false;
                    if (!(it.getId() == windowId)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        @Nullable
        public final PWindow getWindow(@NotNull Window window) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)window, (String)"window");
                for (Object t : (Iterable)this.getWindows()) {
                    PWindow it = (PWindow)t;
                    boolean bl = false;
                    if (!(it.getTarget() == window)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        @NotNull
        public final PWindow createWithGraphicsOverride(@NotNull Component target, boolean isAgent, @Nullable Graphics2D graphicsOverride) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            return new PWindow(target, isAgent, graphicsOverride, null);
        }

        private static final boolean disposeWindow$lambda-3$lambda-2(PWindow $window, WeakReference it) {
            Intrinsics.checkNotNullParameter((Object)$window, (String)"$window");
            return Intrinsics.areEqual(it.get(), (Object)$window);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/projector/awt/PWindow$Descriptor;", "", "windowId", "", "(I)V", "getWindowId", "()I", "projector-awt-common"})
    public static final class Descriptor {
        private final int windowId;

        public Descriptor(int windowId) {
            this.windowId = windowId;
        }

        public final int getWindowId() {
            return this.windowId;
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            nArray[Direction.E.ordinal()] = 1;
            nArray[Direction.S.ordinal()] = 2;
            nArray[Direction.SE.ordinal()] = 3;
            nArray[Direction.SW.ordinal()] = 4;
            nArray[Direction.NE.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

