/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.ui;

import com.intellij.collaboration.auth.Account;
import com.intellij.collaboration.auth.ServerAccount;
import com.intellij.collaboration.ui.AccountSelectorComponentFactory;
import com.intellij.collaboration.ui.ComboBoxWithActionsModel;
import com.intellij.collaboration.ui.SimpleFocusBorder;
import com.intellij.collaboration.ui.icon.IconsProvider;
import com.intellij.collaboration.ui.util.ActionUtilKt;
import com.intellij.collaboration.ui.util.SwingBindingsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.ui.popup.list.ComboBoxPopup;
import com.intellij.util.ui.cloneDialog.AccountMenuItem;
import com.intellij.util.ui.cloneDialog.AccountMenuItemRenderer;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\u0019B)\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\b\u00a2\u0006\u0002\u0010\tJO\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u000b\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u00152\u0014\b\u0002\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170\u0005R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/collaboration/ui/AccountSelectorComponentFactory;", "A", "Lcom/intellij/collaboration/auth/Account;", "", "accountsState", "Lkotlinx/coroutines/flow/StateFlow;", "", "selectionState", "Lkotlinx/coroutines/flow/MutableStateFlow;", "(Lkotlinx/coroutines/flow/StateFlow;Lkotlinx/coroutines/flow/MutableStateFlow;)V", "create", "Ljavax/swing/JComponent;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "avatarIconsProvider", "Lcom/intellij/collaboration/ui/icon/IconsProvider;", "avatarSize", "", "popupAvatarSize", "emptyStateTooltip", "", "Lorg/jetbrains/annotations/Nls;", "actions", "", "Ljavax/swing/Action;", "Controller", "intellij.platform.collaborationTools"})
public final class AccountSelectorComponentFactory<A extends Account> {
    @NotNull
    private final StateFlow<Collection<A>> accountsState;
    @NotNull
    private final MutableStateFlow<A> selectionState;

    public AccountSelectorComponentFactory(@NotNull StateFlow<? extends Collection<? extends A>> accountsState, @NotNull MutableStateFlow<A> selectionState) {
        Intrinsics.checkNotNullParameter(accountsState, (String)"accountsState");
        Intrinsics.checkNotNullParameter(selectionState, (String)"selectionState");
        this.accountsState = accountsState;
        this.selectionState = selectionState;
    }

    @NotNull
    public final JComponent create(@NotNull CoroutineScope scope2, @NotNull IconsProvider<A> avatarIconsProvider, int avatarSize, int popupAvatarSize, @NotNull String emptyStateTooltip, @NotNull StateFlow<? extends List<? extends Action>> actions2) {
        JLabel jLabel;
        ComboBoxWithActionsModel comboBoxWithActionsModel;
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter(avatarIconsProvider, (String)"avatarIconsProvider");
        Intrinsics.checkNotNullParameter((Object)emptyStateTooltip, (String)"emptyStateTooltip");
        Intrinsics.checkNotNullParameter(actions2, (String)"actions");
        ComboBoxWithActionsModel $this$create_u24lambda_u241 = comboBoxWithActionsModel = new ComboBoxWithActionsModel();
        boolean bl = false;
        Comparator<Object> comparator2 = Comparator.comparing(arg_0 -> AccountSelectorComponentFactory.create$lambda$1$lambda$0(create.comboModel.1.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(comparator2, (String)"comparing { it.name }");
        SwingBindingsKt.bindIn($this$create_u24lambda_u241, scope2, this.accountsState, this.selectionState, actions2, comparator2);
        if ($this$create_u24lambda_u241.getSize() > 0) {
            int n = $this$create_u24lambda_u241.getSize();
            for (int i = 0; i < n; ++i) {
                Object item2 = $this$create_u24lambda_u241.getElementAt(i);
                if (!(item2 instanceof ComboBoxWithActionsModel.Item.Wrapper)) continue;
                $this$create_u24lambda_u241.setSelectedItem(item2);
                break;
            }
        }
        ComboBoxWithActionsModel comboModel2 = comboBoxWithActionsModel;
        JLabel $this$create_u24lambda_u242 = jLabel = new JLabel();
        boolean bl2 = false;
        $this$create_u24lambda_u242.setOpaque(false);
        $this$create_u24lambda_u242.setCursor(Cursor.getPredefinedCursor(12));
        $this$create_u24lambda_u242.setFocusable(true);
        $this$create_u24lambda_u242.setBorder(new SimpleFocusBorder());
        JLabel label = jLabel;
        new Controller(comboModel2, label, avatarIconsProvider, avatarSize, popupAvatarSize, emptyStateTooltip);
        return label;
    }

    public static /* synthetic */ JComponent create$default(AccountSelectorComponentFactory accountSelectorComponentFactory, CoroutineScope coroutineScope, IconsProvider iconsProvider, int n, int n2, String string2, StateFlow stateFlow, int n3, Object object) {
        if ((n3 & 0x20) != 0) {
            stateFlow = (StateFlow)StateFlowKt.MutableStateFlow((Object)CollectionsKt.emptyList());
        }
        return accountSelectorComponentFactory.create(coroutineScope, iconsProvider, n, n2, string2, (StateFlow<List<Action>>)stateFlow);
    }

    private static final String create$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u0003:\u0001 BF\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u000b\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0002\u0010\u0011J\u0014\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00040\u0015H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0014\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00040\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001bH\u0002J\u0014\u0010\u001d\u001a\u00020\u001b*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\fH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/collaboration/ui/AccountSelectorComponentFactory$Controller;", "A", "Lcom/intellij/collaboration/auth/Account;", "Lcom/intellij/ui/popup/list/ComboBoxPopup$Context;", "Lcom/intellij/collaboration/ui/ComboBoxWithActionsModel$Item;", "accountsModel", "Lcom/intellij/collaboration/ui/ComboBoxWithActionsModel;", "label", "Ljavax/swing/JLabel;", "avatarIconsProvider", "Lcom/intellij/collaboration/ui/icon/IconsProvider;", "avatarSize", "", "popupAvatarSize", "emptyStateTooltip", "", "Lorg/jetbrains/annotations/Nls;", "(Lcom/intellij/collaboration/ui/ComboBoxWithActionsModel;Ljavax/swing/JLabel;Lcom/intellij/collaboration/ui/icon/IconsProvider;IILjava/lang/String;)V", "popup", "Lcom/intellij/ui/popup/list/ComboBoxPopup;", "getModel", "Ljavax/swing/ListModel;", "getProject", "Lcom/intellij/openapi/project/Project;", "getRenderer", "Ljavax/swing/ListCellRenderer;", "showPopup", "", "updateLabel", "registerPopupOnKeyboardShortcut", "Ljavax/swing/JComponent;", "keyCode", "PopupItemRenderer", "intellij.platform.collaborationTools"})
    private static final class Controller<A extends Account>
    implements ComboBoxPopup.Context<ComboBoxWithActionsModel.Item<A>> {
        @NotNull
        private final ComboBoxWithActionsModel<A> accountsModel;
        @NotNull
        private final JLabel label;
        @NotNull
        private final IconsProvider<A> avatarIconsProvider;
        private final int avatarSize;
        private final int popupAvatarSize;
        @NotNull
        private final String emptyStateTooltip;
        @Nullable
        private ComboBoxPopup<?> popup;

        public Controller(@NotNull ComboBoxWithActionsModel<A> accountsModel, @NotNull JLabel label, @NotNull IconsProvider<A> avatarIconsProvider, int avatarSize, int popupAvatarSize, @NotNull String emptyStateTooltip) {
            Intrinsics.checkNotNullParameter(accountsModel, (String)"accountsModel");
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter(avatarIconsProvider, (String)"avatarIconsProvider");
            Intrinsics.checkNotNullParameter((Object)emptyStateTooltip, (String)"emptyStateTooltip");
            this.accountsModel = accountsModel;
            this.label = label;
            this.avatarIconsProvider = avatarIconsProvider;
            this.avatarSize = avatarSize;
            this.popupAvatarSize = popupAvatarSize;
            this.emptyStateTooltip = emptyStateTooltip;
            this.getModel().addListDataListener(new ListDataListener(){

                @Override
                public void contentsChanged(@NotNull ListDataEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.updateLabel();
                }

                @Override
                public void intervalAdded(@Nullable ListDataEvent e) {
                    this.updateLabel();
                }

                @Override
                public void intervalRemoved(@Nullable ListDataEvent e) {
                    this.updateLabel();
                }
            });
            this.label.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(@Nullable MouseEvent e) {
                    this.showPopup();
                }
            });
            this.registerPopupOnKeyboardShortcut(this.label, 10);
            this.registerPopupOnKeyboardShortcut(this.label, 32);
            this.updateLabel();
        }

        private final void updateLabel() {
            Object object = this.accountsModel.getSelectedItem();
            Account selectedAccount = object != null ? (Account)((ComboBoxWithActionsModel.Item.Wrapper)object).getWrappee() : null;
            JLabel $this$updateLabel_u24lambda_u240 = this.label;
            boolean bl = false;
            $this$updateLabel_u24lambda_u240.setIcon(this.avatarIconsProvider.getIcon(selectedAccount, this.avatarSize));
            Object object2 = selectedAccount;
            if (object2 == null || (object2 = ((Account)object2).getName()) == null) {
                object2 = this.emptyStateTooltip;
            }
            $this$updateLabel_u24lambda_u240.setToolTipText((String)object2);
        }

        /*
         * WARNING - void declaration
         */
        private final void showPopup() {
            void $this$showPopup_u24lambda_u242;
            if (!this.label.isEnabled()) {
                return;
            }
            Object object = this.accountsModel.getSelectedItem();
            Object object2 = arg_0 -> Controller.showPopup$lambda$1((Function1)new Function1<ComboBoxWithActionsModel.Item<A>, Unit>(this){
                final /* synthetic */ Controller<A> this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(ComboBoxWithActionsModel.Item<A> it) {
                    Controller.access$getAccountsModel$p(this.this$0).setSelectedItem(it);
                }
            }, arg_0);
            object = new ComboBoxPopup<ComboBoxWithActionsModel.Item<A>>(this, object, (Consumer<Object>)object2){
                final /* synthetic */ Controller<A> this$0;
                {
                    this.this$0 = $receiver;
                    super((ComboBoxPopup.Context)$receiver, $super_call_param$1, $super_call_param$2);
                }

                @NotNull
                protected ListCellRenderer<ComboBoxWithActionsModel.Item<A>> getListElementRenderer() {
                    return this.this$0.getRenderer();
                }
            };
            object2 = object;
            Controller controller = this;
            boolean bl = false;
            $this$showPopup_u24lambda_u242.addListener(new JBPopupListener(this){
                final /* synthetic */ Controller<A> this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onClosed(@NotNull LightweightWindowEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Controller.access$setPopup$p(this.this$0, null);
                }
            });
            $this$showPopup_u24lambda_u242.showUnderneathOf((Component)this.label);
            controller.popup = (ComboBoxPopup)object;
        }

        private final void registerPopupOnKeyboardShortcut(JComponent $this$registerPopupOnKeyboardShortcut, int keyCode) {
            $this$registerPopupOnKeyboardShortcut.registerKeyboardAction(arg_0 -> Controller.registerPopupOnKeyboardShortcut$lambda$3(this, arg_0), KeyStroke.getKeyStroke(keyCode, 0), 0);
        }

        @Nullable
        public Project getProject() {
            return null;
        }

        @NotNull
        public ListModel<ComboBoxWithActionsModel.Item<A>> getModel() {
            return this.accountsModel;
        }

        @NotNull
        public ListCellRenderer<ComboBoxWithActionsModel.Item<A>> getRenderer() {
            return new PopupItemRenderer();
        }

        private static final void showPopup$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }

        private static final void registerPopupOnKeyboardShortcut$lambda$3(Controller this$0, ActionEvent it) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            this$0.showPopup();
        }

        public static final /* synthetic */ ComboBoxWithActionsModel access$getAccountsModel$p(Controller $this) {
            return $this.accountsModel;
        }

        public static final /* synthetic */ void access$setPopup$p(Controller $this, ComboBoxPopup comboBoxPopup) {
            $this.popup = comboBoxPopup;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003JF\u0010\u0006\u001a\u00020\u00072\u0016\u0010\b\u001a\u0012\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00028\u00010\u0002\u0018\u00010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/collaboration/ui/AccountSelectorComponentFactory$Controller$PopupItemRenderer;", "Ljavax/swing/ListCellRenderer;", "Lcom/intellij/collaboration/ui/ComboBoxWithActionsModel$Item;", "(Lcom/intellij/collaboration/ui/AccountSelectorComponentFactory$Controller;)V", "delegateRenderer", "Lcom/intellij/util/ui/cloneDialog/AccountMenuItemRenderer;", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "value", "index", "", "selected", "", "focused", "intellij.platform.collaborationTools"})
        private final class PopupItemRenderer
        implements ListCellRenderer<ComboBoxWithActionsModel.Item<A>> {
            @NotNull
            private final AccountMenuItemRenderer delegateRenderer = new AccountMenuItemRenderer();

            @Override
            @NotNull
            public Component getListCellRendererComponent(@Nullable JList<? extends ComboBoxWithActionsModel.Item<A>> list, @NotNull ComboBoxWithActionsModel.Item<A> value2, int index, boolean selected, boolean focused) {
                AccountMenuItem accountMenuItem;
                Intrinsics.checkNotNullParameter(value2, (String)"value");
                ComboBoxWithActionsModel.Item item2 = value2;
                if (item2 instanceof ComboBoxWithActionsModel.Item.Wrapper) {
                    String string2;
                    Object t = ((ComboBoxWithActionsModel.Item.Wrapper)value2).getWrappee();
                    Controller controller = Controller.this;
                    Account account = (Account)t;
                    boolean bl = false;
                    Icon icon2 = controller.avatarIconsProvider.getIcon(account, controller.popupAvatarSize);
                    Object object = account instanceof ServerAccount ? (ServerAccount)account : null;
                    if ((object != null && (object = ((ServerAccount)object).getServer()) != null ? object.toString() : (string2 = null)) == null) {
                        string2 = "";
                    }
                    String serverAddress = string2;
                    accountMenuItem = new AccountMenuItem.Account(account.getName(), serverAddress, icon2, null, false, 24, null);
                } else if (item2 instanceof ComboBoxWithActionsModel.Item.Action) {
                    Action it = ((ComboBoxWithActionsModel.Item.Action)value2).getAction();
                    boolean bl = false;
                    String string3 = ActionUtilKt.getName(it);
                    if (string3 == null) {
                        string3 = "";
                    }
                    accountMenuItem = new AccountMenuItem.Action(string3, getListCellRendererComponent.item.2.1.INSTANCE, null, ((ComboBoxWithActionsModel.Item.Action)value2).getNeedSeparatorAbove(), 4, null);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                AccountMenuItem item3 = accountMenuItem;
                return this.delegateRenderer.getListCellRendererComponent((JList<? extends AccountMenuItem>)null, item3, index, selected, focused);
            }
        }
    }
}

