/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CommitInfo;
import com.intellij.openapi.vcs.checkin.CommitProblemWithDetails;
import com.intellij.openapi.vcs.checkin.TodoCheckinHandler;
import com.intellij.openapi.vcs.checkin.TodoCheckinHandlerWorker;
import com.intellij.psi.search.TodoItem;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/vcs/checkin/TodoCommitProblem;", "Lcom/intellij/openapi/vcs/checkin/CommitProblemWithDetails;", "worker", "Lcom/intellij/openapi/vcs/checkin/TodoCheckinHandlerWorker;", "isPostCommit", "", "(Lcom/intellij/openapi/vcs/checkin/TodoCheckinHandlerWorker;Z)V", "showDetailsAction", "", "getShowDetailsAction", "()Ljava/lang/String;", "text", "getText", "showDetails", "", "project", "Lcom/intellij/openapi/project/Project;", "showModalSolution", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler$ReturnResult;", "commitInfo", "Lcom/intellij/openapi/vcs/checkin/CommitInfo;", "intellij.platform.vcs.impl"})
public final class TodoCommitProblem
implements CommitProblemWithDetails {
    @NotNull
    private final TodoCheckinHandlerWorker worker;
    private final boolean isPostCommit;

    public TodoCommitProblem(@NotNull TodoCheckinHandlerWorker worker, boolean isPostCommit) {
        Intrinsics.checkNotNullParameter((Object)worker, (String)"worker");
        this.worker = worker;
        this.isPostCommit = isPostCommit;
    }

    @Override
    @NotNull
    public String getText() {
        Object[] objectArray = new Object[]{this.worker.inOneList().size()};
        String string2 = VcsBundle.message("label.todo.items.found", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"label.todo.item\u2026 worker.inOneList().size)");
        return string2;
    }

    @Override
    public void showDetails(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        List<Change> list = this.worker.getChanges();
        Intrinsics.checkNotNullExpressionValue(list, (String)"worker.changes");
        Collection collection = list;
        Set<TodoItem> set = this.worker.inOneList();
        Intrinsics.checkNotNullExpressionValue(set, (String)"worker.inOneList()");
        TodoCheckinHandler.Companion.showTodoItems$intellij_platform_vcs_impl(project2, collection, (Collection<? extends TodoItem>)set, this.isPostCommit);
    }

    @Override
    @NotNull
    public CheckinHandler.ReturnResult showModalSolution(@NotNull Project project2, @NotNull CommitInfo commitInfo) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)commitInfo, (String)"commitInfo");
        return TodoCheckinHandler.Companion.showDialog$intellij_platform_vcs_impl(project2, this.worker, commitInfo.getCommitActionText());
    }

    @Override
    @NotNull
    public String getShowDetailsAction() {
        String string2 = VcsBundle.message("todo.in.new.review.button", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"todo.in.new.review.button\")");
        return string2;
    }
}

