/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptorImpl;
import com.intellij.util.xml.highlighting.DomElementResolveProblemDescriptor;
import org.jetbrains.annotations.Nullable;

public final class DomElementsHighlightingUtil {
    private DomElementsHighlightingUtil() {
    }

    @Nullable
    public static ProblemDescriptor createProblemDescriptors(InspectionManager manager, DomElementProblemDescriptor problemDescriptor) {
        ProblemHighlightType type2 = DomElementsHighlightingUtil.getProblemHighlightType(problemDescriptor);
        return (ProblemDescriptor)DomElementsHighlightingUtil.createProblemDescriptors(problemDescriptor, s -> manager.createProblemDescriptor((PsiElement)s.second, (TextRange)s.first, problemDescriptor.getDescriptionTemplate(), type2, true, problemDescriptor.getFixes()));
    }

    private static ProblemHighlightType getProblemHighlightType(DomElementProblemDescriptor problemDescriptor) {
        TextRange range;
        if (problemDescriptor.getHighlightType() != null) {
            return problemDescriptor.getHighlightType();
        }
        if (problemDescriptor instanceof DomElementResolveProblemDescriptor && (range = ((DomElementResolveProblemDescriptor)problemDescriptor).getPsiReference().getRangeInElement()).getStartOffset() != range.getEndOffset()) {
            return ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
        }
        return ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
    }

    @Nullable
    public static <T> T createProblemDescriptors(DomElementProblemDescriptor problemDescriptor, Function<? super Pair<TextRange, PsiElement>, ? extends T> creator) {
        Pair<TextRange, PsiElement> range = ((DomElementProblemDescriptorImpl)problemDescriptor).getProblemRange();
        return (T)(range == DomElementProblemDescriptorImpl.NO_PROBLEM || !((PsiElement)range.second).isPhysical() ? null : creator.fun(range));
    }
}

