/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsLogCommitSelection;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogDiffHandler;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/vcs/log/ui/actions/CompareRevisionsFromLogAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.platform.vcs.log.impl"})
public final class CompareRevisionsFromLogAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        VcsLogCommitSelection selection = (VcsLogCommitSelection)e.getData(VcsLogDataKeys.VCS_LOG_COMMIT_SELECTION);
        VcsLogDiffHandler handler2 = (VcsLogDiffHandler)e.getData(VcsLogInternalDataKeys.LOG_DIFF_HANDLER);
        if (selection == null || handler2 == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        List<CommitId> commits2 = selection.getCommits();
        e.getPresentation().setVisible(commits2.size() == 2);
        e.getPresentation().setEnabled(commits2.size() == 2 && Intrinsics.areEqual((Object)((CommitId)CollectionsKt.first(commits2)).getRoot(), (Object)((CommitId)CollectionsKt.last(commits2)).getRoot()));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object object = e.getRequiredData(VcsLogDataKeys.VCS_LOG_COMMIT_SELECTION);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.getRequiredData(VcsLog\u2026VCS_LOG_COMMIT_SELECTION)");
        VcsLogCommitSelection selection = (VcsLogCommitSelection)object;
        Object object2 = e.getRequiredData(VcsLogInternalDataKeys.LOG_DIFF_HANDLER);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"e.getRequiredData(VcsLog\u2026ataKeys.LOG_DIFF_HANDLER)");
        VcsLogDiffHandler handler2 = (VcsLogDiffHandler)object2;
        VcsLogUsageTriggerCollector.triggerUsage(e, (Object)this);
        List<CommitId> commits2 = selection.getCommits();
        if (commits2.size() == 2) {
            VirtualFile virtualFile = ((CommitId)CollectionsKt.first(commits2)).getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"commits.first().root");
            VirtualFile root = virtualFile;
            handler2.showDiffForPaths(root, VcsLogUtil.getAffectedPaths(root, e), commits2.get(1).getHash(), commits2.get(0).getHash());
        }
    }
}

