/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.DataDerivType;
import com.thaiopensource.relaxng.impl.InconsistentDataDerivType;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternMemo;
import com.thaiopensource.relaxng.impl.ValidatorPatternBuilder;
import com.thaiopensource.relaxng.impl.ValueDataDerivType;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.ValidationContext;

class DataDataDerivType
extends DataDerivType {
    private final Datatype dt;
    private PatternMemo validMemo;
    private PatternMemo invalidMemo;

    DataDataDerivType(Datatype datatype) {
        this.dt = datatype;
    }

    PatternMemo dataDeriv(ValidatorPatternBuilder validatorPatternBuilder, Pattern pattern2, String string2, ValidationContext validationContext) {
        if (this.dt.isValid(string2, validationContext)) {
            if (this.validMemo == null) {
                this.validMemo = super.dataDeriv(validatorPatternBuilder, pattern2, string2, validationContext);
            }
            return this.validMemo;
        }
        if (this.invalidMemo == null) {
            this.invalidMemo = super.dataDeriv(validatorPatternBuilder, pattern2, string2, validationContext);
        }
        return this.invalidMemo;
    }

    DataDerivType copy() {
        return new DataDataDerivType(this.dt);
    }

    DataDerivType combine(DataDerivType dataDerivType) {
        if (dataDerivType instanceof DataDataDerivType) {
            if (((DataDataDerivType)dataDerivType).dt == this.dt) {
                return this;
            }
            return InconsistentDataDerivType.getInstance();
        }
        if (dataDerivType instanceof ValueDataDerivType) {
            if (((ValueDataDerivType)dataDerivType).getDatatype() == this.dt) {
                return dataDerivType;
            }
            return InconsistentDataDerivType.getInstance();
        }
        return dataDerivType.combine(this);
    }
}

