/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.xml.infer;

import com.thaiopensource.relaxng.output.common.Name;
import com.thaiopensource.xml.infer.ChoiceParticle;
import com.thaiopensource.xml.infer.DatatypeInferrer;
import com.thaiopensource.xml.infer.DatatypeRepertoire;
import com.thaiopensource.xml.infer.ElementDecl;
import com.thaiopensource.xml.infer.ElementDeclInferrer;
import com.thaiopensource.xml.infer.ElementParticle;
import com.thaiopensource.xml.infer.Particle;
import com.thaiopensource.xml.infer.Schema;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.relaxng.datatype.DatatypeLibraryFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class InferHandler
extends DefaultHandler {
    private final Map inferrerMap = new HashMap();
    private OpenElement openElement = null;
    private final Set startSet = new HashSet();
    private final List attributeNames = new Vector();
    private final DatatypeRepertoire datatypes;
    private final StringBuffer textBuffer = new StringBuffer();
    private final Set usedNamespaceUris = new HashSet();
    private final Schema schema = new Schema();
    private final Set assignedPrefixes = new HashSet();

    public void startElement(String string2, String string3, String string4, Attributes attributes) throws SAXException {
        Name name = this.makeName(string2, string3);
        if (this.openElement == null) {
            this.startSet.add(name);
        } else {
            if (this.textBuffer.length() > 0) {
                if (!DatatypeInferrer.isWhiteSpace(this.textBuffer.toString())) {
                    this.openElement.inferrer.addText();
                }
                this.textBuffer.setLength(0);
            }
            this.openElement.inferrer.addElement(name);
        }
        int n = 0;
        int n2 = attributes.getLength();
        while (n < n2) {
            this.attributeNames.add(this.makeName(attributes.getURI(n), attributes.getLocalName(n)));
            ++n;
        }
        ElementDeclInferrer elementDeclInferrer = (ElementDeclInferrer)this.inferrerMap.get(name);
        if (elementDeclInferrer == null) {
            elementDeclInferrer = new ElementDeclInferrer(this.datatypes, this.attributeNames);
            this.inferrerMap.put(name, elementDeclInferrer);
        } else {
            elementDeclInferrer.addAttributeNames(this.attributeNames);
        }
        int n3 = 0;
        int n4 = attributes.getLength();
        while (n3 < n4) {
            elementDeclInferrer.addAttributeValue((Name)this.attributeNames.get(n3), attributes.getValue(n3));
            ++n3;
        }
        this.attributeNames.clear();
        this.openElement = new OpenElement(this.openElement, elementDeclInferrer);
    }

    public void startPrefixMapping(String string2, String string3) throws SAXException {
        if (string2 != null && !string2.equals("") && this.schema.getPrefixMap().get(string3) == null && !this.assignedPrefixes.contains(string2)) {
            this.assignedPrefixes.add(string2);
            this.schema.getPrefixMap().put(string3, string2);
        }
    }

    private Name makeName(String string2, String string3) {
        if (!string2.equals("")) {
            this.usedNamespaceUris.add(string2);
        }
        return new Name(string2, string3);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.openElement.inferrer.wantValue()) {
            this.textBuffer.append(cArray, n, n2);
        } else {
            int n3 = 0;
            while (n3 < n2) {
                switch (cArray[n + n3]) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        this.openElement.inferrer.addText();
                        return;
                    }
                }
                ++n3;
            }
        }
    }

    public void endElement(String string2, String string3, String string4) throws SAXException {
        if (this.openElement.inferrer.wantValue()) {
            this.openElement.inferrer.addValue(this.textBuffer.toString());
            this.textBuffer.setLength(0);
        } else {
            this.openElement.inferrer.endSequence();
        }
        this.openElement = this.openElement.parent;
    }

    public Schema getSchema() {
        Iterator iterator = this.inferrerMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry2 = iterator.next();
            ElementDecl elementDecl = ((ElementDeclInferrer)entry2.getValue()).infer();
            Name name = (Name)entry2.getKey();
            this.schema.getElementDecls().put(name, elementDecl);
        }
        this.schema.setStart(this.makeStart());
        this.schema.getPrefixMap().keySet().retainAll(this.usedNamespaceUris);
        return this.schema;
    }

    private Particle makeStart() {
        Particle particle = null;
        Iterator iterator = this.startSet.iterator();
        while (iterator.hasNext()) {
            ElementParticle elementParticle = new ElementParticle((Name)iterator.next());
            particle = particle == null ? elementParticle : new ChoiceParticle(particle, elementParticle);
        }
        return particle;
    }

    public InferHandler(DatatypeLibraryFactory datatypeLibraryFactory) {
        this.datatypes = new DatatypeRepertoire(datatypeLibraryFactory);
    }

    private static class OpenElement {
        final OpenElement parent;
        final ElementDeclInferrer inferrer;

        public OpenElement(OpenElement openElement, ElementDeclInferrer elementDeclInferrer) {
            this.parent = openElement;
            this.inferrer = elementDeclInferrer;
        }
    }
}

