/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.DaemonFusReporter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/performancePlugin/commands/WaitForFinishedCodeAnalysis;", "Lcom/intellij/openapi/ui/playback/commands/AbstractCommand;", "text", "", "line", "", "(Ljava/lang/String;I)V", "_execute", "Lorg/jetbrains/concurrency/Promise;", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "checkCondition", "Ljava/util/concurrent/CountDownLatch;", "function", "Ljava/util/function/BooleanSupplier;", "Companion", "intellij.performanceTesting"})
public final class WaitForFinishedCodeAnalysis
extends AbstractCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PREFIX = "%waitForFinishedCodeAnalysis";
    @NotNull
    private static final Logger LOG;

    public WaitForFinishedCodeAnalysis(@NotNull String text, int line) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text, line);
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"context.project");
        Project project2 = project;
        SimpleMessageBusConnection connection = project2.getMessageBus().simpleConnect();
        Ref dateTimeWhenCodeAnalysisFinished = new Ref();
        LOG.info("Subscribing");
        Ref wasEntireFileHighlighted = new Ref((Object)false);
        Topic topic = DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"DAEMON_EVENT_TOPIC");
        connection.subscribe(topic, (Object)new DaemonFusReporter(project2, (Ref<Boolean>)wasEntireFileHighlighted, (Ref<LocalDateTime>)dateTimeWhenCodeAnalysisFinished){
            final /* synthetic */ Project $project;
            final /* synthetic */ Ref<Boolean> $wasEntireFileHighlighted;
            final /* synthetic */ Ref<LocalDateTime> $dateTimeWhenCodeAnalysisFinished;
            {
                this.$project = $project;
                this.$wasEntireFileHighlighted = $wasEntireFileHighlighted;
                this.$dateTimeWhenCodeAnalysisFinished = $dateTimeWhenCodeAnalysisFinished;
                super($project);
            }

            /*
             * WARNING - void declaration
             */
            public void daemonFinished(@NotNull Collection<? extends FileEditor> fileEditors) {
                void $this$filterIsInstanceTo$iv$iv;
                Intrinsics.checkNotNullParameter(fileEditors, (String)"fileEditors");
                Iterable $this$filterIsInstance$iv = fileEditors;
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterIsInstanceTo = false;
                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof TextEditor)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                TextEditor textEditor = (TextEditor)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
                if (textEditor == null) {
                    return;
                }
                TextEditor editor = textEditor;
                boolean entireFileHighlighted = DaemonCodeAnalyzerImpl.isHighlightingCompleted((FileEditor)((FileEditor)editor), (Project)this.$project);
                if (!this.getCanceled()) {
                    this.$wasEntireFileHighlighted.set((Object)entireFileHighlighted);
                }
                Object object = this.$wasEntireFileHighlighted.get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"wasEntireFileHighlighted.get()");
                if (((Boolean)object).booleanValue()) {
                    this.$dateTimeWhenCodeAnalysisFinished.set((Object)LocalDateTime.now());
                }
            }
        });
        ApplicationManager.getApplication().executeOnPooledThread(() -> WaitForFinishedCodeAnalysis._execute$lambda$1(this, connection, dateTimeWhenCodeAnalysisFinished, actionCallback, wasEntireFileHighlighted));
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    @NotNull
    public final CountDownLatch checkCondition(@NotNull BooleanSupplier function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        CountDownLatch latch = new CountDownLatch(1);
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = ConcurrencyUtil.newSingleScheduledThreadExecutor((String)"Performance plugin waiter");
        Intrinsics.checkNotNullExpressionValue((Object)scheduledThreadPoolExecutor, (String)"newSingleScheduledThread\u2026rformance plugin waiter\")");
        ScheduledExecutorService executor = scheduledThreadPoolExecutor;
        executor.scheduleWithFixedDelay(() -> WaitForFinishedCodeAnalysis.checkCondition$lambda$2(function, latch, executor), 0L, 5L, TimeUnit.SECONDS);
        return latch;
    }

    private static final boolean _execute$lambda$1$lambda$0(Ref $wasEntireFileHighlighted) {
        Intrinsics.checkNotNullParameter((Object)$wasEntireFileHighlighted, (String)"$wasEntireFileHighlighted");
        Object object = $wasEntireFileHighlighted.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"wasEntireFileHighlighted.get()");
        return (Boolean)object;
    }

    private static final void _execute$lambda$1(WaitForFinishedCodeAnalysis this$0, SimpleMessageBusConnection $connection, Ref $dateTimeWhenCodeAnalysisFinished, ActionCallbackProfilerStopper $actionCallback, Ref $wasEntireFileHighlighted) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$connection, (String)"$connection");
        Intrinsics.checkNotNullParameter((Object)$dateTimeWhenCodeAnalysisFinished, (String)"$dateTimeWhenCodeAnalysisFinished");
        Intrinsics.checkNotNullParameter((Object)((Object)$actionCallback), (String)"$actionCallback");
        Intrinsics.checkNotNullParameter((Object)$wasEntireFileHighlighted, (String)"$wasEntireFileHighlighted");
        this$0.checkCondition(() -> WaitForFinishedCodeAnalysis._execute$lambda$1$lambda$0($wasEntireFileHighlighted)).await(20L, TimeUnit.MINUTES);
        $connection.disconnect();
        String[] stringArray = new String[]{"idea.log"};
        Path path = Paths.get(PathManager.getLogPath(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(PathManager.getLogPath(), \"idea.log\")");
        Path path2 = path;
        List<String> list = Files.readAllLines(path2, Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(this, charset)");
        String rowFirstDateTimeFromLog = ((Object)StringsKt.trim((CharSequence)StringsKt.replace$default((String)StringsKt.substringBefore$default((String)((String)CollectionsKt.first(list)), (String)"[", null, (int)2, null), (String)",", (String)".", (boolean)false, (int)4, null))).toString();
        LocalDateTime dateTimeWhenAppStarted = LocalDateTime.parse(rowFirstDateTimeFromLog, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS"));
        LOG.info("Total opening time is : " + ChronoUnit.MILLIS.between(dateTimeWhenAppStarted, (Temporal)$dateTimeWhenCodeAnalysisFinished.get()));
        $actionCallback.setDone();
    }

    private static final void checkCondition$lambda$2(BooleanSupplier $function, CountDownLatch $latch, ScheduledExecutorService $executor) {
        Intrinsics.checkNotNullParameter((Object)$function, (String)"$function");
        Intrinsics.checkNotNullParameter((Object)$latch, (String)"$latch");
        Intrinsics.checkNotNullParameter((Object)$executor, (String)"$executor");
        if ($function.getAsBoolean()) {
            $latch.countDown();
            $executor.shutdown();
        }
    }

    static {
        Logger logger = Logger.getInstance(WaitForFinishedCodeAnalysis.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(WaitForFinis\u2026CodeAnalysis::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/performancePlugin/commands/WaitForFinishedCodeAnalysis$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "PREFIX", "", "intellij.performanceTesting"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

