/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.settingsSync.CloudConfigServerCommunicator;
import com.intellij.settingsSync.CloudConfigVersionContext;
import com.intellij.settingsSync.ServerState;
import com.intellij.settingsSync.SettingsSnapshot;
import com.intellij.settingsSync.SettingsSnapshotZipSerializer;
import com.intellij.settingsSync.SettingsSyncAuthException;
import com.intellij.settingsSync.SettingsSyncLocalSettings;
import com.intellij.settingsSync.SettingsSyncPushResult;
import com.intellij.settingsSync.SettingsSyncRemoteCommunicator;
import com.intellij.settingsSync.UpdateResult;
import com.intellij.settingsSync.auth.SettingsSyncAuthService;
import com.intellij.ui.JBAccountInfoService;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.PathKt;
import com.jetbrains.cloudconfig.CloudConfigFileClientV2;
import com.jetbrains.cloudconfig.Configuration;
import com.jetbrains.cloudconfig.ETagStorage;
import com.jetbrains.cloudconfig.FileVersionInfo;
import com.jetbrains.cloudconfig.HeaderStorage;
import com.jetbrains.cloudconfig.auth.AuthProvider;
import com.jetbrains.cloudconfig.auth.JbaTokenAuthProvider;
import com.jetbrains.cloudconfig.exception.InvalidVersionIdException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 22\u00020\u0001:\u00012B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fH\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fH\u0016J\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019J\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u001b2\u0006\u0010\u0013\u001a\u00020\fJ\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0013\u001a\u00020\fH\u0002J\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0013\u001a\u00020\fH\u0016J\"\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020!2\b\u0010'\u001a\u0004\u0018\u00010\fH\u0016J\u0018\u0010(\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0012\u0006\u0012\u0004\u0018\u00010\f0)H\u0002J\b\u0010*\u001a\u00020+H\u0016J\"\u0010,\u001a\u00020#2\u0006\u0010-\u001a\u00020\u00172\b\u0010.\u001a\u0004\u0018\u00010\f2\u0006\u0010&\u001a\u00020!H\u0002J7\u0010,\u001a\u00020#2\u0006\u0010-\u001a\u00020\u00172\b\u0010.\u001a\u0004\u0018\u00010\f2\u0006\u0010&\u001a\u00020!2\u0006\u0010/\u001a\u00020\n2\u0006\u00100\u001a\u00020\u0005H\u0001\u00a2\u0006\u0002\b1R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u00063"}, d2={"Lcom/intellij/settingsSync/CloudConfigServerCommunicator;", "Lcom/intellij/settingsSync/SettingsSyncRemoteCommunicator;", "()V", "_client", "Lkotlin/Lazy;", "Lcom/jetbrains/cloudconfig/CloudConfigFileClientV2;", "client", "getClient$intellij_settingsSync", "()Lcom/jetbrains/cloudconfig/CloudConfigFileClientV2;", "clientVersionContext", "Lcom/intellij/settingsSync/CloudConfigVersionContext;", "snapshotFilePath", "", "getSnapshotFilePath", "()Ljava/lang/String;", "checkServerState", "Lcom/intellij/settingsSync/ServerState;", "createFile", "", "filePath", "content", "deleteFile", "downloadSnapshot", "Ljava/io/InputStream;", "version", "Lcom/jetbrains/cloudconfig/FileVersionInfo;", "fetchHistory", "", "getLatestVersion", "handleRemoteError", "e", "", "isFileExists", "", "push", "Lcom/intellij/settingsSync/SettingsSyncPushResult;", "snapshot", "Lcom/intellij/settingsSync/SettingsSnapshot;", "force", "expectedServerVersionId", "receiveSnapshotFile", "Lkotlin/Pair;", "receiveUpdates", "Lcom/intellij/settingsSync/UpdateResult;", "sendSnapshotFile", "inputStream", "knownServerVersion", "versionContext", "cloudConfigClient", "sendSnapshotFile$intellij_settingsSync", "Companion", "intellij.settingsSync"})
@SourceDebugExtension(value={"SMAP\nCloudConfigServerCommunicator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CloudConfigServerCommunicator.kt\ncom/intellij/settingsSync/CloudConfigServerCommunicator\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,300:1\n10#2:301\n*S KotlinDebug\n*F\n+ 1 CloudConfigServerCommunicator.kt\ncom/intellij/settingsSync/CloudConfigServerCommunicator\n*L\n283#1:301\n*E\n"})
public final class CloudConfigServerCommunicator
implements SettingsSyncRemoteCommunicator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy<CloudConfigFileClientV2> _client = LazyKt.lazy((Function0)((Function0)new Function0<CloudConfigFileClientV2>(this){
        final /* synthetic */ CloudConfigServerCommunicator this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final CloudConfigFileClientV2 invoke() {
            return CloudConfigServerCommunicator.Companion.createCloudConfigClient$intellij_settingsSync(CloudConfigServerCommunicator.access$getClientVersionContext$p(this.this$0));
        }
    }));
    @NotNull
    private final CloudConfigVersionContext clientVersionContext = new CloudConfigVersionContext();
    @NotNull
    private static final String URL_PROVIDER = "https://www.jetbrains.com/config/IdeaCloudConfig.xml";
    @NotNull
    public static final String DEFAULT_PRODUCTION_URL = "https://cloudconfig.jetbrains.com/cloudconfig";
    @NotNull
    private static final String DEFAULT_DEBUG_URL = "https://stgn.cloudconfig.jetbrains.com/cloudconfig";
    @NotNull
    public static final String URL_PROPERTY = "idea.settings.sync.cloud.url";
    @NotNull
    private static final Lazy<String> _url = LazyKt.lazy((Function0)Companion._url.1.INSTANCE);
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final ETagStorage DUMMY_ETAG_STORAGE;

    private final String getSnapshotFilePath() {
        return Companion.getSnapshotFilePath$intellij_settingsSync();
    }

    @NotNull
    public final CloudConfigFileClientV2 getClient$intellij_settingsSync() {
        return (CloudConfigFileClientV2)this._client.getValue();
    }

    private final Pair<InputStream, String> receiveSnapshotFile() {
        return (Pair)this.clientVersionContext.doWithVersion(this.getSnapshotFilePath(), null, (Function1)new Function1<String, Pair<? extends InputStream, ? extends String>>(this){
            final /* synthetic */ CloudConfigServerCommunicator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Pair<InputStream, String> invoke(@NotNull String filePath) {
                Pair pair;
                Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
                try {
                    InputStream stream2 = this.this$0.getClient$intellij_settingsSync().read(filePath);
                    String actualVersion = CloudConfigServerCommunicator.access$getClientVersionContext$p(this.this$0).get(filePath);
                    if (actualVersion == null) {
                        CloudConfigServerCommunicator.access$getLOG$cp().warn("Version not stored in the context for " + filePath);
                    }
                    pair = new Pair((Object)stream2, (Object)actualVersion);
                }
                catch (FileNotFoundException fileNotFound) {
                    pair = new Pair(null, null);
                }
                return pair;
            }
        });
    }

    private final SettingsSyncPushResult sendSnapshotFile(InputStream inputStream, String knownServerVersion, boolean force) {
        return this.sendSnapshotFile$intellij_settingsSync(inputStream, knownServerVersion, force, this.clientVersionContext, this.getClient$intellij_settingsSync());
    }

    @VisibleForTesting
    @NotNull
    public final SettingsSyncPushResult sendSnapshotFile$intellij_settingsSync(@NotNull InputStream inputStream, @Nullable String knownServerVersion, boolean force, @NotNull CloudConfigVersionContext versionContext, @NotNull CloudConfigFileClientV2 cloudConfigClient) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)versionContext, (String)"versionContext");
        Intrinsics.checkNotNullParameter((Object)cloudConfigClient, (String)"cloudConfigClient");
        String versionToPush = null;
        if (force) {
            FileVersionInfo fileVersionInfo = this.getLatestVersion(this.getSnapshotFilePath());
            versionToPush = fileVersionInfo != null ? fileVersionInfo.getVersionId() : null;
        } else if (knownServerVersion != null) {
            versionToPush = knownServerVersion;
        } else {
            String serverVersion;
            FileVersionInfo fileVersionInfo = this.getLatestVersion(this.getSnapshotFilePath());
            String string = serverVersion = fileVersionInfo != null ? fileVersionInfo.getVersionId() : null;
            if (serverVersion == null) {
                versionToPush = null;
            } else {
                return SettingsSyncPushResult.Rejected.INSTANCE;
            }
        }
        String serverVersionId2 = (String)versionContext.doWithVersion(this.getSnapshotFilePath(), versionToPush, (Function1)new Function1<String, String>(cloudConfigClient, inputStream, versionContext){
            final /* synthetic */ CloudConfigFileClientV2 $cloudConfigClient;
            final /* synthetic */ InputStream $inputStream;
            final /* synthetic */ CloudConfigVersionContext $versionContext;
            {
                this.$cloudConfigClient = $cloudConfigClient;
                this.$inputStream = $inputStream;
                this.$versionContext = $versionContext;
                super(1);
            }

            @Nullable
            public final String invoke(@NotNull String filePath) {
                Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
                this.$cloudConfigClient.write(filePath, this.$inputStream);
                String actualVersion = this.$versionContext.get(filePath);
                if (actualVersion == null) {
                    CloudConfigServerCommunicator.access$getLOG$cp().warn("Version not stored in the context for " + filePath);
                }
                return actualVersion;
            }
        });
        return new SettingsSyncPushResult.Success(serverVersionId2);
    }

    @Override
    @NotNull
    public ServerState checkServerState() {
        try {
            String string;
            FileVersionInfo latestVersion = this.getClient$intellij_settingsSync().getLatestVersion(this.getSnapshotFilePath());
            LOG.debug("Latest version info: " + latestVersion);
            FileVersionInfo fileVersionInfo = latestVersion;
            String string2 = string = fileVersionInfo != null ? fileVersionInfo.getVersionId() : null;
            if (string == null) {
                return ServerState.FileNotExists.INSTANCE;
            }
            if (Intrinsics.areEqual((Object)string, (Object)SettingsSyncLocalSettings.Companion.getInstance().getKnownAndAppliedServerId())) {
                return ServerState.UpToDate.INSTANCE;
            }
            return ServerState.UpdateNeeded.INSTANCE;
        }
        catch (Throwable e) {
            String message = this.handleRemoteError(e);
            return new ServerState.Error(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public UpdateResult receiveUpdates() {
        LOG.info("Receiving settings snapshot from the cloud config server...");
        try {
            Pair<InputStream, String> pair = this.receiveSnapshotFile();
            InputStream stream2 = (InputStream)pair.component1();
            String version = (String)pair.component2();
            if (stream2 == null) {
                LOG.info(this.getSnapshotFilePath() + " not found on the server");
                return UpdateResult.NoFileOnServer.INSTANCE;
            }
            File file = FileUtil.createTempFile((String)"settings.sync.snapshot", (String)(UUID.randomUUID().toString() + ".zip"));
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(SETTINGS_\u2026ID().toString() + \".zip\")");
            File tempFile = file;
            try {
                FileUtil.writeToFile((File)tempFile, (byte[])stream2.readAllBytes());
                Path path = tempFile.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"tempFile.toPath()");
                SettingsSnapshot snapshot = SettingsSnapshotZipSerializer.INSTANCE.extractFromZip(path);
                UpdateResult updateResult = snapshot.isDeleted() ? (UpdateResult)UpdateResult.FileDeletedFromServer.INSTANCE : (UpdateResult)new UpdateResult.Success(snapshot, version);
                return updateResult;
            }
            finally {
                FileUtil.delete((File)tempFile);
            }
        }
        catch (Throwable e) {
            String message = this.handleRemoteError(e);
            return new UpdateResult.Error(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public SettingsSyncPushResult push(@NotNull SettingsSnapshot snapshot, boolean force, @Nullable String expectedServerVersionId) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        LOG.info("Pushing setting snapshot to the cloud config server...");
        try {
            object = SettingsSnapshotZipSerializer.INSTANCE.serializeToZip(snapshot);
        }
        catch (Throwable e) {
            LOG.warn(e);
            String string = e.getMessage();
            if (string == null) {
                string = "Couldn't prepare zip file";
            }
            return new SettingsSyncPushResult.Error(string);
        }
        Path zip = object;
        try {
            object = this.sendSnapshotFile(PathKt.inputStream((Path)zip), expectedServerVersionId, force);
            return object;
        }
        catch (InvalidVersionIdException ive) {
            LOG.info("Rejected: version doesn't match the version on server: " + ive.getMessage());
            SettingsSyncPushResult e = SettingsSyncPushResult.Rejected.INSTANCE;
            return e;
        }
        catch (Throwable e) {
            String message = this.handleRemoteError(e);
            SettingsSyncPushResult settingsSyncPushResult = new SettingsSyncPushResult.Error(message);
            return settingsSyncPushResult;
        }
        finally {
            try {
                PathKt.delete$default((Path)zip, (boolean)false, (int)1, null);
            }
            catch (Throwable e) {
                LOG.warn(e);
            }
        }
    }

    private final String handleRemoteError(Throwable e) {
        String defaultMessage = "Error during communication with server";
        if (e instanceof IOException) {
            LOG.warn(e);
            String string = e.getMessage();
            if (string == null) {
                string = defaultMessage;
            }
            return string;
        }
        LOG.error(e);
        return defaultMessage;
    }

    @Nullable
    public final InputStream downloadSnapshot(@NotNull String filePath, @NotNull FileVersionInfo version) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        InputStream stream2 = (InputStream)this.clientVersionContext.doWithVersion(filePath, version.getVersionId(), (Function1)new Function1<String, InputStream>(this){
            final /* synthetic */ CloudConfigServerCommunicator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final InputStream invoke(@NotNull String path) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                return this.this$0.getClient$intellij_settingsSync().read(path);
            }
        });
        if (stream2 == null) {
            LOG.info(this.getSnapshotFilePath() + " not found on the server");
        }
        return stream2;
    }

    @Override
    public void createFile(@NotNull String filePath, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        CloudConfigFileClientV2 cloudConfigFileClientV2 = this.getClient$intellij_settingsSync();
        String string = content;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        cloudConfigFileClientV2.write(filePath, (InputStream)new ByteArrayInputStream(byArray));
    }

    private final FileVersionInfo getLatestVersion(String filePath) {
        return this.getClient$intellij_settingsSync().getLatestVersion(filePath);
    }

    @Override
    public void deleteFile(@NotNull String filePath) throws IOException {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        SettingsSyncLocalSettings.Companion.getInstance().setKnownAndAppliedServerId(null);
        this.getClient$intellij_settingsSync().delete(filePath);
    }

    @Override
    public boolean isFileExists(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return this.getClient$intellij_settingsSync().getLatestVersion(filePath) != null;
    }

    @NotNull
    public final List<FileVersionInfo> fetchHistory(@NotNull String filePath) throws Exception {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        List list = this.getClient$intellij_settingsSync().getVersions(filePath);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"client.getVersions(filePath)");
        return list;
    }

    public static final /* synthetic */ CloudConfigVersionContext access$getClientVersionContext$p(CloudConfigServerCommunicator $this) {
        return $this.clientVersionContext;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CloudConfigServerCommunicator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
        DUMMY_ETAG_STORAGE = new ETagStorage(){

            @Nullable
            public String get(@NotNull String path) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                return null;
            }

            public void store(@NotNull String path, @NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            }

            public void remove(@Nullable String path) {
            }
        };
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0004H\u0002J\r\u0010\u0019\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b\u001aR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lcom/intellij/settingsSync/CloudConfigServerCommunicator$Companion;", "", "()V", "DEFAULT_DEBUG_URL", "", "DEFAULT_PRODUCTION_URL", "DUMMY_ETAG_STORAGE", "Lcom/jetbrains/cloudconfig/ETagStorage;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "URL_PROPERTY", "URL_PROVIDER", "_url", "Lkotlin/Lazy;", "url", "getUrl$intellij_settingsSync", "()Ljava/lang/String;", "createCloudConfigClient", "Lcom/jetbrains/cloudconfig/CloudConfigFileClientV2;", "versionContext", "Lcom/intellij/settingsSync/CloudConfigVersionContext;", "createCloudConfigClient$intellij_settingsSync", "createConfiguration", "Lcom/jetbrains/cloudconfig/Configuration;", "getProductionUrl", "getSnapshotFilePath", "getSnapshotFilePath$intellij_settingsSync", "intellij.settingsSync"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getUrl$intellij_settingsSync() {
            return (String)_url.getValue();
        }

        private final String getProductionUrl() {
            String configUrl = (String)HttpRequests.request((String)CloudConfigServerCommunicator.URL_PROVIDER).productNameAsUserAgent().connect(Companion::getProductionUrl$lambda$0, (Object)CloudConfigServerCommunicator.DEFAULT_PRODUCTION_URL, LOG);
            LOG.info("Using SettingSync server URL: " + configUrl);
            Intrinsics.checkNotNullExpressionValue((Object)configUrl, (String)"configUrl");
            return configUrl;
        }

        @NotNull
        public final CloudConfigFileClientV2 createCloudConfigClient$intellij_settingsSync(@NotNull CloudConfigVersionContext versionContext) {
            Intrinsics.checkNotNullParameter((Object)versionContext, (String)"versionContext");
            Configuration conf = this.createConfiguration();
            return new CloudConfigFileClientV2(this.getUrl$intellij_settingsSync(), conf, DUMMY_ETAG_STORAGE, (HeaderStorage)versionContext);
        }

        @VisibleForTesting
        @NotNull
        public final String getSnapshotFilePath$intellij_settingsSync() {
            Object object;
            if (SettingsSyncLocalSettings.Companion.getInstance().isCrossIdeSyncEnabled()) {
                object = "settings.sync.snapshot.zip";
            } else {
                String string = ApplicationNamesInfo.getInstance().getProductName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInstance().productName");
                String string2 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                object = string2 + "/settings.sync.snapshot.zip";
            }
            return object;
        }

        private final Configuration createConfiguration() {
            String userId;
            JBAccountInfoService.JBAData jBAData = SettingsSyncAuthService.Companion.getInstance().getUserData();
            String string = userId = jBAData != null ? jBAData.id : null;
            if (userId == null) {
                throw new SettingsSyncAuthException("Authentication required");
            }
            Configuration configuration = new Configuration().connectTimeout(10000).readTimeout(50000).auth((AuthProvider)new JbaTokenAuthProvider(userId));
            Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"Configuration().connectT\u2026okenAuthProvider(userId))");
            return configuration;
        }

        private static final String getProductionUrl$lambda$0(HttpRequests.Request request) {
            String string;
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            try {
                Element documentElement = JDOMUtil.load((InputStream)request.getInputStream());
                string = documentElement.getAttributeValue("baseUrl");
            }
            catch (JDOMException e) {
                throw new IOException(e);
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ String access$getProductionUrl(Companion $this) {
            return $this.getProductionUrl();
        }
    }
}

