/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.validation;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.psi.impl.XPathChangeUtil;
import org.intellij.plugins.xpathView.XPathBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ExpressionReplacementFix
implements IntentionAction {
    private final String myReplacement;
    private final String myDisplay;
    private final XPathExpression myExpr;

    ExpressionReplacementFix(String replacement, XPathExpression expr) {
        this(replacement, replacement, expr);
    }

    ExpressionReplacementFix(String replacement, String display, XPathExpression expression) {
        this.myReplacement = replacement;
        this.myDisplay = display;
        this.myExpr = expression;
    }

    @NotNull
    public String getText() {
        String string = XPathBundle.message("intention.name.replace.with.x", this.myDisplay);
        if (string == null) {
            ExpressionReplacementFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = XPathBundle.message("intention.family.name.replace.with.valid.xpath.expression", new Object[0]);
        if (string == null) {
            ExpressionReplacementFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            ExpressionReplacementFix.$$$reportNull$$$0(2);
        }
        return this.myExpr.isValid();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            ExpressionReplacementFix.$$$reportNull$$$0(3);
        }
        this.myExpr.replace(XPathChangeUtil.createExpression(this.myExpr, this.myReplacement));
    }

    public boolean startInWriteAction() {
        return true;
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        if (target == null) {
            ExpressionReplacementFix.$$$reportNull$$$0(4);
        }
        return new ExpressionReplacementFix(this.myReplacement, this.myDisplay, (XPathExpression)PsiTreeUtil.findSameElementInCopy((PsiElement)this.myExpr, (PsiFile)target));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/validation/ExpressionReplacementFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/validation/ExpressionReplacementFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFileModifierForPreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

