/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import jdk.internal.org.objectweb.asm.AnnotationVisitor;
import jdk.internal.org.objectweb.asm.ClassWriter;
import jdk.internal.org.objectweb.asm.Label;
import jdk.internal.org.objectweb.asm.MethodVisitor;
import jdk.internal.org.objectweb.asm.Type;
import jdk.internal.org.objectweb.asm.commons.GeneratorAdapter;
import jdk.internal.org.objectweb.asm.commons.Method;
import jdk.jfr.AnnotationElement;
import jdk.jfr.Event;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.internal.ASMToolkit;
import jdk.jfr.internal.SecuritySupport;

public final class EventClassBuilder {
    private static final Type TYPE_EVENT = Type.getType(Event.class);
    private static final Type TYPE_IOBE = Type.getType(IndexOutOfBoundsException.class);
    private static final Method DEFAULT_CONSTRUCTOR = Method.getMethod("void <init> ()");
    private static final Method SET_METHOD = Method.getMethod("void set (int, java.lang.Object)");
    private static final AtomicLong idCounter = new AtomicLong();
    private final ClassWriter classWriter = new ClassWriter(3);
    private final String fullClassName = "jdk.jfr.DynamicEvent" + idCounter.incrementAndGet();
    private final Type type = Type.getType(this.fullClassName.replace(".", "/"));
    private final List<ValueDescriptor> fields;
    private final List<AnnotationElement> annotationElements;

    public EventClassBuilder(List<AnnotationElement> list, List<ValueDescriptor> list2) {
        this.fields = list2;
        this.annotationElements = list;
    }

    public Class<? extends Event> build() {
        this.buildClassInfo();
        this.buildConstructor();
        this.buildFields();
        this.buildSetMethod();
        this.endClass();
        byte[] byArray = this.classWriter.toByteArray();
        ASMToolkit.logASM(this.fullClassName, byArray);
        return SecuritySupport.defineClass(this.type.getInternalName(), byArray, Event.class.getClassLoader()).asSubclass(Event.class);
    }

    private void endClass() {
        this.classWriter.visitEnd();
    }

    private void buildSetMethod() {
        GeneratorAdapter generatorAdapter = new GeneratorAdapter(1, SET_METHOD, null, null, this.classWriter);
        int n = 0;
        for (ValueDescriptor valueDescriptor : this.fields) {
            generatorAdapter.loadArg(0);
            generatorAdapter.visitLdcInsn(n);
            Label label = new Label();
            generatorAdapter.ifICmp(154, label);
            generatorAdapter.loadThis();
            generatorAdapter.loadArg(1);
            Type type = ASMToolkit.toType(valueDescriptor);
            generatorAdapter.unbox(ASMToolkit.toType(valueDescriptor));
            generatorAdapter.putField(this.type, valueDescriptor.getName(), type);
            generatorAdapter.visitInsn(177);
            generatorAdapter.visitLabel(label);
            ++n;
        }
        generatorAdapter.throwException(TYPE_IOBE, "Index must between 0 and " + this.fields.size());
        generatorAdapter.endMethod();
    }

    private void buildConstructor() {
        MethodVisitor methodVisitor = this.classWriter.visitMethod(1, DEFAULT_CONSTRUCTOR.getName(), DEFAULT_CONSTRUCTOR.getDescriptor(), null, null);
        methodVisitor.visitIntInsn(25, 0);
        ASMToolkit.invokeSpecial(methodVisitor, TYPE_EVENT.getInternalName(), DEFAULT_CONSTRUCTOR);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
    }

    private void buildClassInfo() {
        String string = ASMToolkit.getInternalName(Event.class.getName());
        String string2 = this.type.getInternalName();
        this.classWriter.visit(52, 49, string2, null, string, null);
        for (AnnotationElement annotationElement : this.annotationElements) {
            String string3 = ASMToolkit.getDescriptor(annotationElement.getTypeName());
            AnnotationVisitor annotationVisitor = this.classWriter.visitAnnotation(string3, true);
            for (ValueDescriptor valueDescriptor : annotationElement.getValueDescriptors()) {
                Object object = annotationElement.getValue(valueDescriptor.getName());
                String string4 = valueDescriptor.getName();
                if (valueDescriptor.isArray()) {
                    AnnotationVisitor annotationVisitor2 = annotationVisitor.visitArray(string4);
                    Object[] objectArray = (Object[])object;
                    for (int i = 0; i < objectArray.length; ++i) {
                        annotationVisitor2.visit(null, objectArray[i]);
                    }
                    annotationVisitor2.visitEnd();
                    continue;
                }
                annotationVisitor.visit(string4, object);
            }
            annotationVisitor.visitEnd();
        }
    }

    private void buildFields() {
        for (ValueDescriptor valueDescriptor : this.fields) {
            String string = ASMToolkit.getDescriptor(valueDescriptor.getTypeName());
            this.classWriter.visitField(2, valueDescriptor.getName(), string, null, null);
        }
    }
}

