/*
 * Copyright (c) 2012, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.hi;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_hi extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Moscow = new String[] {
               "\u092e\u0949\u0938\u094d\u0915\u094b \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "MST",
               "\u092e\u0949\u0938\u094d\u0915\u094b \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "MST",
               "\u092e\u0949\u0938\u094d\u0915\u094b \u0938\u092e\u092f",
               "MT",
            };
        final String[] Argentina = new String[] {
               "\u0905\u0930\u094d\u091c\u0947\u0902\u091f\u0940\u0928\u093e \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "AST",
               "\u0905\u0930\u094d\u091c\u0947\u0902\u091f\u0940\u0928\u093e \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "AST",
               "\u0905\u0930\u094d\u091c\u0947\u0902\u091f\u0940\u0928\u093e \u0938\u092e\u092f",
               "AT",
            };
        final String[] Hovd = new String[] {
               "\u0939\u0949\u0921 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "HST",
               "\u0939\u0949\u0921 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "HST",
               "\u0939\u0949\u0921 \u0938\u092e\u092f",
               "HT",
            };
        final String[] Magadan = new String[] {
               "\u092e\u0948\u0917\u093e\u0921\u0928 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "MST",
               "\u092e\u0948\u0917\u093e\u0921\u0928 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "MST",
               "\u092e\u0948\u0917\u093e\u0921\u0928 \u0938\u092e\u092f",
               "MT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "\u0911\u0938\u094d\u200d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e\u0908 \u0915\u0947\u0902\u0926\u094d\u0930\u0940\u092f \u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "ACWST",
               "\u0911\u0938\u094d\u200d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e\u0908 \u0915\u0947\u0902\u0926\u094d\u0930\u0940\u092f \u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0926\u093f\u0935\u093e\u0935\u0932\u094b\u0915 \u0938\u092e\u092f",
               "ACWDT",
               "\u0911\u0938\u094d\u200d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e\u0908 \u0915\u0947\u0902\u0926\u094d\u0930\u0940\u092f \u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0938\u092e\u092f",
               "ACWT",
            };
        final String[] Sakhalin = new String[] {
               "\u0938\u0916\u093c\u093e\u0932\u093f\u0928 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "SST",
               "\u0938\u0916\u093c\u093e\u0932\u093f\u0928 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "SST",
               "\u0938\u0916\u093c\u093e\u0932\u093f\u0928 \u0938\u092e\u092f",
               "ST",
            };
        final String[] Macquarie = new String[] {
               "\u092e\u0948\u0915\u094d\u0935\u0930\u0940 \u0938\u092e\u092f",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "Macquarie Island Time",
               "MIT",
            };
        final String[] America_Eastern = new String[] {
               "\u092a\u0942\u0930\u094d\u0935\u0940 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "EST",
               "\u092a\u0942\u0930\u094d\u0935\u0940 \u0926\u093f\u0935\u093e\u0935\u0932\u094b\u0915 \u0938\u092e\u092f",
               "EDT",
               "\u092a\u0942\u0930\u094d\u0935\u0940 \u0938\u092e\u092f",
               "ET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "\u0939\u0935\u093e\u0908 \u090f\u0932\u094d\u092f\u0941\u0936\u093f\u092f\u0928 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "HAST",
               "\u0939\u0935\u093e\u0908 \u090f\u0932\u094d\u092f\u0941\u0936\u093f\u092f\u0928 \u0926\u093f\u0935\u093e\u0935\u0932\u094b\u0915 \u0938\u092e\u092f",
               "HADT",
               "\u0939\u0935\u093e\u0908 \u090f\u0932\u094d\u092f\u0941\u0936\u093f\u092f\u0928 \u0938\u092e\u092f",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "\u0911\u0938\u094d\u200d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e\u0908 \u0915\u0947\u0902\u0926\u094d\u0930\u0940\u092f \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "ACST",
               "\u0911\u0938\u094d\u200d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e\u0908 \u0915\u0947\u0902\u0926\u094d\u0930\u0940\u092f \u0926\u093f\u0935\u093e\u0935\u0932\u094b\u0915 \u0938\u092e\u092f",
               "ACDT",
               "\u0915\u0947\u0902\u0926\u094d\u0930\u0940\u092f \u0911\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e\u0908 \u0938\u092e\u092f",
               "CAT",
            };
        final String[] Lord_Howe = new String[] {
               "\u0932\u0949\u0930\u094d\u0921 \u0939\u0949\u0935\u0947 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "LHST",
               "\u0932\u0949\u0930\u094d\u0921 \u0939\u0949\u0935\u0947 \u0926\u093f\u0935\u093e\u0935\u0932\u094b\u0915 \u0938\u092e\u092f",
               "LHDT",
               "\u0932\u0949\u0930\u094d\u0921 \u0939\u0949\u0935\u0947 \u0938\u092e\u092f",
               "LHT",
            };
        final String[] Yakutsk = new String[] {
               "\u092f\u093e\u0915\u0941\u0924\u094d\u0938\u094d\u0915 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "YST",
               "\u092f\u093e\u0915\u0941\u0924\u094d\u0938\u094d\u0915 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "YST",
               "\u092f\u093e\u0915\u0941\u0924\u094d\u0938\u094d\u0915 \u0938\u092e\u092f",
               "YT",
            };
        final String[] America_Pacific = new String[] {
               "\u092a\u094d\u0930\u0936\u093e\u0902\u0924 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "PST",
               "\u092a\u094d\u0930\u0936\u093e\u0902\u0924 \u0926\u093f\u0935\u093e\u0935\u0932\u094b\u0915 \u0938\u092e\u092f",
               "PDT",
               "\u092a\u094d\u0930\u0936\u093e\u0902\u0924 \u0938\u092e\u092f",
               "PT",
            };
        final String[] Newfoundland = new String[] {
               "\u0928\u094d\u092f\u0942\u092b\u093c\u093e\u0909\u0902\u0921\u0932\u0948\u0902\u0921 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "NST",
               "\u0928\u094d\u092f\u0942\u092b\u093c\u093e\u0909\u0902\u0921\u0932\u0948\u0902\u0921 \u0926\u093f\u0935\u093e\u0935\u0932\u094b\u0915 \u0938\u092e\u092f",
               "NDT",
               "\u0928\u094d\u092f\u0942\u092b\u093c\u093e\u0909\u0902\u0921\u0932\u0948\u0902\u0921 \u0938\u092e\u092f",
               "NT",
            };
        final String[] Argentina_Western = new String[] {
               "\u0905\u0930\u094d\u091c\u0947\u0902\u091f\u0940\u0928\u093e \u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "WAST",
               "\u0905\u0930\u094d\u091c\u0947\u0902\u091f\u0940\u0928\u093e \u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "WAST",
               "\u0905\u0930\u094d\u091c\u0947\u0902\u091f\u0940\u0928\u093e \u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0938\u092e\u092f",
               "WAT",
            };
        final String[] Atlantic = new String[] {
               "\u0905\u091f\u0932\u093e\u0902\u091f\u093f\u0915 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "AST",
               "\u0905\u091f\u0932\u093e\u0902\u091f\u093f\u0915 \u0926\u093f\u0935\u093e\u0935\u0932\u094b\u0915 \u0938\u092e\u092f",
               "ADT",
               "\u0905\u091f\u0932\u093e\u0902\u091f\u093f\u0915 \u0938\u092e\u092f",
               "AT",
            };
        final String[] Yekaterinburg = new String[] {
               "\u092f\u0947\u0915\u093e\u0924\u0947\u0930\u093f\u0928\u092c\u0930\u094d\u0917 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "YST",
               "\u092f\u0947\u0915\u093e\u0924\u0947\u0930\u093f\u0928\u092c\u0930\u094d\u0917 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "YST",
               "\u092f\u0947\u0915\u093e\u0924\u0947\u0930\u093f\u0928\u092c\u0930\u094d\u0917 \u0938\u092e\u092f",
               "YT",
            };
        final String[] Volgograd = new String[] {
               "\u0935\u094b\u0932\u094d\u0917\u094b\u0917\u094d\u0930\u093e\u0921 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "VST",
               "\u0935\u094b\u0932\u094d\u0917\u094b\u0917\u094d\u0930\u093e\u0921 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "VST",
               "\u0935\u094b\u0932\u094d\u0917\u094b\u0917\u094d\u0930\u093e\u0921 \u0938\u092e\u092f",
               "VT",
            };
        final String[] Indonesia_Central = new String[] {
               "\u0907\u0902\u0921\u094b\u0928\u0947\u0936\u093f\u092f\u093e\u0908 \u0915\u0947\u0902\u0926\u094d\u0930\u0940\u092f \u0938\u092e\u092f",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "CIT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "\u0907\u0902\u0921\u094b\u0928\u0947\u0936\u093f\u092f\u093e\u0908 \u092a\u0942\u0930\u094d\u0935\u0940 \u0938\u092e\u092f",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "Eastern Indonesia Time",
               "EIT",
            };
        final String[] Omsk = new String[] {
               "\u0913\u092e\u094d\u0938\u094d\u0915 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "OST",
               "\u0913\u092e\u094d\u0938\u094d\u0915 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "OST",
               "\u0913\u092e\u094d\u0938\u094d\u0915 \u0938\u092e\u092f",
               "OT",
            };
        final String[] Australia_Western = new String[] {
               "\u0911\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e\u0908 \u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "AWST",
               "\u0911\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e\u0908 \u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0926\u093f\u0935\u093e\u0935\u0932\u094b\u0915 \u0938\u092e\u092f",
               "AWDT",
               "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0911\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e\u0908 \u0938\u092e\u092f",
               "WAT",
            };
        final String[] Indonesia_Western = new String[] {
               "\u0907\u0902\u0921\u094b\u0928\u0947\u0936\u093f\u092f\u093e\u0908 \u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0938\u092e\u092f",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "Western Indonesia Time",
               "WIT",
            };
        final String[] Mongolia = new String[] {
               "\u0905\u0932\u0928 \u092c\u091f\u094b\u0930 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "UBST",
               "\u0905\u0932\u0928 \u092c\u091f\u094b\u0930 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "UBST",
               "\u0905\u0932\u0928 \u092c\u091f\u094b\u0930 \u0938\u092e\u092f",
               "UBT",
            };
        final String[] America_Central = new String[] {
               "\u0915\u0947\u0902\u0926\u094d\u0930\u0940\u092f \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "CST",
               "\u0915\u0947\u0902\u0926\u094d\u0930\u0940\u092f \u0926\u093f\u0935\u093e\u0935\u0932\u094b\u0915 \u0938\u092e\u092f",
               "CDT",
               "\u0915\u0947\u0902\u0926\u094d\u0930\u0940\u092f \u0938\u092e\u092f",
               "CT",
            };
        final String[] Australia_Eastern = new String[] {
               "\u0911\u0938\u094d\u200d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e\u0908 \u092a\u0942\u0930\u094d\u0935\u0940 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "AEST",
               "\u0911\u0938\u094d\u200d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e\u0908 \u092a\u0942\u0930\u094d\u0935\u0940 \u0926\u093f\u0935\u093e\u0935\u0932\u094b\u0915 \u0938\u092e\u092f",
               "AEDT",
               "\u092a\u0942\u0930\u094d\u0935\u0940 \u0911\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e\u0908 \u0938\u092e\u092f",
               "EAT",
            };
        final String[] America_Mountain = new String[] {
               "\u092e\u093e\u0909\u0902\u091f\u0947\u0928 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "MST",
               "\u092e\u093e\u0909\u0902\u091f\u0947\u0928 \u0926\u093f\u0935\u093e\u0935\u0932\u094b\u0915 \u0938\u092e\u092f",
               "MDT",
               "\u092e\u093e\u0909\u0902\u091f\u0947\u0928 \u0938\u092e\u092f",
               "MT",
            };
        final String[] Alaska = new String[] {
               "\u0905\u0932\u093e\u0938\u094d\u200d\u0915\u093e \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "AKST",
               "\u0905\u0932\u093e\u0938\u094d\u200d\u0915\u093e \u0926\u093f\u0935\u093e\u0935\u0932\u094b\u0915 \u0938\u092e\u092f",
               "AKDT",
               "\u0905\u0932\u093e\u0938\u094d\u0915\u093e \u0938\u092e\u092f",
               "AKT",
            };
        final String[] Novosibirsk = new String[] {
               "\u0928\u094b\u0935\u094b\u0938\u093f\u092c\u093f\u0930\u094d\u0938\u094d\u0915 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "NST",
               "\u0928\u094b\u0935\u094b\u0938\u093f\u092c\u093f\u0930\u094d\u0938\u094d\u0915 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "NST",
               "\u0928\u094b\u0935\u094b\u0938\u093f\u092c\u093f\u0930\u094d\u0938\u094d\u0915 \u0938\u092e\u092f",
               "NT",
            };
        final String[] Vladivostok = new String[] {
               "\u0935\u094d\u0932\u093e\u0926\u093f\u0935\u094b\u0938\u094d\u0924\u094b\u0915 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "VST",
               "\u0935\u094d\u0932\u093e\u0926\u093f\u0935\u094b\u0938\u094d\u0924\u094b\u0915 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "VST",
               "\u0935\u094d\u0932\u093e\u0926\u093f\u0935\u094b\u0938\u094d\u0924\u094b\u0915 \u0938\u092e\u092f",
               "VT",
            };
        final String[] Irkutsk = new String[] {
               "\u0907\u0930\u094d\u0915\u0941\u0924\u094d\u0938\u094d\u0915 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "IST",
               "\u0907\u0930\u094d\u0915\u0941\u0924\u094d\u0938\u094d\u0915 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "IST",
               "\u0907\u0930\u094d\u0915\u0941\u0924\u094d\u0938\u094d\u0915 \u0938\u092e\u092f",
               "IT",
            };
        final String[] Noronha = new String[] {
               "\u092b\u093c\u0930\u094d\u0928\u093e\u0930\u094d\u0921\u094b \u0921\u0947 \u0928\u094b\u0930\u094b\u0928\u094d\u0939\u093e \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "FNST",
               "\u092b\u093c\u0930\u094d\u0928\u093e\u0930\u094d\u0921\u094b \u0921\u0947 \u0928\u094b\u0930\u094b\u0928\u094d\u0939\u093e \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "FNST",
               "\u092b\u093c\u0930\u094d\u0928\u093e\u0930\u094d\u0921\u094b \u0921\u0947 \u0928\u094b\u0930\u094b\u0928\u094d\u0939\u093e \u0938\u092e\u0939",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "\u091a\u094c\u0907\u092c\u093e\u0932\u094d\u0938\u0928 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "CST",
               "\u091a\u094c\u0907\u092c\u093e\u0932\u094d\u0938\u0928 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "CST",
               "\u091a\u094c\u0907\u092c\u093e\u0932\u094d\u0938\u0928 \u0938\u092e\u092f",
               "CT",
            };
        final String[] Brasilia = new String[] {
               "\u092c\u094d\u0930\u093e\u091c\u0940\u0932\u093f\u092f\u093e \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "BST",
               "\u092c\u094d\u0930\u093e\u091c\u0940\u0932\u093f\u092f\u093e \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "BST",
               "\u092c\u094d\u0930\u093e\u091c\u0940\u0932\u093f\u092f\u093e \u0938\u092e\u092f",
               "BT",
            };
        final String[] Krasnoyarsk = new String[] {
               "\u0915\u094d\u0930\u093e\u0938\u094d\u0928\u094b\u092f\u093e\u0930\u094d\u0938\u094d\u0915 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "KST",
               "\u0915\u094d\u0930\u093e\u0938\u094d\u0928\u094b\u092f\u093e\u0930\u094d\u0938\u094d\u0915 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "KST",
               "\u0915\u094d\u0930\u093e\u0938\u094d\u0928\u094b\u092f\u093e\u0930\u094d\u0938\u094d\u0915 \u0938\u092e\u092f",
               "KT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "\u092a\u0936\u094d\u091a\u093f\u092e \u0915\u091c\u093c\u093e\u0915\u093c\u093f\u0938\u094d\u0924\u093e\u0928 \u0938\u092e\u092f",
               "WKT",
               "West Kazakhstan Summer Time",
               "WKST",
               "West Kazakhstan Time",
               "WKT",
            };
        final String[] India = new String[] {
               "\u092d\u093e\u0930\u0924\u0940\u092f \u0938\u092e\u092f",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Amazon = new String[] {
               "\u0906\u092e\u0947\u091c\u093c\u0928 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "AST",
               "\u0906\u092e\u0947\u091c\u093c\u0928 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "AST",
               "\u0906\u092e\u0947\u091c\u093c\u0928 \u0938\u092e\u092f",
               "AT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "\u092a\u0942\u0930\u094d\u0935 \u0915\u091c\u093c\u093e\u0915\u093c\u093f\u0938\u094d\u0924\u093e\u0928 \u0938\u092e\u092f",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "America/Cuiaba", Amazon },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "America/El_Salvador", America_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Asia/Pontianak", Indonesia_Western },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "America/Chihuahua", America_Central },
            { "America/Ojinaga", America_Central },
            { "Asia/Hovd", Hovd },
            { "America/Tegucigalpa", America_Central },
            { "America/Eirunepe", Amazon },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Grand_Turk", America_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Araguaina", Brasilia },
            { "America/Mexico_City", America_Central },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "Australia/Perth", Australia_Western },
            { "CST6CDT", America_Central },
            { "America/Manaus", Amazon },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Resolute", America_Central },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/Edmonton", America_Mountain },
            { "America/Catamarca", Argentina },
            { "America/Santo_Domingo", Atlantic },
            { "America/Glace_Bay", Atlantic },
            { "America/Cordoba", Argentina },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "America/St_Thomas", Atlantic },
            { "America/Anguilla", Atlantic },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", America_Mountain },
            { "America/Cancun", America_Central },
            { "Australia/Sydney", Australia_Eastern },
            { "America/St_Lucia", Atlantic },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "America/Santa_Isabel", America_Pacific },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Colombo", India },
            { "Asia/Omsk", Omsk },
            { "Australia/Brisbane", Australia_Eastern },
            { "America/Barbados", Atlantic },
            { "Europe/Volgograd", Volgograd },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "America/Rio_Branco", Amazon },
            { "America/Detroit", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Thule", Atlantic },
            { "America/Curacao", Atlantic },
            { "America/Martinique", Atlantic },
            { "Europe/Moscow", Moscow },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Tortola", Atlantic },
            { "Australia/Eucla", Australia_CentralWestern },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Port_of_Spain", Atlantic },
            { "Asia/Kamchatka", Magadan },
            { "America/Nome", Alaska },
            { "Asia/Yakutsk", Yakutsk },
            { "America/Rainy_River", America_Central },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Jakarta", Indonesia_Western },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "America/Jujuy", Argentina },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", America_Pacific },
            { "America/Pangnirtung", America_Eastern },
            { "America/Indiana/Vincennes", America_Eastern },
            { "America/Whitehorse", America_Pacific },
            { "America/Kralendijk", Atlantic },
            { "Europe/Samara", Moscow },
            { "America/Antigua", Atlantic },
            { "America/Montreal", America_Eastern },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/St_Vincent", Atlantic },
            { "PST8PDT", America_Pacific },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Asia/Calcutta", India },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Argentina/Tucuman", Argentina },
            { "Antarctica/Casey", Australia_Western },
            { "America/Merida", America_Central },
            { "America/Mazatlan", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Dominica", Atlantic },
            { "America/Guadeloupe", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "America/Shiprock", America_Mountain },
            { "America/Winnipeg", America_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/Maceio", Brasilia },
            { "Australia/Lord_Howe", Lord_Howe },
            { "America/Toronto", America_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
        };
        return data;
    }
}
