/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.CommonLogger;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.stack.NioTlsMessageChannel;
import gov.nist.javax.sip.stack.SIPStackTimerTask;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.TLSMessageChannel;
import java.io.IOException;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.security.cert.Certificate;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;

public class HandshakeCompletedListenerImpl
implements HandshakeCompletedListener {
    private static StackLogger logger = CommonLogger.getLogger(HandshakeCompletedListenerImpl.class);
    private HandshakeCompletedEvent handshakeCompletedEvent;
    private final Object eventWaitObject = new Object();
    private HandshakeWatchdog watchdog;
    private SIPTransactionStack sipStack;
    private Certificate[] peerCertificates;
    private Certificate[] localCertificates;
    private String cipherSuite;

    public HandshakeCompletedListenerImpl(TLSMessageChannel tlsMessageChannel, Socket socket) {
        tlsMessageChannel.setHandshakeCompletedListener(this);
        this.sipStack = tlsMessageChannel.getSIPStack();
        if (this.sipStack.getSslHandshakeTimeout() > 0L) {
            this.watchdog = new HandshakeWatchdog(socket);
        }
    }

    public HandshakeCompletedListenerImpl(NioTlsMessageChannel tlsMessageChannel, SocketChannel socket) {
        tlsMessageChannel.setHandshakeCompletedListener(this);
        this.sipStack = tlsMessageChannel.getSIPStack();
        if (this.sipStack.getSslHandshakeTimeout() > 0L) {
            this.watchdog = new HandshakeWatchdog(socket.socket());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
        if (this.watchdog != null) {
            this.sipStack.getTimer().cancel(this.watchdog);
            this.watchdog = null;
        }
        this.handshakeCompletedEvent = handshakeCompletedEvent;
        Object object = this.eventWaitObject;
        synchronized (object) {
            this.eventWaitObject.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HandshakeCompletedEvent getHandshakeCompletedEvent() {
        try {
            Object object = this.eventWaitObject;
            synchronized (object) {
                if (this.handshakeCompletedEvent == null) {
                    this.eventWaitObject.wait(5000L);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.handshakeCompletedEvent;
    }

    public void startHandshakeWatchdog() {
        if (this.watchdog != null) {
            logger.logInfo("starting watchdog for socket " + this.watchdog.socket + " on sslhandshake " + this.sipStack.getSslHandshakeTimeout());
            this.sipStack.getTimer().schedule(this.watchdog, this.sipStack.getSslHandshakeTimeout());
        }
    }

    public Certificate[] getPeerCertificates() {
        return this.peerCertificates;
    }

    public void setPeerCertificates(Certificate[] peerCertificates) {
        this.peerCertificates = peerCertificates;
    }

    public String getCipherSuite() {
        return this.cipherSuite;
    }

    public void setCipherSuite(String cipherSuite) {
        this.cipherSuite = cipherSuite;
    }

    public Certificate[] getLocalCertificates() {
        return this.localCertificates;
    }

    public void setLocalCertificates(Certificate[] localCertificates) {
        this.localCertificates = localCertificates;
    }

    class HandshakeWatchdog
    extends SIPStackTimerTask {
        Socket socket;

        private HandshakeWatchdog(Socket socket) {
            this.socket = socket;
        }

        @Override
        public void runTask() {
            logger.logInfo("closing socket " + this.socket + " on sslhandshaketimeout");
            try {
                this.socket.close();
            }
            catch (IOException ex) {
                logger.logInfo("couldn't close socket on sslhandshaketimeout");
            }
            logger.logInfo("socket closed " + this.socket + " on sslhandshaketimeout");
        }
    }
}

