/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.Breadcrumb;
import io.sentry.DiagnosticLogger;
import io.sentry.DuplicateEventDetectionEventProcessor;
import io.sentry.EnvelopeReader;
import io.sentry.EventProcessor;
import io.sentry.GsonSerializer;
import io.sentry.IEnvelopeReader;
import io.sentry.ILogger;
import io.sentry.IScopeObserver;
import io.sentry.ISentryExecutorService;
import io.sentry.ISerializer;
import io.sentry.ITransportFactory;
import io.sentry.Integration;
import io.sentry.MainEventProcessor;
import io.sentry.NoOpEnvelopeReader;
import io.sentry.NoOpLogger;
import io.sentry.NoOpSentryExecutorService;
import io.sentry.NoOpSerializer;
import io.sentry.NoOpTransportFactory;
import io.sentry.SamplingContext;
import io.sentry.SentryEvent;
import io.sentry.SentryExecutorService;
import io.sentry.SentryLevel;
import io.sentry.SentryRuntimeEventProcessor;
import io.sentry.ShutdownHookIntegration;
import io.sentry.UncaughtExceptionHandlerIntegration;
import io.sentry.cache.IEnvelopeCache;
import io.sentry.config.PropertiesProvider;
import io.sentry.protocol.SdkVersion;
import io.sentry.transport.ITransportGate;
import io.sentry.transport.NoOpEnvelopeCache;
import io.sentry.transport.NoOpTransportGate;
import io.sentry.util.Platform;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SentryOptions {
    static final SentryLevel DEFAULT_DIAGNOSTIC_LEVEL = SentryLevel.DEBUG;
    private static final String PROXY_PORT_DEFAULT = "80";
    @NotNull
    private final List<EventProcessor> eventProcessors = new CopyOnWriteArrayList<EventProcessor>();
    @NotNull
    private final Set<Class<? extends Throwable>> ignoredExceptionsForType = new CopyOnWriteArraySet<Class<? extends Throwable>>();
    @NotNull
    private final List<Integration> integrations = new CopyOnWriteArrayList<Integration>();
    @Nullable
    private String dsn;
    private long shutdownTimeout = 2000L;
    private long flushTimeoutMillis = 15000L;
    @Nullable
    private Boolean debug;
    private boolean enableNdk = true;
    @NotNull
    private ILogger logger = NoOpLogger.getInstance();
    @NotNull
    private SentryLevel diagnosticLevel = DEFAULT_DIAGNOSTIC_LEVEL;
    @NotNull
    private IEnvelopeReader envelopeReader = new EnvelopeReader();
    @NotNull
    private ISerializer serializer = new GsonSerializer(this);
    @Nullable
    private String sentryClientName;
    @Nullable
    private BeforeSendCallback beforeSend;
    @Nullable
    private BeforeBreadcrumbCallback beforeBreadcrumb;
    @Nullable
    private String cacheDirPath;
    private int maxCacheItems;
    private int maxQueueSize = this.maxCacheItems = 30;
    private int maxBreadcrumbs = 100;
    @Nullable
    private String release;
    @Nullable
    private String environment;
    @Nullable
    private Proxy proxy;
    @Nullable
    private Double sampleRate;
    @Nullable
    private Double tracesSampleRate;
    @Nullable
    private TracesSamplerCallback tracesSampler;
    @NotNull
    private final List<String> inAppExcludes = new CopyOnWriteArrayList<String>();
    @NotNull
    private final List<String> inAppIncludes = new CopyOnWriteArrayList<String>();
    @NotNull
    private ITransportFactory transportFactory = NoOpTransportFactory.getInstance();
    @NotNull
    private ITransportGate transportGate = NoOpTransportGate.getInstance();
    @Nullable
    private String dist;
    private boolean attachThreads;
    private boolean attachStacktrace = true;
    private boolean enableAutoSessionTracking = true;
    private long sessionTrackingIntervalMillis = 30000L;
    @Nullable
    private String distinctId;
    @Nullable
    private String serverName;
    private boolean attachServerName = true;
    @Nullable
    private Boolean enableUncaughtExceptionHandler = true;
    @NotNull
    private ISentryExecutorService executorService = NoOpSentryExecutorService.getInstance();
    private int connectionTimeoutMillis = 5000;
    private int readTimeoutMillis = 5000;
    @NotNull
    private IEnvelopeCache envelopeDiskCache = NoOpEnvelopeCache.getInstance();
    @Nullable
    private SdkVersion sdkVersion;
    private boolean sendDefaultPii = false;
    @Nullable
    private HostnameVerifier hostnameVerifier;
    @Nullable
    private SSLSocketFactory sslSocketFactory;
    @NotNull
    private final List<IScopeObserver> observers = new ArrayList<IScopeObserver>();
    private boolean enableScopeSync;
    private boolean enableExternalConfiguration;
    @NotNull
    private final @NotNull Map<String, @NotNull String> tags = new ConcurrentHashMap<String, String>();
    private long maxAttachmentSize = 0x1400000L;
    @Nullable
    private Boolean enableDeduplication = true;
    private int maxSpans = 1000;
    private boolean enableShutdownHook = true;
    @NotNull
    private RequestSize maxRequestBodySize = RequestSize.NONE;
    private boolean traceSampling;
    @NotNull
    private final List<String> tracingOrigins = new CopyOnWriteArrayList<String>();
    @Nullable
    private String proguardUuid;

    @NotNull
    public static SentryOptions from(@NotNull PropertiesProvider propertiesProvider, @NotNull ILogger logger) {
        SentryOptions options2 = new SentryOptions();
        options2.setDsn(propertiesProvider.getProperty("dsn"));
        options2.setEnvironment(propertiesProvider.getProperty("environment"));
        options2.setRelease(propertiesProvider.getProperty("release"));
        options2.setDist(propertiesProvider.getProperty("dist"));
        options2.setServerName(propertiesProvider.getProperty("servername"));
        options2.setEnableUncaughtExceptionHandler(propertiesProvider.getBooleanProperty("uncaught.handler.enabled"));
        options2.setTracesSampleRate(propertiesProvider.getDoubleProperty("traces-sample-rate"));
        options2.setDebug(propertiesProvider.getBooleanProperty("debug"));
        options2.setEnableDeduplication(propertiesProvider.getBooleanProperty("enable-deduplication"));
        String maxRequestBodySize = propertiesProvider.getProperty("max-request-body-size");
        if (maxRequestBodySize != null) {
            options2.setMaxRequestBodySize(RequestSize.valueOf(maxRequestBodySize.toUpperCase(Locale.ROOT)));
        }
        Map<String, String> tags = propertiesProvider.getMap("tags");
        for (Map.Entry<String, String> tag : tags.entrySet()) {
            options2.setTag(tag.getKey(), tag.getValue());
        }
        String proxyHost = propertiesProvider.getProperty("proxy.host");
        String proxyUser = propertiesProvider.getProperty("proxy.user");
        String proxyPass = propertiesProvider.getProperty("proxy.pass");
        String proxyPort = propertiesProvider.getProperty("proxy.port", PROXY_PORT_DEFAULT);
        if (proxyHost != null) {
            options2.setProxy(new Proxy(proxyHost, proxyPort, proxyUser, proxyPass));
        }
        for (String inAppInclude : propertiesProvider.getList("in-app-includes")) {
            options2.addInAppInclude(inAppInclude);
        }
        for (String inAppExclude : propertiesProvider.getList("in-app-excludes")) {
            options2.addInAppExclude(inAppExclude);
        }
        for (String tracingOrigin : propertiesProvider.getList("tracing-origins")) {
            options2.addTracingOrigin(tracingOrigin);
        }
        options2.setProguardUuid(propertiesProvider.getProperty("proguard-uuid"));
        for (String ignoredExceptionType : propertiesProvider.getList("ignored-exceptions-for-type")) {
            try {
                Class<?> clazz = Class.forName(ignoredExceptionType);
                if (Throwable.class.isAssignableFrom(clazz)) {
                    options2.addIgnoredExceptionForType(clazz);
                    continue;
                }
                logger.log(SentryLevel.WARNING, "Skipping setting %s as ignored-exception-for-type. Reason: %s does not extend Throwable", ignoredExceptionType, ignoredExceptionType);
            }
            catch (ClassNotFoundException e) {
                logger.log(SentryLevel.WARNING, "Skipping setting %s as ignored-exception-for-type. Reason: %s class is not found", ignoredExceptionType, ignoredExceptionType);
            }
        }
        return options2;
    }

    public void addEventProcessor(@NotNull EventProcessor eventProcessor) {
        this.eventProcessors.add(eventProcessor);
    }

    @NotNull
    public List<EventProcessor> getEventProcessors() {
        return this.eventProcessors;
    }

    public void addIntegration(@NotNull Integration integration) {
        this.integrations.add(integration);
    }

    @NotNull
    public List<Integration> getIntegrations() {
        return this.integrations;
    }

    @Nullable
    public String getDsn() {
        return this.dsn;
    }

    public void setDsn(@Nullable String dsn) {
        this.dsn = dsn;
    }

    public boolean isDebug() {
        return Boolean.TRUE.equals(this.debug);
    }

    public void setDebug(@Nullable Boolean debug) {
        this.debug = debug;
    }

    @Nullable
    private Boolean getDebug() {
        return this.debug;
    }

    @NotNull
    public ILogger getLogger() {
        return this.logger;
    }

    public void setLogger(@Nullable ILogger logger) {
        this.logger = logger == null ? NoOpLogger.getInstance() : new DiagnosticLogger(this, logger);
    }

    @NotNull
    public SentryLevel getDiagnosticLevel() {
        return this.diagnosticLevel;
    }

    public void setDiagnosticLevel(@Nullable SentryLevel diagnosticLevel) {
        this.diagnosticLevel = diagnosticLevel != null ? diagnosticLevel : DEFAULT_DIAGNOSTIC_LEVEL;
    }

    @NotNull
    public ISerializer getSerializer() {
        return this.serializer;
    }

    public void setSerializer(@Nullable ISerializer serializer) {
        this.serializer = serializer != null ? serializer : NoOpSerializer.getInstance();
    }

    @NotNull
    public IEnvelopeReader getEnvelopeReader() {
        return this.envelopeReader;
    }

    public void setEnvelopeReader(@Nullable IEnvelopeReader envelopeReader) {
        this.envelopeReader = envelopeReader != null ? envelopeReader : NoOpEnvelopeReader.getInstance();
    }

    public boolean isEnableNdk() {
        return this.enableNdk;
    }

    public void setEnableNdk(boolean enableNdk) {
        this.enableNdk = enableNdk;
    }

    public long getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    public void setShutdownTimeout(long shutdownTimeoutMillis) {
        this.shutdownTimeout = shutdownTimeoutMillis;
    }

    @Nullable
    public String getSentryClientName() {
        return this.sentryClientName;
    }

    public void setSentryClientName(@Nullable String sentryClientName) {
        this.sentryClientName = sentryClientName;
    }

    @Nullable
    public BeforeSendCallback getBeforeSend() {
        return this.beforeSend;
    }

    public void setBeforeSend(@Nullable BeforeSendCallback beforeSend) {
        this.beforeSend = beforeSend;
    }

    @Nullable
    public BeforeBreadcrumbCallback getBeforeBreadcrumb() {
        return this.beforeBreadcrumb;
    }

    public void setBeforeBreadcrumb(@Nullable BeforeBreadcrumbCallback beforeBreadcrumb) {
        this.beforeBreadcrumb = beforeBreadcrumb;
    }

    @Nullable
    public String getCacheDirPath() {
        return this.cacheDirPath;
    }

    @Nullable
    public String getOutboxPath() {
        if (this.cacheDirPath == null || this.cacheDirPath.isEmpty()) {
            return null;
        }
        return this.cacheDirPath + File.separator + "outbox";
    }

    public void setCacheDirPath(@Nullable String cacheDirPath) {
        this.cacheDirPath = cacheDirPath;
    }

    @Deprecated
    public int getCacheDirSize() {
        return this.maxCacheItems;
    }

    @Deprecated
    public void setCacheDirSize(int cacheDirSize) {
        this.maxCacheItems = cacheDirSize;
    }

    public int getMaxBreadcrumbs() {
        return this.maxBreadcrumbs;
    }

    public void setMaxBreadcrumbs(int maxBreadcrumbs) {
        this.maxBreadcrumbs = maxBreadcrumbs;
    }

    @Nullable
    public String getRelease() {
        return this.release;
    }

    public void setRelease(@Nullable String release) {
        this.release = release;
    }

    @Nullable
    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(@Nullable String environment) {
        this.environment = environment;
    }

    @Nullable
    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(@Nullable Proxy proxy) {
        this.proxy = proxy;
    }

    @Nullable
    public Double getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(Double sampleRate) {
        if (sampleRate != null && (sampleRate > 1.0 || sampleRate <= 0.0)) {
            throw new IllegalArgumentException("The value " + sampleRate + " is not valid. Use null to disable or values > 0.0 and <= 1.0.");
        }
        this.sampleRate = sampleRate;
    }

    @Nullable
    public Double getTracesSampleRate() {
        return this.tracesSampleRate;
    }

    public void setTracesSampleRate(@Nullable Double tracesSampleRate) {
        if (tracesSampleRate != null && (tracesSampleRate > 1.0 || tracesSampleRate < 0.0)) {
            throw new IllegalArgumentException("The value " + tracesSampleRate + " is not valid. Use null to disable or values between 0.0 and 1.0.");
        }
        this.tracesSampleRate = tracesSampleRate;
    }

    @Nullable
    public TracesSamplerCallback getTracesSampler() {
        return this.tracesSampler;
    }

    public void setTracesSampler(@Nullable TracesSamplerCallback tracesSampler) {
        this.tracesSampler = tracesSampler;
    }

    @NotNull
    public List<String> getInAppExcludes() {
        return this.inAppExcludes;
    }

    public void addInAppExclude(@NotNull String exclude) {
        this.inAppExcludes.add(exclude);
    }

    @NotNull
    public List<String> getInAppIncludes() {
        return this.inAppIncludes;
    }

    public void addInAppInclude(@NotNull String include) {
        this.inAppIncludes.add(include);
    }

    @NotNull
    public ITransportFactory getTransportFactory() {
        return this.transportFactory;
    }

    public void setTransportFactory(@Nullable ITransportFactory transportFactory) {
        this.transportFactory = transportFactory != null ? transportFactory : NoOpTransportFactory.getInstance();
    }

    @Nullable
    public String getDist() {
        return this.dist;
    }

    public void setDist(@Nullable String dist) {
        this.dist = dist;
    }

    @NotNull
    public ITransportGate getTransportGate() {
        return this.transportGate;
    }

    public void setTransportGate(@Nullable ITransportGate transportGate) {
        this.transportGate = transportGate != null ? transportGate : NoOpTransportGate.getInstance();
    }

    public boolean isAttachStacktrace() {
        return this.attachStacktrace;
    }

    public void setAttachStacktrace(boolean attachStacktrace) {
        this.attachStacktrace = attachStacktrace;
    }

    public boolean isAttachThreads() {
        return this.attachThreads;
    }

    public void setAttachThreads(boolean attachThreads) {
        this.attachThreads = attachThreads;
    }

    public boolean isEnableAutoSessionTracking() {
        return this.enableAutoSessionTracking;
    }

    public void setEnableAutoSessionTracking(boolean enableAutoSessionTracking) {
        this.enableAutoSessionTracking = enableAutoSessionTracking;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public boolean isEnableSessionTracking() {
        return this.enableAutoSessionTracking;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public void setEnableSessionTracking(boolean enableSessionTracking) {
        this.setEnableAutoSessionTracking(enableSessionTracking);
    }

    @Nullable
    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(@Nullable String serverName) {
        this.serverName = serverName;
    }

    public boolean isAttachServerName() {
        return this.attachServerName;
    }

    public void setAttachServerName(boolean attachServerName) {
        this.attachServerName = attachServerName;
    }

    public long getSessionTrackingIntervalMillis() {
        return this.sessionTrackingIntervalMillis;
    }

    public void setSessionTrackingIntervalMillis(long sessionTrackingIntervalMillis) {
        this.sessionTrackingIntervalMillis = sessionTrackingIntervalMillis;
    }

    @ApiStatus.Internal
    @Nullable
    public String getDistinctId() {
        return this.distinctId;
    }

    @ApiStatus.Internal
    public void setDistinctId(@Nullable String distinctId) {
        this.distinctId = distinctId;
    }

    public long getFlushTimeoutMillis() {
        return this.flushTimeoutMillis;
    }

    public void setFlushTimeoutMillis(long flushTimeoutMillis) {
        this.flushTimeoutMillis = flushTimeoutMillis;
    }

    public boolean isEnableUncaughtExceptionHandler() {
        return Boolean.TRUE.equals(this.enableUncaughtExceptionHandler);
    }

    @Nullable
    public Boolean getEnableUncaughtExceptionHandler() {
        return this.enableUncaughtExceptionHandler;
    }

    public void setEnableUncaughtExceptionHandler(@Nullable Boolean enableUncaughtExceptionHandler) {
        this.enableUncaughtExceptionHandler = enableUncaughtExceptionHandler;
    }

    @NotNull
    ISentryExecutorService getExecutorService() {
        return this.executorService;
    }

    void setExecutorService(@NotNull ISentryExecutorService executorService) {
        if (executorService != null) {
            this.executorService = executorService;
        }
    }

    public int getConnectionTimeoutMillis() {
        return this.connectionTimeoutMillis;
    }

    public void setConnectionTimeoutMillis(int connectionTimeoutMillis) {
        this.connectionTimeoutMillis = connectionTimeoutMillis;
    }

    public int getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    public void setReadTimeoutMillis(int readTimeoutMillis) {
        this.readTimeoutMillis = readTimeoutMillis;
    }

    @NotNull
    public IEnvelopeCache getEnvelopeDiskCache() {
        return this.envelopeDiskCache;
    }

    public void setEnvelopeDiskCache(@Nullable IEnvelopeCache envelopeDiskCache) {
        this.envelopeDiskCache = envelopeDiskCache != null ? envelopeDiskCache : NoOpEnvelopeCache.getInstance();
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setMaxQueueSize(int maxQueueSize) {
        if (maxQueueSize > 0) {
            this.maxQueueSize = maxQueueSize;
        }
    }

    @Nullable
    public SdkVersion getSdkVersion() {
        return this.sdkVersion;
    }

    @Nullable
    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public void setSslSocketFactory(@Nullable SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    @Nullable
    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(@Nullable HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    @ApiStatus.Internal
    public void setSdkVersion(@Nullable SdkVersion sdkVersion) {
        this.sdkVersion = sdkVersion;
    }

    public boolean isSendDefaultPii() {
        return this.sendDefaultPii;
    }

    public void setSendDefaultPii(boolean sendDefaultPii) {
        this.sendDefaultPii = sendDefaultPii;
    }

    public void addScopeObserver(@NotNull IScopeObserver observer) {
        this.observers.add(observer);
    }

    @NotNull
    List<IScopeObserver> getScopeObservers() {
        return this.observers;
    }

    public boolean isEnableScopeSync() {
        return this.enableScopeSync;
    }

    public void setEnableScopeSync(boolean enableScopeSync) {
        this.enableScopeSync = enableScopeSync;
    }

    public boolean isEnableExternalConfiguration() {
        return this.enableExternalConfiguration;
    }

    public void setEnableExternalConfiguration(boolean enableExternalConfiguration) {
        this.enableExternalConfiguration = enableExternalConfiguration;
    }

    @NotNull
    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTag(@NotNull String key, @NotNull String value2) {
        this.tags.put(key, value2);
    }

    public long getMaxAttachmentSize() {
        return this.maxAttachmentSize;
    }

    public void setMaxAttachmentSize(long maxAttachmentSize) {
        this.maxAttachmentSize = maxAttachmentSize;
    }

    public boolean isEnableDeduplication() {
        return Boolean.TRUE.equals(this.enableDeduplication);
    }

    @Nullable
    private Boolean getEnableDeduplication() {
        return this.enableDeduplication;
    }

    public void setEnableDeduplication(@Nullable Boolean enableDeduplication) {
        this.enableDeduplication = enableDeduplication;
    }

    public boolean isTracingEnabled() {
        return this.getTracesSampleRate() != null || this.getTracesSampler() != null;
    }

    @NotNull
    public Set<Class<? extends Throwable>> getIgnoredExceptionsForType() {
        return this.ignoredExceptionsForType;
    }

    public void addIgnoredExceptionForType(@NotNull Class<? extends Throwable> exceptionType) {
        this.ignoredExceptionsForType.add(exceptionType);
    }

    boolean containsIgnoredExceptionForType(@NotNull Throwable throwable) {
        return this.ignoredExceptionsForType.contains(throwable.getClass());
    }

    @ApiStatus.Experimental
    public int getMaxSpans() {
        return this.maxSpans;
    }

    @ApiStatus.Experimental
    public void setMaxSpans(int maxSpans) {
        this.maxSpans = maxSpans;
    }

    public boolean isEnableShutdownHook() {
        return this.enableShutdownHook;
    }

    public void setEnableShutdownHook(boolean enableShutdownHook) {
        this.enableShutdownHook = enableShutdownHook;
    }

    public int getMaxCacheItems() {
        return this.maxCacheItems;
    }

    public void setMaxCacheItems(int maxCacheItems) {
        this.maxCacheItems = maxCacheItems;
    }

    @NotNull
    public RequestSize getMaxRequestBodySize() {
        return this.maxRequestBodySize;
    }

    public void setMaxRequestBodySize(@NotNull RequestSize maxRequestBodySize) {
        this.maxRequestBodySize = maxRequestBodySize;
    }

    @ApiStatus.Experimental
    public boolean isTraceSampling() {
        return this.traceSampling;
    }

    @ApiStatus.Experimental
    public void setTraceSampling(boolean traceSampling) {
        this.traceSampling = traceSampling;
    }

    @NotNull
    public List<String> getTracingOrigins() {
        return this.tracingOrigins;
    }

    public void addTracingOrigin(@NotNull String tracingOrigin) {
        this.tracingOrigins.add(tracingOrigin);
    }

    @Nullable
    public String getProguardUuid() {
        return this.proguardUuid;
    }

    public void setProguardUuid(@Nullable String proguardUuid) {
        this.proguardUuid = proguardUuid;
    }

    @NotNull
    static SentryOptions empty() {
        return new SentryOptions(true);
    }

    public SentryOptions() {
        this(false);
    }

    private SentryOptions(boolean empty2) {
        if (!empty2) {
            this.executorService = new SentryExecutorService();
            this.integrations.add(new UncaughtExceptionHandlerIntegration());
            this.integrations.add(new ShutdownHookIntegration());
            this.eventProcessors.add(new MainEventProcessor(this));
            this.eventProcessors.add(new DuplicateEventDetectionEventProcessor(this));
            if (Platform.isJvm()) {
                this.eventProcessors.add(new SentryRuntimeEventProcessor());
            }
            this.setSentryClientName("sentry.java/5.3.0");
            this.setSdkVersion(this.createSdkVersion());
        }
    }

    void merge(@NotNull SentryOptions options2) {
        if (options2.getDsn() != null) {
            this.setDsn(options2.getDsn());
        }
        if (options2.getEnvironment() != null) {
            this.setEnvironment(options2.getEnvironment());
        }
        if (options2.getRelease() != null) {
            this.setRelease(options2.getRelease());
        }
        if (options2.getDist() != null) {
            this.setDist(options2.getDist());
        }
        if (options2.getServerName() != null) {
            this.setServerName(options2.getServerName());
        }
        if (options2.getProxy() != null) {
            this.setProxy(options2.getProxy());
        }
        if (options2.getEnableUncaughtExceptionHandler() != null) {
            this.setEnableUncaughtExceptionHandler(options2.getEnableUncaughtExceptionHandler());
        }
        if (options2.getTracesSampleRate() != null) {
            this.setTracesSampleRate(options2.getTracesSampleRate());
        }
        if (options2.getDebug() != null) {
            this.setDebug(options2.getDebug());
        }
        if (options2.getEnableDeduplication() != null) {
            this.setEnableDeduplication(options2.getEnableDeduplication());
        }
        HashMap<String, String> tags = new HashMap<String, String>(options2.getTags());
        for (Map.Entry entry : tags.entrySet()) {
            this.tags.put((String)entry.getKey(), (String)entry.getValue());
        }
        ArrayList<String> inAppIncludes = new ArrayList<String>(options2.getInAppIncludes());
        for (String string : inAppIncludes) {
            this.addInAppInclude(string);
        }
        ArrayList<String> arrayList = new ArrayList<String>(options2.getInAppExcludes());
        for (String inAppExclude : arrayList) {
            this.addInAppExclude(inAppExclude);
        }
        for (Class<? extends Throwable> exceptionType : new HashSet<Class<? extends Throwable>>(options2.getIgnoredExceptionsForType())) {
            this.addIgnoredExceptionForType(exceptionType);
        }
        ArrayList<String> arrayList2 = new ArrayList<String>(options2.getTracingOrigins());
        for (String tracingOrigin : arrayList2) {
            this.addTracingOrigin(tracingOrigin);
        }
        if (options2.getProguardUuid() != null) {
            this.setProguardUuid(options2.getProguardUuid());
        }
    }

    @NotNull
    private SdkVersion createSdkVersion() {
        String version2 = "5.3.0";
        SdkVersion sdkVersion = new SdkVersion("sentry.java", "5.3.0");
        sdkVersion.setVersion("5.3.0");
        sdkVersion.addPackage("maven:io.sentry:sentry", "5.3.0");
        return sdkVersion;
    }

    public static enum RequestSize {
        NONE,
        SMALL,
        MEDIUM,
        ALWAYS;

    }

    public static final class Proxy {
        @Nullable
        private String host;
        @Nullable
        private String port;
        @Nullable
        private String user;
        @Nullable
        private String pass;

        public Proxy(@Nullable String host, @Nullable String port2, @Nullable String user, @Nullable String pass) {
            this.host = host;
            this.port = port2;
            this.user = user;
            this.pass = pass;
        }

        public Proxy() {
            this(null, null, null, null);
        }

        public Proxy(@Nullable String host, @Nullable String port2) {
            this(host, port2, null, null);
        }

        @Nullable
        public String getHost() {
            return this.host;
        }

        public void setHost(@Nullable String host) {
            this.host = host;
        }

        @Nullable
        public String getPort() {
            return this.port;
        }

        public void setPort(@Nullable String port2) {
            this.port = port2;
        }

        @Nullable
        public String getUser() {
            return this.user;
        }

        public void setUser(@Nullable String user) {
            this.user = user;
        }

        @Nullable
        public String getPass() {
            return this.pass;
        }

        public void setPass(@Nullable String pass) {
            this.pass = pass;
        }
    }

    public static interface TracesSamplerCallback {
        @Nullable
        public Double sample(@NotNull SamplingContext var1);
    }

    public static interface BeforeBreadcrumbCallback {
        @Nullable
        public Breadcrumb execute(@NotNull Breadcrumb var1, @Nullable Object var2);
    }

    public static interface BeforeSendCallback {
        @Nullable
        public SentryEvent execute(@NotNull SentryEvent var1, @Nullable Object var2);
    }
}

