/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.attribute;

import java.net.Inet6Address;
import java.net.UnknownHostException;
import org.ice4j.StunException;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.attribute.Attribute;

abstract class AddressAttribute
extends Attribute {
    static final byte ADDRESS_FAMILY_IPV4 = 1;
    static final byte ADDRESS_FAMILY_IPV6 = 2;
    protected TransportAddress address = null;
    private static final char DATA_LENGTH_FOR_IPV6 = '\u0014';
    private static final char DATA_LENGTH_FOR_IPV4 = '\b';

    AddressAttribute(char attributeType) {
        super(attributeType);
    }

    private boolean isTypeValid(char type2) {
        return type2 == '\u0001' || type2 == '\u0002' || type2 == '\u0004' || type2 == '\u0005' || type2 == '\u000b' || type2 == ' ' || type2 == '\u8023' || type2 == '\u0012' || type2 == '\u0016' || type2 == '\u0011';
    }

    @Override
    protected void setAttributeType(char type2) {
        if (!this.isTypeValid(type2)) {
            throw new IllegalArgumentException(type2 + "is not a valid address attribute!");
        }
        super.setAttributeType(type2);
    }

    @Override
    public String getName() {
        switch (this.getAttributeType()) {
            case '\u0001': {
                return "MAPPED-ADDRESS";
            }
            case '\u0002': {
                return "RESPONSE-ADDRESS";
            }
            case '\u0004': {
                return "SOURCE-ADDRESS";
            }
            case '\u0005': {
                return "CHANGED-ADDRESS";
            }
            case '\u000b': {
                return "REFLECTED-FROM";
            }
            case ' ': {
                return "XOR-MAPPED-ADDRESS";
            }
            case '\u8023': {
                return "ALTERNATE-SERVER";
            }
            case '\u0012': {
                return "XOR-PEER-ADDRESS";
            }
            case '\u0016': {
                return "XOR-RELAYED-ADDRESS";
            }
        }
        return "UNKNOWN ATTRIBUTE";
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof AddressAttribute)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        AddressAttribute att = (AddressAttribute)obj;
        if (att.getAttributeType() != this.getAttributeType() || att.getDataLength() != this.getDataLength() || att.getFamily() != this.getFamily() || att.getAddress() != null && !this.address.equals(att.getAddress())) {
            return false;
        }
        if (att.getAddress() == null && this.getAddress() == null) {
            return true;
        }
        return true;
    }

    @Override
    public char getDataLength() {
        if (this.getFamily() == 2) {
            return '\u0014';
        }
        return '\b';
    }

    @Override
    public byte[] encode() {
        char type2 = this.getAttributeType();
        if (!this.isTypeValid(type2)) {
            throw new IllegalStateException(type2 + "is not a valid address attribute!");
        }
        byte[] binValue = new byte[4 + this.getDataLength()];
        binValue[0] = (byte)(type2 >> 8);
        binValue[1] = (byte)(type2 & 0xFF);
        binValue[2] = (byte)(this.getDataLength() >> 8);
        binValue[3] = (byte)(this.getDataLength() & 0xFF);
        binValue[4] = 0;
        binValue[5] = this.getFamily();
        binValue[6] = (byte)(this.getPort() >> 8);
        binValue[7] = (byte)(this.getPort() & 0xFF);
        if (this.getFamily() == 2) {
            System.arraycopy(this.getAddressBytes(), 0, binValue, 8, 16);
        } else {
            System.arraycopy(this.getAddressBytes(), 0, binValue, 8, 4);
        }
        return binValue;
    }

    public void setAddress(TransportAddress address) {
        this.address = address;
    }

    public TransportAddress getAddress() {
        return this.address;
    }

    public byte[] getAddressBytes() {
        return this.address.getAddressBytes();
    }

    public byte getFamily() {
        if (this.address.getAddress() instanceof Inet6Address) {
            return 2;
        }
        return 1;
    }

    public int getPort() {
        return this.address.getPort();
    }

    @Override
    void decodeAttributeBody(byte[] attributeValue, char offset, char length) throws StunException {
        char c = offset = (char)(offset + '\u0001');
        offset = (char)(offset + '\u0001');
        byte family = attributeValue[c];
        char c2 = offset;
        char c3 = offset = (char)(offset + '\u0001');
        offset = (char)(offset + '\u0001');
        char port2 = (char)(attributeValue[c2] << 8 | attributeValue[c3] & 0xFF);
        byte[] address = null;
        address = family == 2 ? new byte[16] : new byte[4];
        System.arraycopy(attributeValue, offset, address, 0, address.length);
        try {
            this.setAddress(new TransportAddress(address, (int)port2, Transport.UDP));
        }
        catch (UnknownHostException e) {
            throw new StunException(e);
        }
    }
}

