/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.stats;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.atomic.LongAdder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.stats.DelayStats;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.stats.BucketStats;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jitsi/nlj/stats/PacketDelayStats;", "Lorg/jitsi/nlj/stats/DelayStats;", "thresholds", "", "", "clock", "Ljava/time/Clock;", "(Ljava/util/List;Ljava/time/Clock;)V", "numPacketsWithoutTimestamps", "Ljava/util/concurrent/atomic/LongAdder;", "addPacket", "", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "toJson", "Lorg/jitsi/utils/OrderedJsonObject;", "format", "Lorg/jitsi/utils/stats/BucketStats$Format;", "jitsi-media-transform"})
public final class PacketDelayStats
extends DelayStats {
    @NotNull
    private final Clock clock;
    @NotNull
    private final LongAdder numPacketsWithoutTimestamps;

    public PacketDelayStats(@NotNull List<Long> thresholds, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(thresholds, "thresholds");
        Intrinsics.checkNotNullParameter(clock, "clock");
        super(thresholds);
        this.clock = clock;
        this.numPacketsWithoutTimestamps = new LongAdder();
    }

    public /* synthetic */ PacketDelayStats(List list, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = DelayStats.Companion.getDefaultThresholds();
        }
        if ((n & 2) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue(clock2, "systemUTC()");
            clock = clock2;
        }
        this(list, clock);
    }

    public final void addPacket(@NotNull PacketInfo packetInfo) {
        block2: {
            Unit unit;
            Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
            Instant instant = packetInfo.getReceivedTime();
            if (instant != null) {
                Instant it = instant;
                boolean bl = false;
                Duration duration = Duration.between(it, this.clock.instant());
                Intrinsics.checkNotNullExpressionValue(duration, "between(it, clock.instant())");
                this.addDelay(duration);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block2;
            PacketDelayStats $this$addPacket_u24lambda_u2d1 = this;
            boolean bl = false;
            $this$addPacket_u24lambda_u2d1.numPacketsWithoutTimestamps.increment();
        }
    }

    @Override
    @NotNull
    public OrderedJsonObject toJson(@NotNull BucketStats.Format format) {
        OrderedJsonObject orderedJsonObject;
        Intrinsics.checkNotNullParameter((Object)format, "format");
        OrderedJsonObject $this$toJson_u24lambda_u2d2 = orderedJsonObject = super.toJson(format);
        boolean bl = false;
        $this$toJson_u24lambda_u2d2.put("packets_without_timestamps", (Object)this.numPacketsWithoutTimestamps.sum());
        return orderedJsonObject;
    }

    public PacketDelayStats() {
        this(null, null, 3, null);
    }
}

