/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.transform.node.TransformerNode;
import org.jitsi.rtp.Packet;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0014R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jitsi/nlj/transform/node/PacketParser;", "Lorg/jitsi/nlj/transform/node/TransformerNode;", "name", "", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "action", "Lkotlin/Function1;", "Lorg/jitsi/rtp/Packet;", "(Ljava/lang/String;Lorg/jitsi/utils/logging2/Logger;Lkotlin/jvm/functions/Function1;)V", "logger", "trace", "", "f", "Lkotlin/Function0;", "transform", "Lorg/jitsi/nlj/PacketInfo;", "packetInfo", "jitsi-media-transform"})
public class PacketParser
extends TransformerNode {
    @NotNull
    private final Function1<Packet, Packet> action;
    @NotNull
    private final Logger logger;

    public PacketParser(@NotNull String name, @NotNull Logger parentLogger, @NotNull Function1<? super Packet, ? extends Packet> action) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        Intrinsics.checkNotNullParameter(action, "action");
        super(name);
        this.action = action;
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
    }

    @Override
    @Nullable
    protected PacketInfo transform(@NotNull PacketInfo packetInfo) {
        PacketInfo packetInfo2;
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        try {
            packetInfo.setPacket(this.action.invoke(packetInfo.getPacket()));
            packetInfo.resetPayloadVerification();
            packetInfo2 = packetInfo;
        }
        catch (Exception e) {
            this.logger.warn("Error parsing packet: " + e);
            packetInfo2 = null;
        }
        return packetInfo2;
    }

    @Override
    public void trace(@NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter(f, "f");
        f.invoke();
    }
}

