/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.rtcp.rtcpfb;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jitsi.rtp.extensions.bytearray.ByteArrayExtensionsKt;
import org.jitsi.rtp.extensions.unsigned.UnsignedKt;
import org.jitsi.rtp.rtcp.RtcpHeader;
import org.jitsi.rtp.rtcp.RtcpPacket;
import org.jitsi.rtp.rtcp.rtcpfb.UnsupportedRtcpFbPacket;
import org.jitsi.rtp.rtcp.rtcpfb.payload_specific_fb.RtcpFbFirPacket;
import org.jitsi.rtp.rtcp.rtcpfb.payload_specific_fb.RtcpFbPliPacket;
import org.jitsi.rtp.rtcp.rtcpfb.payload_specific_fb.RtcpFbRembPacket;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.RtcpFbNackPacket;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.tcc.RtcpFbTccPacket;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\b&\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007R$\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lorg/jitsi/rtp/rtcp/rtcpfb/RtcpFbPacket;", "Lorg/jitsi/rtp/rtcp/RtcpPacket;", "buffer", "", "offset", "", "length", "([BII)V", "value", "", "mediaSourceSsrc", "getMediaSourceSsrc", "()J", "setMediaSourceSsrc", "(J)V", "Companion", "rtp"})
public abstract class RtcpFbPacket
extends RtcpPacket {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<Integer> PACKET_TYPES;
    public static final int MEDIA_SOURCE_SSRC_OFFSET = 8;
    public static final int HEADER_SIZE = 12;
    public static final int FCI_OFFSET = 12;

    public RtcpFbPacket(@NotNull byte[] buffer, int offset, int length) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        super(buffer, offset, length);
    }

    public final long getMediaSourceSsrc() {
        Intrinsics.checkNotNullExpressionValue(this.buffer, "buffer");
        return Companion.getMediaSourceSsrc(this.buffer, this.offset);
    }

    public final void setMediaSourceSsrc(long value2) {
        Intrinsics.checkNotNullExpressionValue(this.buffer, "buffer");
        Companion.setMediaSourceSsrc(this.buffer, this.offset, value2);
    }

    static {
        Integer[] integerArray = new Integer[]{205, 206};
        PACKET_TYPES = CollectionsKt.listOf(integerArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lorg/jitsi/rtp/rtcp/rtcpfb/RtcpFbPacket$Companion;", "", "()V", "FCI_OFFSET", "", "HEADER_SIZE", "MEDIA_SOURCE_SSRC_OFFSET", "PACKET_TYPES", "", "getPACKET_TYPES", "()Ljava/util/List;", "getFmt", "buf", "", "baseOffset", "getMediaSourceSsrc", "", "parse", "Lorg/jitsi/rtp/rtcp/rtcpfb/RtcpFbPacket;", "offset", "length", "setMediaSourceSsrc", "", "value", "rtp"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Integer> getPACKET_TYPES() {
            return PACKET_TYPES;
        }

        public final int getFmt(@NotNull byte[] buf, int baseOffset) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            return RtcpHeader.Companion.getReportCount(buf, baseOffset);
        }

        public final long getMediaSourceSsrc(@NotNull byte[] buf, int baseOffset) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            return UnsignedKt.toPositiveLong(ByteArrayExtensionsKt.getInt(buf, baseOffset + 8));
        }

        public final void setMediaSourceSsrc(@NotNull byte[] buf, int baseOffset, long value2) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            ByteArrayExtensionsKt.putInt(buf, baseOffset + 8, (int)value2);
        }

        @NotNull
        public final RtcpFbPacket parse(@NotNull byte[] buf, int offset, int length) {
            RtcpFbPacket rtcpFbPacket;
            Intrinsics.checkNotNullParameter(buf, "buf");
            int packetType = RtcpHeader.Companion.getPacketType(buf, offset);
            int fmt = this.getFmt(buf, offset);
            block0 : switch (packetType) {
                case 205: {
                    switch (fmt) {
                        case 1: {
                            rtcpFbPacket = new RtcpFbNackPacket(buf, offset, length);
                            break block0;
                        }
                        case 15: {
                            rtcpFbPacket = new RtcpFbTccPacket(buf, offset, length);
                            break block0;
                        }
                    }
                    rtcpFbPacket = new UnsupportedRtcpFbPacket(buf, offset, length);
                    break;
                }
                case 206: {
                    switch (fmt) {
                        case 4: {
                            rtcpFbPacket = new RtcpFbFirPacket(buf, offset, length);
                            break block0;
                        }
                        case 1: {
                            rtcpFbPacket = new RtcpFbPliPacket(buf, offset, length);
                            break block0;
                        }
                        case 15: {
                            rtcpFbPacket = new RtcpFbRembPacket(buf, offset, length);
                            break block0;
                        }
                    }
                    rtcpFbPacket = new UnsupportedRtcpFbPacket(buf, offset, length);
                    break;
                }
                default: {
                    String string = Integer.toString(packetType, CharsKt.checkRadix(16));
                    Intrinsics.checkNotNullExpressionValue(string, "toString(this, checkRadix(radix))");
                    throw new Exception("Unrecognized RTCPFB payload type: " + string);
                }
            }
            return rtcpFbPacket;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

