/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.rtp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jitsi.rtp.extensions.bytearray.ByteArrayExtensionsKt;
import org.jitsi.rtp.extensions.unsigned.UnsignedKt;
import org.jitsi.rtp.rtp.header_extensions.HeaderExtensionHelpers;
import org.jitsi.rtp.util.FieldParsersKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/jitsi/rtp/rtp/RtpHeader;", "", "()V", "Companion", "rtp"})
public final class RtpHeader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int FIXED_HEADER_SIZE_BYTES = 12;
    public static final int CSRCS_OFFSET = 12;
    public static final int EXT_HEADER_SIZE_BYTES = 4;
    public static final int VERSION = 2;

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0013\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u0016\u0010\u000f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u0016\u0010\u0013\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u0016\u0010\u0014\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u0016\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u0016\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u0016\u0010\u0017\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u0016\u0010\u0018\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u0016\u0010\u0019\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u0016\u0010\u001a\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u001e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004J$\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u001e\u0010 \u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0012J\u001e\u0010\"\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0012J\u001e\u0010$\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0012J\u001e\u0010%\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004J\u001e\u0010'\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u0004J\u001e\u0010)\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u000eJ\u001e\u0010+\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010,\u001a\u00020\u000eJ\u001e\u0010-\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010.\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jitsi/rtp/rtp/RtpHeader$Companion;", "", "()V", "CSRCS_OFFSET", "", "EXT_HEADER_SIZE_BYTES", "FIXED_HEADER_SIZE_BYTES", "VERSION", "getCsrcCount", "buf", "", "baseOffset", "getCsrcs", "", "", "getExtensionsProfileType", "getFixedHeaderAndCcLength", "getMarker", "", "getPayloadType", "getSequenceNumber", "getSsrc", "getTimestamp", "getTotalLength", "getVersion", "hasExtensions", "hasPadding", "setCsrcCount", "", "csrcCount", "setCsrcs", "csrcs", "setHasExtensions", "hasExtension", "setMarker", "isSet", "setPadding", "setPayloadType", "payloadType", "setSequenceNumber", "sequenceNumber", "setSsrc", "ssrc", "setTimestamp", "timestamp", "setVersion", "version", "rtp"})
    public static final class Companion {
        private Companion() {
        }

        public final int getVersion(@NotNull byte[] buf, int baseOffset) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            return (buf[baseOffset] & 0xC0) >>> 6;
        }

        public final void setVersion(@NotNull byte[] buf, int baseOffset, int version2) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            buf[baseOffset] = (byte)(buf[baseOffset] & 0xFFFFFF3F | version2 << 6 & 0xC0);
        }

        public final boolean hasPadding(@NotNull byte[] buf, int baseOffset) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            return (buf[baseOffset] & 0x20) == 32;
        }

        public final void setPadding(@NotNull byte[] buf, int baseOffset, boolean hasPadding) {
            byte by;
            Intrinsics.checkNotNullParameter(buf, "buf");
            boolean bl = hasPadding;
            if (bl) {
                by = (byte)(buf[baseOffset] | 0x20);
            } else if (!bl) {
                by = (byte)(buf[baseOffset] & 0xFFFFFFDF);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            buf[baseOffset] = by;
        }

        public final boolean hasExtensions(@NotNull byte[] buf, int baseOffset) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            return (buf[baseOffset] & 0x10) == 16;
        }

        public final void setHasExtensions(@NotNull byte[] buf, int baseOffset, boolean hasExtension) {
            byte by;
            Intrinsics.checkNotNullParameter(buf, "buf");
            boolean bl = hasExtension;
            if (bl) {
                by = (byte)(buf[baseOffset] | 0x10);
            } else if (!bl) {
                by = (byte)(buf[baseOffset] & 0xFFFFFFEF);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            buf[baseOffset] = by;
        }

        public final int getCsrcCount(@NotNull byte[] buf, int baseOffset) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            return buf[baseOffset] & 0xF;
        }

        public final void setCsrcCount(@NotNull byte[] buf, int baseOffset, int csrcCount) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            buf[baseOffset] = (byte)(buf[baseOffset] & 0xF0 | csrcCount & 0xF);
        }

        public final boolean getMarker(@NotNull byte[] buf, int baseOffset) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            return (buf[baseOffset + 1] & 0x80) == 128;
        }

        public final void setMarker(@NotNull byte[] buf, int baseOffset, boolean isSet) {
            byte by;
            Intrinsics.checkNotNullParameter(buf, "buf");
            boolean bl = isSet;
            if (bl) {
                by = (byte)(buf[baseOffset + 1] | 0x80);
            } else if (!bl) {
                by = (byte)(buf[baseOffset + 1] & 0xFFFFFF7F);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            buf[baseOffset + 1] = by;
        }

        public final int getPayloadType(@NotNull byte[] buf, int baseOffset) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            return UnsignedKt.toPositiveInt(buf[baseOffset + 1] & 0x7F);
        }

        public final void setPayloadType(@NotNull byte[] buf, int baseOffset, int payloadType) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            buf[baseOffset + 1] = (byte)((byte)(buf[baseOffset + 1] & 0xFFFFFF80) | (byte)(payloadType & 0x7F));
        }

        public final int getSequenceNumber(@NotNull byte[] buf, int baseOffset) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            return FieldParsersKt.getShortAsInt(buf, baseOffset + 2);
        }

        public final void setSequenceNumber(@NotNull byte[] buf, int baseOffset, int sequenceNumber) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            ByteArrayExtensionsKt.putShort(buf, baseOffset + 2, (short)sequenceNumber);
        }

        public final long getTimestamp(@NotNull byte[] buf, int baseOffset) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            return FieldParsersKt.getIntAsLong(buf, baseOffset + 4);
        }

        public final void setTimestamp(@NotNull byte[] buf, int baseOffset, long timestamp) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            ByteArrayExtensionsKt.putInt(buf, baseOffset + 4, (int)timestamp);
        }

        public final long getSsrc(@NotNull byte[] buf, int baseOffset) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            return FieldParsersKt.getIntAsLong(buf, baseOffset + 8);
        }

        public final void setSsrc(@NotNull byte[] buf, int baseOffset, long ssrc2) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            ByteArrayExtensionsKt.putInt(buf, baseOffset + 8, (int)ssrc2);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Long> getCsrcs(@NotNull byte[] buf, int baseOffset) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(buf, "buf");
            int numCsrcs = this.getCsrcCount(buf, baseOffset);
            Iterable $this$map$iv = RangesKt.until(0, numCsrcs);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(FieldParsersKt.getIntAsLong(buf, 12 + 4 * it));
            }
            return CollectionsKt.toList((List)destination$iv$iv);
        }

        /*
         * WARNING - void declaration
         */
        public final void setCsrcs(@NotNull byte[] buf, int baseOffset, @NotNull List<Long> csrcs) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            Intrinsics.checkNotNullParameter(csrcs, "csrcs");
            Iterable $this$forEachIndexed$iv = csrcs;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void csrc;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                long l = ((Number)item$iv).longValue();
                int index = n;
                boolean bl = false;
                ByteArrayExtensionsKt.putInt(buf, 12 + 4 * index, (int)csrc);
            }
            this.setCsrcCount(buf, baseOffset, csrcs.size());
        }

        private final int getFixedHeaderAndCcLength(byte[] buf, int baseOffset) {
            return 12 + this.getCsrcCount(buf, baseOffset) * 4;
        }

        public final int getTotalLength(@NotNull byte[] buf, int baseOffset) {
            int n;
            Intrinsics.checkNotNullParameter(buf, "buf");
            int length = this.getFixedHeaderAndCcLength(buf, baseOffset);
            if (this.hasExtensions(buf, baseOffset)) {
                int extHeaderOffset = length;
                n = HeaderExtensionHelpers.Companion.getExtensionsTotalLength(buf, baseOffset + extHeaderOffset);
            } else {
                n = 0;
            }
            int extLength = n;
            return length + extLength;
        }

        public final int getExtensionsProfileType(@NotNull byte[] buf, int baseOffset) {
            int n;
            Intrinsics.checkNotNullParameter(buf, "buf");
            if (this.hasExtensions(buf, baseOffset)) {
                int extHeaderOffset = this.getFixedHeaderAndCcLength(buf, baseOffset);
                n = HeaderExtensionHelpers.Companion.getExtensionsProfileType(buf, baseOffset + extHeaderOffset);
            } else {
                n = -1;
            }
            return n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

